/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.ui.peer.swing;

import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import javax.swing.AbstractAction;
import javax.swing.JDialog;
import javax.swing.KeyStroke;
import oracle.bpm.ui.MenuBar;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.peer.PopUpWindowPeer;
import oracle.bpm.ui.peer.swing.SwingComponent;
import oracle.bpm.ui.peer.swing.SwingWindow;

public class SwingPopUpWindow
extends SwingWindow
implements PopUpWindowPeer {
    SwingPopUpWindow(SwingComponent parent, boolean modal, boolean resizeAllowed) {
        super(parent, new TinyWindow(modal, resizeAllowed));
    }

    @Override
    public void show(UiComponent relativeComponent) {
        this.getComponent().show(relativeComponent.asSwing());
    }

    @Override
    public void show(int x, int y) {
        this.getComponent().show(x, y);
    }

    @Override
    public void add(UiComponent component, Object constraints) {
        this.getContentPane().add(component, "Center");
    }

    @Override
    public void setMenuBar(MenuBar menubar) {
    }

    @Override
    protected Container getSwingContentPane() {
        return this.getComponent().getContentPane();
    }

    @Override
    protected TinyWindow getComponent() {
        return (TinyWindow)super.getComponent();
    }

    private static class TinyWindow
    extends JDialog {
        private boolean isModal;
        private boolean isResizable;

        public TinyWindow(boolean modal, boolean resizeAllowed) {
            this.isModal = modal;
            this.isResizable = resizeAllowed;
            this.init();
        }

        public void show(Component relativeComponent) {
            this.setResizable(this.isResizable);
            this.setModal(this.isModal);
            this.setUndecorated(true);
            this.pack();
            this.setLocationRelativeTo(relativeComponent);
            this.setVisible(true);
        }

        public void show(int x, int y) {
            this.setLocation(x, y);
            if (!this.isDisplayable()) {
                this.setResizable(this.isResizable);
                this.setModal(this.isModal);
                this.setUndecorated(true);
                this.pack();
            }
            this.setVisible(true);
        }

        private void init() {
            this.addCancelByEscapeKey();
            this.addWindowFocusListener(new WindowFocusListener(){

                @Override
                public void windowGainedFocus(WindowEvent e) {
                }

                @Override
                public void windowLostFocus(WindowEvent e) {
                    TinyWindow.this.setVisible(false);
                }
            });
        }

        private void addCancelByEscapeKey() {
            KeyStroke escape = KeyStroke.getKeyStroke(27, 0, false);
            AbstractAction escapeAction = new AbstractAction(){
                private static final long serialVersionUID = -573215314930701129L;

                @Override
                public void actionPerformed(ActionEvent e) {
                    TinyWindow.this.setVisible(false);
                }
            };
            this.getRootPane().getInputMap(2).put(escape, "ESCAPE");
            this.getRootPane().getActionMap().put("ESCAPE", escapeAction);
        }
    }
}

