/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.ui.peer.swing;

import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.MouseWheelEvent;
import javax.swing.JComponent;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import oracle.bpm.geom.Point;
import oracle.bpm.geom.Rectangle;
import oracle.bpm.ui.PaintCanvas;
import oracle.bpm.ui.event.PaintListener;
import oracle.bpm.ui.peer.PaintCanvasPeer;
import oracle.bpm.ui.peer.swing.AwtConverter;
import oracle.bpm.ui.peer.swing.SwingComponent;
import oracle.bpm.ui.peer.swing.SwingContainer;
import org.jetbrains.annotations.NotNull;

public class SwingPaintCanvas
extends SwingContainer
implements PaintCanvasPeer {
    SwingPaintCanvas(SwingComponent parent) {
        super(parent, null);
        this.setComponent(new ExtJComponent());
        this.getJComponent().setOpaque(true);
    }

    @Override
    public void putClientProperty(String key, Object value) {
        super.putClientProperty(key, value);
        PaintCanvas canvas = (PaintCanvas)this.getUiComponent();
        assert (canvas != null) : "Invalid PaintCanvas";
        ((ExtJComponent)this.getJComponent()).setPaintCanvas(canvas);
    }

    @Override
    public void addHorizontalAdjustmentListener(final oracle.bpm.ui.event.AdjustmentListener adjustListener) {
        JScrollPane grandParent = this.getJScrollPane();
        if (grandParent != null) {
            grandParent.getHorizontalScrollBar().addAdjustmentListener(new AdjustmentListener(){

                @Override
                public void adjustmentValueChanged(AdjustmentEvent e) {
                    adjustListener.adjustmentValueChanged(oracle.bpm.ui.event.AdjustmentEvent.create(e.getValue()));
                }
            });
        }
    }

    @Override
    public void addVerticalAdjustmentListener(final oracle.bpm.ui.event.AdjustmentListener adjustListener) {
        JScrollPane grandParent = this.getJScrollPane();
        if (grandParent != null) {
            grandParent.getVerticalScrollBar().addAdjustmentListener(new AdjustmentListener(){

                @Override
                public void adjustmentValueChanged(AdjustmentEvent e) {
                    adjustListener.adjustmentValueChanged(oracle.bpm.ui.event.AdjustmentEvent.create(e.getValue()));
                }
            });
        }
    }

    @Override
    public void scrollRectangleToVisible(@NotNull Rectangle rectangle) {
        JScrollPane grandParent = this.getJScrollPane();
        if (grandParent != null) {
            Point center = rectangle.getCenter();
            JScrollBar hScrollBar = grandParent.getHorizontalScrollBar();
            JScrollBar vScrollBar = grandParent.getVerticalScrollBar();
            Dimension size = grandParent.getSize();
            hScrollBar.setValue(center.getX() - (int)size.getWidth() / 2);
            vScrollBar.setValue(center.getY() - (int)size.getHeight() / 2);
        }
    }

    @Override
    public oracle.bpm.geom.Dimension getScrollPaneViewportSize() {
        return AwtConverter.fromAwt(this.getJScrollPane().getViewport().getSize());
    }

    @Override
    public void notifyMouseWheelEvent(@NotNull MouseWheelEvent event) {
        JScrollPane pane = this.getJScrollPane();
        if (pane != null) {
            JScrollBar scroll;
            JScrollBar jScrollBar = scroll = event.isShiftDown() ? pane.getHorizontalScrollBar() : pane.getVerticalScrollBar();
            if (scroll != null) {
                scroll.setValue(scroll.getValue() + scroll.getUnitIncrement() * event.getUnitsToScroll());
            }
        }
    }

    @Override
    public void addPaintListener(PaintListener listener) {
    }

    @Override
    public void removePaintListener(PaintListener listener) {
    }

    private JScrollPane getJScrollPane() {
        for (Container c = this.getJComponent(); c != null; c = c.getParent()) {
            if (!(c instanceof JScrollPane)) continue;
            return (JScrollPane)c;
        }
        return null;
    }

    private class ExtJComponent
    extends JComponent
    implements SwingComponent.ExtendedSwing {
        private PaintCanvas paintCanvas;

        public ExtJComponent() {
            this.setAutoscrolls(true);
        }

        public PaintCanvas getPaintCanvas() {
            return this.paintCanvas;
        }

        public void setPaintCanvas(PaintCanvas paintCanvas) {
            this.paintCanvas = paintCanvas;
        }

        public Dimension getPreferredScrollableViewportSize() {
            return this.getPreferredSize();
        }

        @Override
        public Dimension getMaximumSize() {
            return SwingComponent.asSwingDimension(SwingPaintCanvas.this.getUiComponent().getMaximumSize());
        }

        @Override
        public Dimension getMinimumSize() {
            if (SwingPaintCanvas.this.getOverridings().isOverridesMinimumSize()) {
                return SwingComponent.asSwingDimension(SwingPaintCanvas.this.getUiComponent().getMinimumSize());
            }
            return this.getDefaultMinimumSize();
        }

        @Override
        public Dimension getPreferredSize() {
            return SwingComponent.asSwingDimension(SwingPaintCanvas.this.getUiComponent().getPreferredSize());
        }

        @Override
        public Dimension getDefaultMaximumSize() {
            return super.getMaximumSize();
        }

        @Override
        public Dimension getDefaultMinimumSize() {
            return super.getMinimumSize();
        }

        @Override
        public void defaultPaint(Graphics graphics) {
            super.paint(graphics);
        }

        @Override
        public void defaultPaintComponent(Graphics graphics) {
            super.paintComponent(graphics);
        }

        @Override
        public void paint(Graphics g) {
            ((PaintCanvas)SwingPaintCanvas.this.getUiComponent()).paintCanvas(AwtConverter.fromAwt(g));
            super.paintChildren(g);
        }

        @Override
        public Dimension getDefaultPreferredSize() {
            return this.getPreferredSize();
        }

        @Override
        protected void paintComponent(Graphics g) {
            if (SwingPaintCanvas.this.getOverridings().isOverridesPaintComponent()) {
                SwingPaintCanvas.this.getUiComponent().paintComponent(AwtConverter.fromAwt(g));
            } else {
                this.defaultPaintComponent(g);
            }
        }
    }
}

