/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.ui.peer.swing;

import javax.swing.JFormattedTextField;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.text.JTextComponent;
import javax.swing.text.NumberFormatter;
import oracle.bpm.ui.event.ChangeListener;
import oracle.bpm.ui.peer.swing.SwingComponent;
import oracle.bpm.ui.peer.swing.SwingNumericField;
import oracle.bpm.ui.peer.swing.event.SwingChangeListener;

public class SwingNumericSpinner
extends SwingNumericField<Integer> {
    private SpinnerNumberModel spinnerModel;

    public SwingNumericSpinner(SwingComponent parent) {
        super(parent, Integer.class);
        this.createComponent();
    }

    @Override
    public void setRange(Integer minimum, Integer maximum) {
        this.spinnerModel.setMinimum(minimum);
        this.spinnerModel.setMaximum(maximum);
    }

    @Override
    public void setMinimum(Integer minimum) {
        this.spinnerModel.setMinimum(minimum);
    }

    @Override
    public void setMaximum(Integer maximum) {
        this.spinnerModel.setMaximum(maximum);
    }

    @Override
    public void setStepSize(Integer number) {
        this.spinnerModel.setStepSize(number);
    }

    @Override
    public JTextField getTextField() {
        JSpinner.NumberEditor editor = this.getEditor();
        return editor.getTextField();
    }

    @Override
    public void setValue(Integer number) {
        this.spinnerModel.setValue(number);
    }

    @Override
    public Integer getValue() {
        return (Integer)this.spinnerModel.getValue();
    }

    @Override
    public void addChangeListener(ChangeListener listener) {
        this.getSpinner().addChangeListener(SwingChangeListener.get(listener));
    }

    @Override
    public void removeChangeListener(ChangeListener listener) {
        this.getSpinner().removeChangeListener(SwingChangeListener.get(listener));
    }

    @Override
    protected JTextComponent getTextComponent() {
        return this.getTextField();
    }

    @Override
    protected void createComponent() {
        this.spinnerModel = new SpinnerNumberModel(0, 0, Integer.MAX_VALUE, 1);
        JSpinner jspinner = new JSpinner(this.spinnerModel);
        this.setComponent(jspinner);
        JSpinner.NumberEditor editor = (JSpinner.NumberEditor)this.getSpinner().getEditor();
        JFormattedTextField textField = editor.getTextField();
        this.setFormatter((NumberFormatter)textField.getFormatter());
    }

    private JSpinner.NumberEditor getEditor() {
        return (JSpinner.NumberEditor)this.getSpinner().getEditor();
    }

    private JSpinner getSpinner() {
        return (JSpinner)this.getJComponent();
    }
}

