/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.ui.peer.swing;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.DecimalFormat;
import javax.swing.JFormattedTextField;
import javax.swing.text.NumberFormatter;
import oracle.bpm.ui.event.ChangeListener;
import oracle.bpm.ui.peer.NumericFieldPeer;
import oracle.bpm.ui.peer.swing.SwingComponent;
import oracle.bpm.ui.peer.swing.SwingTextField;

public class SwingNumericField<E extends Number>
extends SwingTextField
implements NumericFieldPeer<E> {
    private Class<E> clazz;
    private NumberFormatter formatter;
    private int minimum;
    private int maximum;
    private E oldValue;
    private static final DecimalFormat DEFAULT_INTEGER_FORMAT = new DecimalFormat("##########");
    private static final DecimalFormat DEFAULT_FLOAT_FORMAT = new DecimalFormat(".000");

    SwingNumericField(SwingComponent parent, Class<E> clazz) {
        super(parent, null);
        this.clazz = clazz;
        this.createComponent();
    }

    @Override
    public void setAllowsInvalid(boolean allowsInvalid) {
        this.getFormatter().setAllowsInvalid(allowsInvalid);
    }

    @Override
    public void setGroupingSize(int grouping) {
        this.getFormat().setGroupingSize(grouping);
    }

    @Override
    public void setGroupingUsed(boolean used) {
        this.getFormat().setGroupingUsed(used);
    }

    @Override
    public void setLength(int length) {
        this.getFormat().setMaximumIntegerDigits(length);
    }

    @Override
    public int getLength() {
        return 0;
    }

    @Override
    public void setOverwriteMode(boolean mode) {
        this.getFormatter().setOverwriteMode(mode);
    }

    @Override
    public void setPattern(String pattern) {
        this.getFormatter().setFormat(new DecimalFormat(pattern));
    }

    @Override
    public void setRange(E minimum, E maximum) {
        NumberFormatter formatter = this.getFormatter();
        formatter.setMinimum((Comparable)minimum);
        formatter.setMaximum((Comparable)maximum);
        this.minimum = minimum != null ? ((Number)minimum).intValue() : Integer.MIN_VALUE;
        this.maximum = maximum != null ? ((Number)maximum).intValue() : Integer.MAX_VALUE;
    }

    @Override
    public void setMinimum(E minimum) {
        this.getFormatter().setMinimum((Comparable)minimum);
        this.minimum = minimum != null ? ((Number)minimum).intValue() : Integer.MIN_VALUE;
    }

    @Override
    public void setMaximum(E maximum) {
        this.getFormatter().setMaximum((Comparable)maximum);
        this.maximum = maximum != null ? ((Number)maximum).intValue() : Integer.MAX_VALUE;
    }

    @Override
    public E getMinimum() {
        return (E)((Number)((Object)this.getFormatter().getMinimum()));
    }

    @Override
    public E getMaximum() {
        return (E)((Number)((Object)this.getFormatter().getMaximum()));
    }

    @Override
    public void setScale(int scale) {
        this.getFormat().setMaximumFractionDigits(scale);
    }

    @Override
    public int getScale() {
        return this.getFormat().getMaximumFractionDigits();
    }

    @Override
    public void setSigned(boolean signed) {
    }

    @Override
    public void setStepSize(E number) {
    }

    @Override
    public void setValue(E number) {
        this.oldValue = number;
        this.getField().setValue(number);
    }

    @Override
    public String getText() {
        E value = this.getValue();
        return value != null ? value.toString() : null;
    }

    @Override
    public E getValue() {
        Number result = null;
        try {
            String text = super.getText();
            if (text == null || text.trim().equals("")) {
                text = "0";
            }
            if (this.clazz == Integer.class) {
                result = Integer.valueOf(text);
            } else if (this.clazz == Long.class) {
                result = Long.valueOf(text);
            } else if (this.clazz == Double.class) {
                result = Double.valueOf(text);
            } else if (this.clazz == Float.class) {
                result = Float.valueOf(text);
            } else if (this.clazz == Short.class) {
                result = Short.valueOf(text);
            } else if (this.clazz == BigDecimal.class) {
                result = new BigDecimal(text);
            } else if (this.clazz == BigInteger.class) {
                result = new BigInteger(text);
            }
        }
        catch (NumberFormatException e) {
            result = (Number)this.getMinimum();
        }
        this.oldValue = result;
        return (E)result;
    }

    @Override
    public void addChangeListener(ChangeListener listener) {
    }

    @Override
    public void removeChangeListener(ChangeListener listener) {
    }

    protected JFormattedTextField getField() {
        return (JFormattedTextField)this.getTextField();
    }

    protected void setFormatter(NumberFormatter formatter) {
        this.formatter = formatter;
    }

    protected NumberFormatter getFormatter() {
        return this.formatter;
    }

    protected void createComponent() {
        DecimalFormat decimalFormat = this.clazz == Integer.class || this.clazz == Long.class || this.clazz == Short.class ? DEFAULT_INTEGER_FORMAT : DEFAULT_FLOAT_FORMAT;
        NumberFormatter formatter = new NumberFormatter(decimalFormat);
        this.setFormatter(formatter);
        JFormattedTextField field = new JFormattedTextField(formatter);
        this.setComponent(field);
    }

    private DecimalFormat getFormat() {
        NumberFormatter formatter = this.getFormatter();
        DecimalFormat format = (DecimalFormat)formatter.getFormat();
        if (format == DEFAULT_INTEGER_FORMAT || format == DEFAULT_FLOAT_FORMAT) {
            format = (DecimalFormat)format.clone();
            formatter.setFormat(format);
        }
        return format;
    }
}

