/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.ui.peer.swing;

import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.event.MenuListener;
import oracle.bpm.ui.peer.MenuItemPeer;
import oracle.bpm.ui.peer.MenuPeer;
import oracle.bpm.ui.peer.swing.SwingComponent;
import oracle.bpm.ui.peer.swing.SwingMenuItem;
import oracle.bpm.ui.peer.swing.event.SwingMenuListener;

public class SwingMenu
extends SwingMenuItem
implements MenuPeer {
    SwingMenu(SwingComponent parent) {
        super(parent, new JMenu());
    }

    @Override
    public List<UiComponent> getChildren() {
        JMenu menu = this.getJMenu();
        Component[] components = menu.getMenuComponents();
        ArrayList<UiComponent> result = new ArrayList<UiComponent>();
        for (Component component : components) {
            if (!(component instanceof JMenuItem)) continue;
            result.add(UiComponent.get(component));
        }
        return result;
    }

    @Override
    public int getItemCount() {
        return this.getJMenu().getItemCount();
    }

    @Override
    public void add(MenuItemPeer peer) {
        SwingMenuItem menuItem = (SwingMenuItem)peer;
        this.getJMenu().add((JMenuItem)menuItem.getComponent());
    }

    @Override
    public void addMenuListener(MenuListener listener) {
        this.getJMenu().addMenuListener(SwingMenuListener.get(listener));
    }

    @Override
    public void addSeparator() {
        this.getJMenu().addSeparator();
    }

    @Override
    public void insert(MenuItemPeer item, int pos) {
        JMenuItem menuItem = (JMenuItem)((SwingMenuItem)item).getComponent();
        this.getJMenu().insert(menuItem, pos);
    }

    @Override
    public void removeAll() {
        this.getJMenu().removeAll();
    }

    @Override
    protected AbstractButton getAbstractButton() {
        return this.getJMenu();
    }

    private JMenu getJMenu() {
        return (JMenu)this.getComponent();
    }
}

