/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.ui.peer.swing;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.BorderFactory;
import javax.swing.FocusManager;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.JViewport;
import javax.swing.SwingConstants;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import oracle.bpm.lang.Str;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.AbstractButton;
import oracle.bpm.ui.UiManager;
import oracle.bpm.ui.msg.UIMsg;
import oracle.bpm.ui.peer.swing.AwtConverter;
import oracle.bpm.ui.statusbar.StatusBar;
import oracle.bpm.ui.utils.IconUtility;

public class SwingHScroll
extends JPanel
implements ActionListener,
SwingConstants {
    private Component component;
    private int currentX = 0;
    private int diff;
    private JButton eastButton;
    private float eval = 0.1f;
    private int increment = 22;
    private boolean isUpdating;
    private int targetX = 0;
    private Timer timer;
    private JViewport viewport;
    private JButton westButton;

    public SwingHScroll(Component component) {
        this.component = component;
        this.init(4);
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        Dimension viewportSize = this.viewport.getExtentSize();
        Dimension componentSize = this.viewport.getView().getPreferredSize();
        Point position = this.viewport.getViewPosition();
        int inc = this.getIncrement();
        if (event.getSource() == this.westButton) {
            if (componentSize.width > viewportSize.width) {
                this.eastButton.setEnabled(true);
            }
            if (position.x <= inc) {
                this.update(0, position.x);
                this.westButton.setEnabled(false);
            } else {
                this.update(position.x - inc, position.x);
                if (position.x == 0) {
                    this.westButton.setEnabled(false);
                }
            }
        } else if (event.getSource() == this.eastButton) {
            int max;
            if (componentSize.width > viewportSize.width) {
                this.westButton.setEnabled(true);
            }
            if (position.x >= (max = componentSize.width - viewportSize.width) - inc) {
                viewportSize = this.viewport.getExtentSize();
                int targetx = componentSize.width - viewportSize.width;
                this.update(targetx, position.x);
                this.eastButton.setEnabled(false);
            } else {
                this.update(position.x + inc, position.x);
            }
        } else if (event.getSource() == this.timer) {
            this.updateViewport();
        }
        this.revalidate();
    }

    public Component getComponent() {
        return this.component;
    }

    public int getIncrement() {
        return this.increment;
    }

    public void setIncrement(int increment) {
        this.increment = increment;
    }

    private JButton createButton(Msg msg) {
        JButton button = new JButton(msg.getString());
        ImageIcon icon = new ImageIcon(msg.getImageResource());
        Dimension buttonSize = new Dimension(icon.getIconWidth() + 4, 22);
        button.setText("");
        button.setIcon(icon);
        button.setEnabled(true);
        button.setFocusPainted(false);
        button.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        SwingButtonEffect.setEffect(button);
        button.setMinimumSize(buttonSize);
        button.setPreferredSize(buttonSize);
        button.setMaximumSize(buttonSize);
        return button;
    }

    private ChangeListener createChangeListener() {
        return new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                if (SwingHScroll.this.isUpdating) {
                    return;
                }
                JViewport viewport = (JViewport)e.getSource();
                if (viewport == null || viewport.getView() == null) {
                    return;
                }
                Dimension componentSize = viewport.getView().getPreferredSize();
                Dimension viewportSize = viewport.getExtentSize();
                int compWidth = componentSize.width;
                int viewWidth = viewportSize.width;
                SwingHScroll.this.eastButton.setEnabled(false);
                if (compWidth > viewWidth) {
                    SwingHScroll.this.eastButton.setEnabled(true);
                } else {
                    SwingHScroll.this.westButton.setEnabled(false);
                    SwingHScroll.this.eastButton.setEnabled(false);
                }
                SwingHScroll.this.updateLayout();
            }
        };
    }

    private JButton createSeparator() {
        Msg msg = UIMsg.HTOOLBAR_SEP;
        JButton button = new JButton(msg.getString());
        ImageIcon icon = new ImageIcon(msg.getImageResource());
        Dimension buttonSize = new Dimension(icon.getIconWidth(), icon.getIconHeight());
        button.setText("");
        button.setIcon(icon);
        button.setEnabled(true);
        button.setBorder(null);
        button.setFocusPainted(false);
        button.setMinimumSize(buttonSize);
        button.setPreferredSize(buttonSize);
        button.setMaximumSize(buttonSize);
        button.setEnabled(false);
        return button;
    }

    private void init(int buttonPosition) {
        this.setLayout(new BorderLayout());
        this.viewport = new JViewport();
        this.viewport.setView(this.component);
        this.add((Component)this.viewport, "Center");
        this.westButton = this.createButton(UIMsg.HTOOLBAR_LEFT);
        this.eastButton = this.createButton(UIMsg.HTOOLBAR_RIGHT);
        this.layoutButtons(buttonPosition);
        this.westButton.setEnabled(false);
        this.eastButton.setEnabled(false);
        this.viewport.addChangeListener(this.createChangeListener());
        this.westButton.addActionListener(this);
        this.eastButton.addActionListener(this);
        this.timer = new Timer(20, this);
        this.timer.setCoalesce(true);
        this.timer.setRepeats(true);
    }

    private void layoutButtons(int buttonPosition) {
        if (buttonPosition == 0) {
            this.add((Component)this.eastButton, "East");
            this.add((Component)this.westButton, "West");
        } else if (buttonPosition == 2) {
            JPanel panel = new JPanel(new FlowLayout(1, 0, 0));
            panel.add(this.westButton);
            panel.add(this.eastButton);
            this.add((Component)panel, "West");
        } else {
            JPanel panel = new JPanel(new FlowLayout(1, 0, 0));
            panel.add(this.westButton);
            panel.add(this.eastButton);
            this.add((Component)panel, "East");
        }
    }

    private void startTimer() {
        this.timer.start();
    }

    private void stopTimer() {
        this.timer.stop();
        this.isUpdating = false;
    }

    private void update(int target, int current) {
        this.isUpdating = true;
        this.targetX = target;
        this.currentX = current;
        this.diff = target - current;
        this.startTimer();
    }

    private void updateLayout() {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                SwingHScroll.this.revalidate();
                SwingHScroll.this.repaint();
            }
        };
        SwingUtilities.invokeLater(runnable);
    }

    private void updateViewport() {
        this.eval = (float)((double)this.eval + 0.1);
        this.currentX = (int)((float)this.currentX + (float)this.diff * this.eval);
        if (this.diff >= 0) {
            if (this.currentX >= this.targetX) {
                this.currentX = this.targetX;
                this.eval = 0.1f;
                this.viewport.setViewPosition(new Point(this.currentX, 0));
                this.stopTimer();
                return;
            }
        } else if (this.targetX >= this.currentX) {
            this.currentX = this.targetX;
            this.eval = 0.1f;
            this.viewport.setViewPosition(new Point(this.currentX, 0));
            this.stopTimer();
            return;
        }
        this.viewport.setViewPosition(new Point(this.currentX, 0));
    }

    private static class SwingButtonEffect {
        public static final String RESTORE_ON_PRESS = "oracle.bpm.ui.button.effect.restoreOnPress";
        private static final Color selectedBgColor_sd = AwtConverter.toAwt(UiManager.color("FuegoButton.selectedBackground"));
        private static final Color pressedBgColor = AwtConverter.toAwt(UiManager.color("FuegoButton.pressedBackground"));

        private SwingButtonEffect() {
        }

        public static void setEffect(AbstractButton button) {
            if (button.isSwing()) {
                SwingButtonEffect.setEffect((javax.swing.AbstractButton)button.asSwing());
            }
        }

        public static void setEffect(javax.swing.AbstractButton button) {
            boolean isToggleButton;
            boolean bl = isToggleButton = button instanceof JToggleButton && !(button instanceof JCheckBox) && !(button instanceof JRadioButton);
            if (isToggleButton) {
                button.addItemListener(SwingButtonEffect.createItemListener(button));
                if (button.isSelected()) {
                    SwingButtonEffect.selectToggleButton(button);
                }
            }
            EffectManager manager = SwingButtonEffect.createEffectManager(button, isToggleButton);
            button.addMouseListener(SwingButtonEffect.createMouseListener(manager));
            button.addFocusListener(SwingButtonEffect.createFocusListener(manager));
            button.addPropertyChangeListener("oracle.bpm.action.msg", SwingButtonEffect.createPropertyChangeListener(manager));
            button.setRequestFocusEnabled(false);
        }

        private static boolean isInSameToolbar(javax.swing.AbstractButton currentButton, Component c) {
            JToolBar curentToolbar = SwingButtonEffect.getParentToolbar(currentButton);
            return curentToolbar != null && curentToolbar == SwingButtonEffect.getParentToolbar(c);
        }

        private static JToolBar getParentToolbar(Component c) {
            while (c != null) {
                if (c instanceof JToolBar) {
                    return (JToolBar)c;
                }
                c = c.getParent();
            }
            return null;
        }

        private static EffectManager createEffectManager(javax.swing.AbstractButton button, boolean toggleButton) {
            return new EffectManager(button, toggleButton);
        }

        private static FocusListener createFocusListener(EffectManager manager) {
            return new EffectFocusListener(manager);
        }

        private static ItemListener createItemListener(final javax.swing.AbstractButton button) {
            return new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    JToggleButton tb = (JToggleButton)e.getSource();
                    if (tb.isSelected()) {
                        SwingButtonEffect.selectToggleButton(button);
                    } else if (!tb.isSelected()) {
                        boolean clickOnIt;
                        Boolean o = (Boolean)tb.getClientProperty("oracle.bpm.clickOnIt");
                        boolean bl = clickOnIt = o != null && o != false;
                        if (!clickOnIt) {
                            tb.setBackground(tb.getParent().getBackground());
                            tb.setBorderPainted(false);
                        }
                    }
                }
            };
        }

        private static MouseListener createMouseListener(EffectManager manager) {
            return new EffectMouseAdapter(manager);
        }

        private static PropertyChangeListener createPropertyChangeListener(EffectManager manager) {
            return new EffectButtonIconChanger(manager);
        }

        private static void selectToggleButton(javax.swing.AbstractButton button) {
            button.setBackground(pressedBgColor);
            button.setBorder(oracle.bpm.ui.border.BorderFactory.createLineBorder(oracle.bpm.draw.Color.FUEGO_BLUE).asSwing());
            button.setBorderPainted(true);
        }

        private static class EffectManager {
            Color defaultBgColor = null;
            Icon icon = null;
            String previousMessage = null;
            Icon shadow = null;
            StatusBar statusBar = null;
            boolean toggleButton;
            private javax.swing.AbstractButton button;
            private boolean in = false;

            public EffectManager(javax.swing.AbstractButton button, boolean toggleButton) {
                this.button = button;
                this.toggleButton = toggleButton;
            }

            public javax.swing.AbstractButton getButton() {
                return this.button;
            }

            public void setIcon(Icon icon) {
                this.icon = icon;
            }

            public void setIn(boolean in) {
                this.in = in;
            }

            public boolean isIn() {
                return this.in;
            }

            public void activated() {
                if (this.icon != null) {
                    this.button.setIcon(this.icon);
                }
                this.setBackground(pressedBgColor);
            }

            public void applyEffect() {
                this.button.setIcon(this.shadow == null ? null : this.shadow);
                this.setBackground(selectedBgColor_sd);
            }

            public void focusEntered() {
                this.focusEntered(true);
            }

            public void focusEntered(boolean paintFocus) {
                this.in = true;
                this.icon = this.button.getIcon();
                if (this.toggleButton) {
                    this.button.putClientProperty("oracle.bpm.clickOnIt", Boolean.TRUE);
                }
                if (!(!paintFocus || this.toggleButton && this.button.isSelected())) {
                    this.defaultBgColor = this.button.getParent().getBackground();
                    this.shadow = this.icon != null ? IconUtility.createShadowedImage((ImageIcon)this.button.getIcon(), selectedBgColor_sd) : this.icon;
                    this.applyEffect();
                    this.button.setBorder(oracle.bpm.ui.border.BorderFactory.createLineBorder(oracle.bpm.draw.Color.FUEGO_BLUE).asSwing());
                    this.button.setBorderPainted(true);
                }
                if (this.statusBar != null) {
                    String toolTip = this.button.getToolTipText();
                    if (!Str.isEmpty(toolTip)) {
                        this.statusBar.showNotice(toolTip);
                        this.previousMessage = toolTip;
                    } else {
                        this.statusBar.clearMessage();
                    }
                }
            }

            public void focusExited() {
                if (this.in) {
                    if (!this.toggleButton || !this.button.isSelected()) {
                        this.restoreButton();
                    }
                    this.in = false;
                    if (this.toggleButton) {
                        this.button.putClientProperty("oracle.bpm.clickOnIt", null);
                    }
                }
                if (this.statusBar != null && this.previousMessage != null && this.previousMessage.equals(this.statusBar.getCurrentMessage())) {
                    this.statusBar.clearMessage();
                }
            }

            public void updateShadowIcon() {
                this.shadow = IconUtility.createShadowedImage((ImageIcon)this.icon, selectedBgColor_sd);
                this.applyEffect();
            }

            protected void restoreButton() {
                this.setBackground(this.defaultBgColor);
                this.button.setIcon(this.icon == null ? null : this.icon);
                this.button.setBorderPainted(false);
            }

            private void setBackground(Color color) {
                this.button.setBackground(color);
            }
        }

        public static class EffectMouseAdapter
        implements MouseListener {
            EffectManager effectManager;

            public EffectMouseAdapter(EffectManager effectManager) {
                this.effectManager = effectManager;
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                Component c = FocusManager.getCurrentManager().getFocusOwner();
                if (SwingButtonEffect.isInSameToolbar(this.effectManager.getButton(), c)) {
                    this.effectManager.getButton().requestFocus();
                } else {
                    this.effectManager.focusEntered(this.effectManager.getButton().isEnabled());
                }
            }

            @Override
            public void mouseExited(MouseEvent e) {
                if (!this.effectManager.getButton().hasFocus()) {
                    this.effectManager.focusExited();
                }
            }

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
            }

            @Override
            public void mousePressed(MouseEvent e) {
                if (this.effectManager.getButton().isEnabled()) {
                    boolean restoreOnPress;
                    Object restoreProperty = this.effectManager.getButton().getClientProperty(SwingButtonEffect.RESTORE_ON_PRESS);
                    boolean bl = restoreOnPress = restoreProperty != null && Boolean.TRUE.equals(restoreProperty);
                    if (restoreOnPress) {
                        this.mouseExited(e);
                    } else {
                        this.effectManager.activated();
                    }
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (this.effectManager.getButton().isEnabled()) {
                    if (this.effectManager.isIn() && (!this.effectManager.toggleButton || this.effectManager.toggleButton && !this.effectManager.getButton().isSelected())) {
                        this.effectManager.applyEffect();
                    }
                } else {
                    this.effectManager.restoreButton();
                    this.effectManager.setIn(false);
                }
            }
        }

        public static class EffectFocusListener
        implements FocusListener {
            private EffectManager manager;

            public EffectFocusListener(EffectManager manager) {
                this.manager = manager;
            }

            @Override
            public void focusGained(FocusEvent e) {
                this.manager.focusEntered();
            }

            @Override
            public void focusLost(FocusEvent e) {
                this.manager.focusExited();
            }
        }

        public static class EffectButtonIconChanger
        implements PropertyChangeListener {
            private EffectManager effectManager;

            public EffectButtonIconChanger(EffectManager manager) {
                this.effectManager = manager;
            }

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getNewValue() != null && evt.getNewValue() instanceof Msg && this.effectManager.isIn()) {
                    Msg m = (Msg)evt.getNewValue();
                    this.effectManager.setIcon(new ImageIcon(m.getImageResource()));
                    this.effectManager.updateShadowIcon();
                }
            }
        }
    }
}

