/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.ui.peer.swing;

import java.awt.AlphaComposite;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.image.ImageObserver;
import java.text.AttributedCharacterIterator;
import oracle.bpm.draw.AbstractGraphics;
import oracle.bpm.draw.AntialiasingMode;
import oracle.bpm.draw.Color;
import oracle.bpm.draw.FontMetrics;
import oracle.bpm.draw.GradientPattern;
import oracle.bpm.draw.Graphics;
import oracle.bpm.draw.InterpolationQuality;
import oracle.bpm.draw.Pattern;
import oracle.bpm.draw.RenderingMode;
import oracle.bpm.draw.StrokeControlMode;
import oracle.bpm.geom.Ellipse;
import oracle.bpm.geom.Rectangle;
import oracle.bpm.ui.Image;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.peer.swing.AwtConverter;

public class SwingGraphics
extends AbstractGraphics
implements Graphics {
    private oracle.bpm.draw.Stroke currentStroke = oracle.bpm.draw.Stroke.ONE_SOLID;
    private java.awt.Graphics graphics;

    private SwingGraphics(java.awt.Graphics graphics) {
        this.graphics = graphics;
    }

    public java.awt.Graphics getAwtGraphics() {
        return this.getGraphics();
    }

    @Override
    public void setBackground(Color color) {
        this.getGraphics2D().setBackground(AwtConverter.toAwt(color));
    }

    @Override
    public void setClip(int x, int y, int width, int height) {
        this.getGraphics().setClip(x, y, width, height);
    }

    @Override
    public Rectangle getClipBounds() {
        return AwtConverter.fromAwt(this.getGraphics().getClipBounds());
    }

    @Override
    public void setFont(oracle.bpm.draw.Font font) {
        this.getGraphics().setFont(font != null ? AwtConverter.toAwt(font) : null);
    }

    @Override
    public oracle.bpm.draw.Font getFont() {
        return oracle.bpm.draw.Font.valueOf(this.getGraphics().getFont());
    }

    @Override
    public FontMetrics getFontMetrics() {
        return AwtConverter.fromAwt(this.getGraphics().getFontMetrics());
    }

    @Override
    public FontMetrics getFontMetrics(oracle.bpm.draw.Font f) {
        return AwtConverter.fromAwt(this.getGraphics().getFontMetrics(AwtConverter.toAwt(f)));
    }

    @Override
    public void setForeground(Color c) {
        this.getGraphics().setColor(AwtConverter.toAwt(c));
    }

    @Override
    public Color getForeground() {
        return AwtConverter.fromAwt(this.getGraphics().getColor());
    }

    @Override
    public void setStroke(oracle.bpm.draw.Stroke stroke) {
        this.currentStroke = stroke;
        Stroke s = stroke.asAwt();
        this.getGraphics2D().setStroke(s);
    }

    @Override
    public oracle.bpm.draw.Stroke getStroke() {
        return this.currentStroke;
    }

    @Override
    public void clearRect(int x, int y, int width, int height) {
        this.getGraphics().clearRect(x, y, width, height);
    }

    @Override
    public Graphics create(int x, int y, int width, int height) {
        return SwingGraphics.createGraphics(this.getGraphics().create(x, y, width, height));
    }

    @Override
    public void dispose() {
        this.getGraphics().dispose();
    }

    @Override
    public void draw(Shape shape) {
        this.getGraphics2D().draw(shape);
    }

    @Override
    public boolean drawImage(Image img, int x, int y, UiComponent observer) {
        return this.getGraphics().drawImage(img.asAwtImage(), x, y, new ImageObserver(){

            @Override
            public boolean imageUpdate(java.awt.Image img, int infoflags, int x, int y, int width, int height) {
                return true;
            }
        });
    }

    @Override
    public boolean drawImage(Image img, int x, int y, int width, int height, UiComponent observer) {
        boolean result;
        if (img == null || img.asAwtImage() == null) {
            throw new IllegalArgumentException("Null image");
        }
        float alpha = (float)this.getGraphics().getColor().getAlpha() / 255.0f;
        if (alpha != 1.0f) {
            this.getGraphics2D().setComposite(AlphaComposite.getInstance(3, alpha));
            result = this.getGraphics().drawImage(img.asAwtImage(), x, y, width, height, this.getSwingObserver(observer));
            this.getGraphics2D().setComposite(AlphaComposite.SrcOver);
        } else {
            result = this.getGraphics().drawImage(img.asAwtImage(), x, y, width, height, this.getSwingObserver(observer));
        }
        return result;
    }

    @Override
    public boolean drawImage(Image img, int x, int y, Color bgcolor, UiComponent observer) {
        return this.getGraphics().drawImage(img.asAwtImage(), x, y, AwtConverter.toAwt(bgcolor), observer.asSwing());
    }

    @Override
    public void drawLine(int x1, int y1, int x2, int y2) {
        this.getGraphics().drawLine(x1, y1, x2, y2);
    }

    @Override
    public void drawRoundRect(int x, int y, int width, int height, int arcWidth, int arcHeight) {
        this.getGraphics().drawRoundRect(x, y, width, height, arcWidth, arcHeight);
    }

    @Override
    public void fillRoundRect(int x, int y, int width, int height, int arcWidth, int arcHeight) {
        this.getGraphics().fillRoundRect(x, y, width, height, arcWidth, arcHeight);
    }

    @Override
    public void drawPolygon(int[] xPoints, int[] yPoints, int nPoints) {
        this.getGraphics().drawPolygon(xPoints, yPoints, nPoints);
    }

    @Override
    public void fillPolygon(int[] xPoints, int[] yPoints, int nPoints) {
        this.getGraphics().fillPolygon(xPoints, yPoints, nPoints);
    }

    @Override
    public void drawRect(int x, int y, int width, int height) {
        this.getGraphics().drawRect(x, y, width, height);
    }

    @Override
    public void drawOval(int x, int y, int width, int height) {
        this.getGraphics().drawOval(x, y, width, height);
    }

    @Override
    public void drawArc(int x, int y, int width, int height, int startAngle, int arcAngle) {
        this.getGraphics().drawArc(x, y, width, height, startAngle, arcAngle);
    }

    @Override
    public void fillArc(int x, int y, int width, int height, int startAngle, int arcAngle) {
        this.getGraphics().fillArc(x, y, width, height, startAngle, arcAngle);
    }

    @Override
    public void drawString(String str, int x, int y) {
        this.getGraphics().drawString(str, x, y);
    }

    @Override
    public void drawString(AttributedCharacterIterator iterator, int x, int y) {
        this.getGraphics().drawString(iterator, x, y);
    }

    @Override
    public void drawVerticalString(String str, int x, int y, int style) {
        Font f = this.getGraphics().getFont();
        AffineTransform tr = new AffineTransform();
        double angle = 0.0;
        int xMod = 0;
        int yMod = 0;
        if (style == 128) {
            angle = -1.5707963267948966;
        } else if (style == 1024) {
            angle = 1.5707963267948966;
            this.getGraphics().setFont(f);
            xMod = this.getFontMetrics(AwtConverter.fromAwt(f)).getHeight();
            yMod = this.getFontMetrics(AwtConverter.fromAwt(f)).stringWidth(str);
        }
        tr.rotate(angle);
        Font awtFont = f.deriveFont(tr);
        this.getGraphics().setFont(awtFont);
        this.drawString(str, x - xMod, y - yMod);
    }

    @Override
    public void fill(Shape s) {
        this.getGraphics2D().fill(s);
    }

    @Override
    public void fill(Ellipse e) {
        this.fillOval(e.getX(), e.getY(), e.getWidth(), e.getHeight());
    }

    @Override
    public void fillOval(int x, int y, int width, int height) {
        this.getGraphics().fillOval(x, y, width, height);
    }

    @Override
    public void fillPolygon(Polygon p) {
        this.getGraphics().fillPolygon(p);
    }

    @Override
    public void fillRect(int x, int y, int width, int height) {
        this.getGraphics().fillRect(x, y, width, height);
    }

    public void finalize() {
        this.getGraphics().finalize();
    }

    @Override
    public void rotate(double theta) {
        this.getGraphics2D().rotate(theta);
    }

    @Override
    public void scale(double sx, double sy) {
        this.getGraphics2D().scale(sx, sy);
    }

    public String toString() {
        return String.valueOf(this.getGraphics());
    }

    @Override
    public void translate(int x, int y) {
        this.getGraphics().translate(x, y);
    }

    @Override
    public void translate(double tx, double ty) {
        this.getGraphics2D().translate(tx, ty);
    }

    @Override
    public void setAntialiasing(AntialiasingMode mode) {
        switch (mode) {
            case ON: {
                this.getGraphics2D().setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                break;
            }
            case OFF: {
                this.getGraphics2D().setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
                break;
            }
            default: {
                this.getGraphics2D().setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_DEFAULT);
            }
        }
    }

    @Override
    public AntialiasingMode getAntialiasing() {
        Object antialiasing = this.getGraphics2D().getRenderingHint(RenderingHints.KEY_ANTIALIASING);
        if (antialiasing.equals(RenderingHints.VALUE_ANTIALIAS_ON)) {
            return AntialiasingMode.ON;
        }
        if (antialiasing.equals(RenderingHints.VALUE_ANTIALIAS_OFF)) {
            return AntialiasingMode.OFF;
        }
        return AntialiasingMode.DEFAULT;
    }

    @Override
    public void setTextAntialiasing(AntialiasingMode mode) {
        switch (mode) {
            case ON: {
                this.getGraphics2D().setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
                break;
            }
            case OFF: {
                this.getGraphics2D().setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_OFF);
                break;
            }
            default: {
                this.getGraphics2D().setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_DEFAULT);
            }
        }
    }

    @Override
    public void setRenderingAlgorithm(RenderingMode mode) {
        switch (mode) {
            case SPEED: {
                this.getGraphics2D().setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_SPEED);
                break;
            }
            case QUALITY: {
                this.getGraphics2D().setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
                break;
            }
            default: {
                this.getGraphics2D().setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_DEFAULT);
            }
        }
    }

    @Override
    public void setRenderingInterpolation(InterpolationQuality quality) {
        switch (quality) {
            case NONE: {
                break;
            }
            case LOW: {
                this.getGraphics2D().setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
                break;
            }
            case HIGH: {
                this.getGraphics2D().setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
                break;
            }
            default: {
                this.getGraphics2D().setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR);
            }
        }
    }

    @Override
    public void setPattern(Pattern pattern) {
        if (pattern instanceof GradientPattern) {
            GradientPattern gp = (GradientPattern)pattern;
            float x1 = gp.getFromPoint().getX();
            float y1 = gp.getFromPoint().getY();
            float x2 = gp.getToPoint().getX();
            float y2 = gp.getToPoint().getY();
            java.awt.Color color1 = AwtConverter.toAwt(gp.getColor1());
            java.awt.Color color2 = AwtConverter.toAwt(gp.getColor2());
            this.getGraphics2D().setPaint(new GradientPaint(x1, y1, color1, x2, y2, color2));
        }
    }

    @Override
    public void setStrokeControl(StrokeControlMode mode) {
        switch (mode) {
            case NORMALIZE: {
                this.getGraphics2D().setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_NORMALIZE);
                break;
            }
            case PURE: {
                this.getGraphics2D().setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
                break;
            }
            default: {
                this.getGraphics2D().setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_DEFAULT);
            }
        }
    }

    @Override
    public boolean isDisposed() {
        return false;
    }

    @Override
    public void setElements(float v0, float v1, float v2, float v3, float v4, float v5) {
    }

    public Object getClientProperty(String key) {
        return null;
    }

    public void putClientProperty(String key, Object value) {
    }

    static Graphics createGraphics(java.awt.Graphics graphics) {
        return new SwingGraphics(graphics);
    }

    private ImageObserver getSwingObserver(UiComponent observer) {
        ImageObserver nativeObserver = observer != null ? observer.asSwing() : new ImageObserver(){

            @Override
            public boolean imageUpdate(java.awt.Image img, int infoflags, int x, int y, int width, int height) {
                return true;
            }
        };
        return nativeObserver;
    }

    private java.awt.Graphics getGraphics() {
        return this.graphics;
    }

    private Graphics2D getGraphics2D() {
        assert (this.getGraphics() instanceof Graphics2D);
        return (Graphics2D)this.getGraphics();
    }
}

