/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.ui.peer.swing;

import java.awt.Font;
import javax.swing.plaf.FontUIResource;
import javax.swing.text.StyleContext;

public class SwingFontUtils {
    public static final String HTML_FONT_NAME = "Verdana";

    private SwingFontUtils() {
    }

    public static Font derive(Font font, int style) {
        return SwingFontUtils.derive(font, style, font.getSize());
    }

    public static Font derive(Font font, float size) {
        return SwingFontUtils.derive(font, font.getStyle(), size);
    }

    public static Font derive(Font font, int style, float size) {
        return SwingFontUtils.create(font.getFamily(), style, (int)size);
    }

    public static Font create(String family, int style, int size) {
        return StyleContext.getDefaultStyleContext().getFont(family, style, size);
    }

    public static Font deriveInFont(Font font, String textToRender, int style) {
        Font newFont = SwingFontUtils.derive(font, style, font.getSize());
        if (newFont instanceof FontUIResource) {
            newFont = font.deriveFont(style, font.getSize());
            if (!SwingFontUtils.canDisplay(newFont, textToRender)) {
                newFont = new Font("Dialog", font.getStyle(), font.getSize());
            }
            if (!SwingFontUtils.canDisplay(newFont, textToRender)) {
                newFont = new Font("Monospaced", font.getStyle(), font.getSize());
            }
        }
        return newFont;
    }

    public static Font decode(String str) {
        Font tmpFont = Font.decode(str);
        return SwingFontUtils.derive(tmpFont, tmpFont.getStyle());
    }

    private static boolean canDisplay(Font font, String textToRender) {
        return font.canDisplayUpTo(textToRender) == -1;
    }
}

