/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.ui.peer.swing;

import java.awt.Component;
import java.beans.PropertyChangeListener;
import java.io.File;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.peer.FileChooserPeer;
import oracle.bpm.ui.peer.swing.SwingPeer;
import oracle.bpm.util.FileFilter;

class SwingFileChooser
extends SwingPeer
implements FileChooserPeer {
    private JComponent component = new ExtendedFileChooser();

    @Override
    public void setAcceptAllFileFilterUsed(boolean acceptAll) {
        this.getFileChooser().setAcceptAllFileFilterUsed(acceptAll);
    }

    @Override
    public void setAccessory(UiComponent accessory) {
        this.getFileChooser().setAccessory(SwingFileChooser.asSwing(accessory));
    }

    @Override
    public FileFilter[] getChoosableFileFilters() {
        javax.swing.filechooser.FileFilter[] filters = this.getFileChooser().getChoosableFileFilters();
        for (int i = 0; i < filters.length; ++i) {
            if (filters[i] instanceof FileFilter) continue;
            throw new RuntimeException("Filter '" + filters[i].getDescription() + "' is is not an instance of oracle.bpm.util.FileFilter");
        }
        FileFilter[] myFilters = new FileFilter[filters.length];
        System.arraycopy(filters, 0, myFilters, 0, filters.length);
        return myFilters;
    }

    @Override
    public void setCurrentDirectory(File currentDirectory) {
        this.getFileChooser().setCurrentDirectory(currentDirectory);
    }

    @Override
    public File getCurrentDirectory() {
        return this.getFileChooser().getCurrentDirectory();
    }

    public void setEnabled(boolean enabled) {
        this.getFileChooser().setEnabled(enabled);
    }

    public boolean isEnabled() {
        return this.getFileChooser().isEnabled();
    }

    @Override
    public void setFileFilter(FileFilter filter) {
        this.getFileChooser().setFileFilter(filter);
    }

    @Override
    public FileFilter getFileFilter() {
        return (FileFilter)this.getFileChooser().getFileFilter();
    }

    public void setMultiSelectionEnabled(boolean enabled) {
        this.getFileChooser().setMultiSelectionEnabled(enabled);
    }

    @Override
    public void setSelectedFile(File file) {
        this.getFileChooser().setSelectedFile(file);
    }

    @Override
    public File getSelectedFile() {
        return this.getFileChooser().getSelectedFile();
    }

    @Override
    public void setSelectedFiles(File[] files) {
        this.getFileChooser().setSelectedFiles(files);
    }

    @Override
    public File[] getSelectedFiles() {
        return this.getFileChooser().getSelectedFiles();
    }

    public void setSize(int width, int height) {
        this.getFileChooser().setSize(width, height);
    }

    public void setVisible(boolean enabled) {
        this.getFileChooser().setVisible(enabled);
    }

    public boolean isVisible() {
        return this.getFileChooser().isVisible();
    }

    @Override
    public void addChoosableFileFilter(FileFilter filter) {
        this.getFileChooser().addChoosableFileFilter(filter);
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.getFileChooser().addPropertyChangeListener(listener);
    }

    @Override
    public void internalFireProperyChange(String propertyName, Object oldValue, Object newValue) {
        this.getFileChooser().internalFireProperyChange(propertyName, oldValue, newValue);
    }

    public void pack() {
    }

    @Override
    public int showOpenDialog(UiComponent parent, Msg title, int fileMode) {
        return this.show(parent, title, 2, fileMode);
    }

    @Override
    public int showSaveDialog(UiComponent parent, Msg title) {
        return this.show(parent, title, 3, 0);
    }

    @Override
    public void setFileSelectionMode(int fileSelectionMode) {
        this.getFileChooser().setFileSelectionMode(fileSelectionMode);
    }

    protected static JComponent asSwing(UiComponent component) {
        return component != null ? component.asSwing() : null;
    }

    private ExtendedFileChooser getFileChooser() {
        return (ExtendedFileChooser)this.component;
    }

    private int show(UiComponent uiParent, Msg title, int dialogMode, int fileMode) {
        Component parent = uiParent != null ? (Component)uiParent.getNative() : null;
        ExtendedFileChooser fileChooser = this.getFileChooser();
        fileChooser.setDialogTitle(title.getString());
        fileChooser.setMultiSelectionEnabled(fileMode == 1);
        int choice = dialogMode == 2 ? fileChooser.showOpenDialog(parent) : fileChooser.showSaveDialog(parent);
        switch (choice) {
            case 0: {
                return 0;
            }
        }
        return 1;
    }

    private static class ExtendedFileChooser
    extends JFileChooser {
        static final long serialVersionUID = -3096676410777709741L;
        static final long serialCheck = -1919921981352153672L;

        @Override
        public javax.swing.filechooser.FileFilter getAcceptAllFileFilter() {
            return FileFilter.ALL_FILES;
        }

        @Override
        public void setFileFilter(javax.swing.filechooser.FileFilter filter) {
            assert (filter == null || filter instanceof FileFilter) : "Invalid filter '" + filter.getDescription() + "', with class '" + filter.getClass() + "'";
            super.setFileFilter(filter);
        }

        @Override
        public void addChoosableFileFilter(javax.swing.filechooser.FileFilter filter) {
            assert (filter instanceof FileFilter) : "Invalid filter '" + filter.getDescription() + "', with class '" + filter.getClass() + "'";
            super.addChoosableFileFilter(filter);
        }

        public void internalFireProperyChange(String propertyName, Object oldValue, Object newValue) {
            this.firePropertyChange(propertyName, oldValue, newValue);
        }
    }
}

