/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.ui.peer.swing;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.Image;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.msg.UIMsg;
import oracle.bpm.ui.peer.ExpandBarPeer;
import oracle.bpm.ui.peer.swing.SwingComponent;
import oracle.bpm.ui.peer.swing.SwingContainer;

public class SwingExpandBar
extends SwingContainer
implements ExpandBarPeer {
    private static final Icon COLLAPSED = Image.create(UIMsg.LEFT_ARROW).asSwingIcon();
    private static final Icon EXPANDED = Image.create(UIMsg.DOWN_ARROW).asSwingIcon();

    SwingExpandBar(SwingComponent parent) {
        super(parent);
        this.setComponent(new FooExpandBar());
    }

    @Override
    public void add(UiComponent component, Msg msg, boolean isExpanded) {
        this.getExpandBar().addItem(new FooExpandItem(SwingExpandBar.asSwing(component), msg.getString()));
    }

    @Override
    public void add(UiComponent component, Image img, boolean isExpanded) {
    }

    @Override
    public void setSpacing(int spacing) {
    }

    private FooExpandBar getExpandBar() {
        return (FooExpandBar)this.getComponent();
    }

    public class FooExpandItem
    extends JPanel {
        private final JButton button;
        private final JComponent component;

        public FooExpandItem(JComponent component, String text) {
            super(new BorderLayout());
            this.button = this.createToggleButton(text);
            this.component = component;
            this.build();
        }

        private JButton createToggleButton(String text) {
            JButton jButton = new JButton(new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (FooExpandItem.this.isExpanded()) {
                        FooExpandItem.this.button.setIcon(COLLAPSED);
                        FooExpandItem.this.remove(FooExpandItem.this.component);
                        FooExpandItem.this.revalidate();
                    } else {
                        FooExpandItem.this.button.setIcon(EXPANDED);
                        FooExpandItem.this.add(FooExpandItem.this.component);
                        FooExpandItem.this.revalidate();
                    }
                }
            });
            jButton.setHorizontalAlignment(2);
            jButton.setIcon(COLLAPSED);
            jButton.setText(text);
            return jButton;
        }

        private boolean isExpanded() {
            for (Component component : this.getComponents()) {
                if (this.component != component) continue;
                return true;
            }
            return false;
        }

        private void build() {
            this.setBorder(BorderFactory.createLineBorder(Color.LIGHT_GRAY));
            this.add((Component)this.button, "North");
        }
    }

    public class FooExpandBar
    extends JPanel {
        private final Box box = Box.createVerticalBox();

        public FooExpandBar() {
            this.add(this.box);
        }

        public void addItem(FooExpandItem item) {
            this.box.add(item);
        }
    }
}

