/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.ui.peer.swing;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.MouseListener;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.KeyStroke;
import javax.swing.border.Border;
import oracle.bpm.ui.Button;
import oracle.bpm.ui.Image;
import oracle.bpm.ui.action.BaseAction;
import oracle.bpm.ui.msg.UIMsg;
import oracle.bpm.ui.peer.CompositeButtonPeer;
import oracle.bpm.ui.peer.swing.AwtConverter;
import oracle.bpm.ui.peer.swing.SwingAbstractButton;
import oracle.bpm.ui.peer.swing.SwingButton;
import oracle.bpm.ui.peer.swing.SwingComponent;
import oracle.bpm.ui.peer.swing.SwingToolBarItem;

public class SwingCompositeButton
extends SwingAbstractButton
implements CompositeButtonPeer {
    public SwingCompositeButton(SwingComponent parent) {
        super(parent, new JCompositeButton());
    }

    @Override
    public void setDropDownAction(BaseAction action) {
        this.getJCompositeButton().setDropDownAction(action);
    }

    @Override
    public void setAction(BaseAction action) {
        this.getJCompositeButton().setAction(action);
    }

    @Override
    public void setFirst(Button button) {
        SwingButton swingBtn = (SwingButton)button.getPeer();
        this.getJCompositeButton().setFirst(swingBtn.getButton());
    }

    @Override
    protected AbstractButton getAbstractButton() {
        return this.getJCompositeButton();
    }

    private JCompositeButton getJCompositeButton() {
        return (JCompositeButton)this.getComponent();
    }

    private static class JCompositeButton
    extends AbstractButton {
        private JButton b1;
        private JButton b2;
        private static final Icon DROP_DOWN_ICON = Image.create(UIMsg.DROP_DOWN_BUTTON).asSwingIcon();
        private static final int ARROW_WIDTH = 12;
        static final long serialVersionUID = 4461815072800761016L;
        static final long serialCheck = -1204936020337522312L;

        protected JCompositeButton() {
            BoxLayout layout = new BoxLayout(this, 0);
            super.setLayout(layout);
            super.setBorderPainted(false);
            super.setOpaque(false);
            this.setFocusCycleRoot(true);
            AbstractAction downAction = new AbstractAction(){
                private static final long serialVersionUID = 8358161627632073819L;

                @Override
                public void actionPerformed(ActionEvent e) {
                    JCompositeButton.this.b2.doClick();
                }
            };
            AbstractAction defaultAction = new AbstractAction(){
                private static final long serialVersionUID = 3199345911994866314L;

                @Override
                public void actionPerformed(ActionEvent e) {
                    JCompositeButton.this.b1.doClick();
                }
            };
            KeyStroke downArray = KeyStroke.getKeyStroke(40, 0, false);
            this.getInputMap(0).put(downArray, "down_action");
            this.getActionMap().put("down_action", downAction);
            KeyStroke enter = KeyStroke.getKeyStroke(10, 0, true);
            KeyStroke space = KeyStroke.getKeyStroke(32, 0, true);
            this.getInputMap(0).put(enter, "enter_action");
            this.getInputMap(0).put(space, "enter_action");
            this.getActionMap().put("enter_action", defaultAction);
        }

        public static JCompositeButton createDropDownButton(BaseAction first, BaseAction second) {
            JCompositeButton composite = new JCompositeButton();
            composite.setAction(first);
            composite.setDropDownAction(second);
            return composite;
        }

        @Override
        public void setBackground(Color c) {
            if (this.b1 != null) {
                this.b1.setBackground(c);
            }
            if (this.b2 != null) {
                this.b2.setBackground(c);
            }
            super.setBackground(c);
        }

        @Override
        public void setBorder(Border b) {
            super.setBorder(b);
        }

        @Override
        public void setBorderPainted(boolean b) {
            super.setBorderPainted(b);
        }

        @Override
        public boolean isEnabled() {
            return this.b1 != null && this.b1.isEnabled();
        }

        public void setAction(BaseAction action) {
            this.b1 = this.createButton(action);
            this.setFirst(this.b1);
        }

        public void setDropDownAction(BaseAction action) {
            this.b2 = this.createButton(action);
            this.b2.setIcon(DROP_DOWN_ICON);
            this.setSecond(this.b2);
        }

        public void setFirst(JButton button) {
            this.b1 = button;
            this.addButton(button);
            this.b1.setFocusPainted(false);
            JCompositeButton.setAllSizes(this.b1, AwtConverter.toAwt(SwingToolBarItem.DEFAULT_SIZE));
        }

        @Override
        public void setFocusable(boolean focusable) {
            super.setFocusable(focusable);
        }

        @Override
        public void setIcon(Icon defaultIcon) {
            if (this.b1 != null) {
                this.b1.setIcon(defaultIcon);
            }
        }

        @Override
        public Icon getIcon() {
            return this.b1 == null ? null : this.b1.getIcon();
        }

        @Override
        public void setMaximumSize(Dimension size) {
            if (this.b1 != null) {
                this.b1.setMaximumSize(size);
            }
            super.setMaximumSize(size);
        }

        @Override
        public void setMinimumSize(Dimension size) {
            if (this.b1 != null) {
                this.b1.setMinimumSize(size);
            }
            super.setMinimumSize(size);
        }

        @Override
        public void setPreferredSize(Dimension size) {
            if (this.b1 != null) {
                this.b1.setPreferredSize(size);
            }
            super.setPreferredSize(size);
        }

        @Override
        public void setToolTipText(String text) {
            if (this.b1 != null) {
                this.b1.setToolTipText(text);
            }
            super.setToolTipText(text);
        }

        @Override
        public void setRequestFocusEnabled(boolean focusable) {
            if (this.b1 != null) {
                this.b1.setRequestFocusEnabled(focusable);
            }
            if (this.b2 != null) {
                this.b2.setRequestFocusEnabled(focusable);
            }
            super.setRequestFocusEnabled(focusable);
        }

        @Override
        public void setRolloverEnabled(boolean enabled) {
            if (this.b1 != null) {
                this.b1.setRolloverEnabled(enabled);
            }
            if (this.b2 != null) {
                this.b2.setRolloverEnabled(enabled);
            }
            super.setRolloverEnabled(enabled);
        }

        public void setSecond(JButton button) {
            this.b2 = button;
            this.addButton(button);
            this.b2.setFocusPainted(false);
            JCompositeButton.setAllSizes(this.b2, new Dimension(12, SwingToolBarItem.DEFAULT_SIZE.getHeight()));
        }

        @Override
        public void setEnabled(boolean enabled) {
            if (this.b1 != null) {
                this.b1.setEnabled(enabled);
            }
            if (this.b2 != null) {
                this.b2.setEnabled(enabled);
            }
        }

        @Override
        public synchronized void addMouseListener(MouseListener m) {
            super.addMouseListener(m);
        }

        private static void setAllSizes(JButton button, Dimension size) {
            button.setPreferredSize(size);
            button.setMinimumSize(size);
            button.setMaximumSize(size);
        }

        private JButton createButton(BaseAction action) {
            JButton b = new JButton(action);
            b.setBorder(super.getBorder());
            b.setBorderPainted(super.isBorderPainted());
            b.setRolloverEnabled(super.isRolloverEnabled());
            b.setFocusable(super.isFocusable());
            b.setBackground(super.getBackground());
            b.setForeground(super.getForeground());
            b.setToolTipText(super.getToolTipText());
            return b;
        }

        private void addButton(JButton b) {
            this.add(b);
        }
    }
}

