/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.ui.peer.swing;

import javax.swing.JTable;
import javax.swing.table.TableColumn;
import oracle.bpm.ui.ColorProvider;
import oracle.bpm.ui.FontProvider;
import oracle.bpm.ui.Image;
import oracle.bpm.ui.LabelProvider;
import oracle.bpm.ui.peer.ColumnPeer;
import oracle.bpm.ui.peer.swing.SwingCellRenderer;
import oracle.bpm.ui.peer.swing.SwingComponent;
import oracle.bpm.ui.peer.swing.SwingPeer;
import oracle.bpm.ui.table.renderers.BooleanCheckBoxLabelProvider;

public class SwingColumn
extends SwingPeer
implements ColumnPeer {
    private int column;
    private Image image;
    private SwingComponent parent;
    private SwingCellRenderer renderer;

    SwingColumn(SwingComponent parent, int column) {
        this.setParent(parent);
        this.setColumn(column);
        this.getTableColumn().setMinWidth(0);
    }

    @Override
    public void setColorProvider(ColorProvider provider) {
        this.getSwingRenderer().setColorProvider(provider);
    }

    @Override
    public ColorProvider getColorProvider() {
        return this.getSwingRenderer().getColorProvider();
    }

    @Override
    public void setFontProvider(FontProvider provider) {
        this.getSwingRenderer().setFontProvider(provider);
    }

    @Override
    public FontProvider getFontProvider() {
        return this.getSwingRenderer().getFontProvider();
    }

    @Override
    public void setImage(Image image) {
        this.image = image;
    }

    @Override
    public Image getImage() {
        return this.image;
    }

    @Override
    public void setLabelProvider(LabelProvider provider) {
        if (!(provider instanceof BooleanCheckBoxLabelProvider)) {
            this.getSwingRenderer().setLabelProvider(provider);
        }
    }

    @Override
    public LabelProvider getLabelProvider() {
        return this.getSwingRenderer().getLabelProvider();
    }

    @Override
    public void setResizable(boolean resizable) {
        TableColumn col = this.getTableColumn();
        if (!resizable) {
            int width = this.getWidth();
            col.setMinWidth(width);
            col.setMaxWidth(width);
        } else {
            col.setMinWidth(0);
            col.setMaxWidth(Integer.MAX_VALUE);
        }
        this.getTableColumn().setResizable(resizable);
    }

    @Override
    public boolean isResizable() {
        return this.getTableColumn().getResizable();
    }

    @Override
    public void setWidth(int width) {
        TableColumn col = this.getTableColumn();
        col.setWidth(width);
        col.setPreferredWidth(width);
        if (!this.isResizable()) {
            this.setResizable(false);
        }
    }

    @Override
    public int getWidth() {
        return this.getTableColumn().getWidth();
    }

    protected TableColumn getTableColumn() {
        return this.getTable().getColumnModel().getColumn(this.getColumn());
    }

    protected int getColumn() {
        return this.column;
    }

    protected SwingComponent getParent() {
        return this.parent;
    }

    private void setColumn(int column) {
        this.column = column;
    }

    private void setParent(SwingComponent parent) {
        this.parent = parent;
    }

    private SwingCellRenderer getSwingRenderer() {
        if (this.renderer == null) {
            this.renderer = new SwingCellRenderer();
            this.getTableColumn().setCellRenderer(this.renderer);
        }
        return this.renderer;
    }

    private JTable getTable() {
        return (JTable)this.getParent().getJComponent();
    }
}

