/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.ui.peer.swing;

import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JColorChooser;
import javax.swing.JDialog;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.peer.ColorChooserPeer;
import oracle.bpm.ui.peer.swing.AwtConverter;
import oracle.bpm.ui.peer.swing.SwingPeer;

public class SwingColorChooser
extends SwingPeer
implements ColorChooserPeer {
    private Color color;
    private static JColorChooser colorChooser;

    @Override
    public oracle.bpm.draw.Color show(UiComponent parent, Msg title, oracle.bpm.draw.Color defaultColor) {
        final JColorChooser cc = SwingColorChooser.getColorChooser();
        if (defaultColor != null) {
            cc.getSelectionModel().setSelectedColor(AwtConverter.toAwt(defaultColor));
        }
        ActionListener okListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SwingColorChooser.this.color = cc.getColor();
            }
        };
        Component window = (Component)parent.getOwnerWindow().getNative();
        JDialog dialog = JColorChooser.createDialog(window, title.getString(), true, cc, okListener, null);
        dialog.setLocationRelativeTo(window);
        dialog.setVisible(true);
        return AwtConverter.fromAwt(this.color);
    }

    private static JColorChooser getColorChooser() {
        if (colorChooser == null) {
            colorChooser = new JColorChooser();
        }
        return colorChooser;
    }
}

