/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.ui.peer.swing;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeCellRenderer;
import oracle.bpm.ui.ColorProvider;
import oracle.bpm.ui.FontProvider;
import oracle.bpm.ui.Image;
import oracle.bpm.ui.LabelProvider;
import oracle.bpm.ui.TableColorProvider;
import oracle.bpm.ui.TreeTableFontProvider;
import oracle.bpm.ui.peer.swing.AwtConverter;

public class SwingCellRenderer
implements ListCellRenderer,
TreeCellRenderer,
TableCellRenderer {
    private ColorProvider colorProvider;
    private FontProvider fontProvider;
    private LabelProvider labelProvider;
    private DefaultListCellRenderer listRendererDelegate;
    private DefaultTableCellRenderer tableRendererDelegate;
    private DefaultTreeCellRenderer treeRendererDelegate;
    private static final Color DEFAULT_FORECOLOR = (Color)UIManager.get("Label.foreground");
    private static final Color DEFAULT_BACKCOLOR = (Color)UIManager.get("Label.background");
    static final long serialVersionUID = -7866604062193270854L;
    static final long serialCheck = -2635849309238143256L;

    public SwingCellRenderer() {
    }

    public SwingCellRenderer(LabelProvider provider) {
        this.setLabelProvider(provider);
    }

    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        DefaultListCellRenderer delegate = this.getListRendererDelegate();
        JLabel label = (JLabel)delegate.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
        this.renderValue(value, index, label, list.getFont());
        return label;
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        DefaultTableCellRenderer delegate = this.getTableRendererDelegate();
        JLabel label = (JLabel)delegate.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        this.renderValue(value, row, label, table.getFont());
        return label;
    }

    @Override
    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        DefaultTreeCellRenderer delegate = this.getTreeRendererDelegate();
        JLabel label = (JLabel)delegate.getTreeCellRendererComponent(tree, value, selected, expanded, leaf, row, hasFocus);
        this.renderValue(value, row, label, tree.getFont());
        return label;
    }

    protected void renderValue(Object value, int index, JLabel label, Font defaultFont) {
        if (this.labelProvider != null) {
            this.renderLabel(label, value);
        }
        if (this.colorProvider != null) {
            this.renderColor(label, value, index);
        }
        if (this.fontProvider != null) {
            this.renderFont(label, value, defaultFont);
        }
    }

    void setColorProvider(ColorProvider colorProvider) {
        this.colorProvider = colorProvider;
    }

    ColorProvider getColorProvider() {
        return this.colorProvider;
    }

    void setFontProvider(FontProvider fontProvider) {
        this.fontProvider = fontProvider;
    }

    FontProvider getFontProvider() {
        return this.fontProvider;
    }

    void setLabelProvider(LabelProvider provider) {
        this.labelProvider = provider;
    }

    LabelProvider getLabelProvider() {
        return this.labelProvider;
    }

    private DefaultListCellRenderer getListRendererDelegate() {
        if (this.listRendererDelegate == null) {
            this.listRendererDelegate = new DefaultListCellRenderer();
        }
        return this.listRendererDelegate;
    }

    private DefaultTableCellRenderer getTableRendererDelegate() {
        if (this.tableRendererDelegate == null) {
            this.tableRendererDelegate = new DefaultTableCellRenderer();
        }
        return this.tableRendererDelegate;
    }

    private DefaultTreeCellRenderer getTreeRendererDelegate() {
        if (this.treeRendererDelegate == null) {
            this.treeRendererDelegate = new DefaultTreeCellRenderer();
        }
        return this.treeRendererDelegate;
    }

    private void renderColor(JLabel label, Object element, int index) {
        ColorProvider cp = this.getColorProvider();
        if (cp instanceof TableColorProvider) {
            ((TableColorProvider)cp).setRow(index);
        }
        Color foreground = AwtConverter.toAwt(cp.getForeground(element));
        Color background = AwtConverter.toAwt(cp.getBackground(element));
        if (foreground == null) {
            foreground = DEFAULT_FORECOLOR;
        }
        label.setForeground(foreground);
        if (background == null) {
            foreground = DEFAULT_BACKCOLOR;
        }
        label.setBackground(background);
    }

    private void renderFont(JLabel label, Object element, Font defaultFont) {
        oracle.bpm.draw.Font font;
        oracle.bpm.draw.Font defFont = oracle.bpm.draw.Font.valueOf(defaultFont);
        FontProvider fp = this.getFontProvider();
        if (fp instanceof TreeTableFontProvider) {
            ((TreeTableFontProvider)fp).setObject(element);
        }
        if ((font = fp.getFont(element)) == null) {
            font = defFont;
        }
        label.setFont(AwtConverter.toAwt(font));
    }

    private void renderLabel(JLabel label, Object value) {
        LabelProvider labelProvider = this.getLabelProvider();
        try {
            String text = labelProvider.getText(value);
            label.setText(text);
            label.setToolTipText(text);
            Image image = labelProvider.getIcon(value);
            label.setIcon(image != null ? image.asSwingIcon() : null);
        }
        catch (Exception e) {
            // empty catch block
        }
    }
}

