/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.ui.peer.swing;

import java.awt.Component;
import java.awt.event.MouseEvent;
import java.util.EventObject;
import javax.swing.AbstractCellEditor;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.editors.CellEditor;
import oracle.bpm.ui.peer.swing.event.SwingChangeListener;
import oracle.bpm.ui.table.Table;
import oracle.bpm.ui.table.editors.TableCellEditor;

class SwingCellEditor
extends AbstractCellEditor
implements javax.swing.table.TableCellEditor,
CellEditorListener {
    private CellEditor cellEditor;
    private static final long serialVersionUID = -4993636860491837803L;

    SwingCellEditor(CellEditor cellEditor) {
        this.setCellEditor(cellEditor);
        cellEditor.addCellEditorListener(new oracle.bpm.ui.event.CellEditorListener(){

            @Override
            public void editingCanceled(oracle.bpm.ui.event.ChangeEvent e) {
                SwingCellEditor.this.cancelCellEditing();
            }

            @Override
            public void editingStopped(oracle.bpm.ui.event.ChangeEvent e) {
                SwingCellEditor.this.stopCellEditing();
            }
        });
    }

    @Override
    public Object getCellEditorValue() {
        return this.getCellEditor().getCellEditorValue();
    }

    public CellEditor getCellEditor() {
        return this.cellEditor;
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        UiContainer uiContainer = (UiContainer)UiComponent.get(table);
        CellEditor cellEditor = this.getCellEditor();
        UiComponent editor = cellEditor instanceof TableCellEditor && uiContainer instanceof Table ? ((TableCellEditor)cellEditor).getTableCellEditor((Table)uiContainer, value, isSelected, row, column) : cellEditor.createEditor(uiContainer, value);
        JComponent component = editor.asSwing();
        if (isSelected) {
            ((Component)component).setForeground(table.getSelectionForeground());
            ((Component)component).setBackground(table.getSelectionBackground());
        } else {
            ((Component)component).setForeground(table.getForeground());
            ((Component)component).setBackground(table.getBackground());
        }
        return component;
    }

    @Override
    public void editingCanceled(ChangeEvent e) {
        for (oracle.bpm.ui.event.CellEditorListener listener : this.getCellEditor().getCellEditorListeners()) {
            listener.editingCanceled(SwingChangeListener.mapEvent(e));
        }
    }

    @Override
    public void editingStopped(ChangeEvent e) {
        for (oracle.bpm.ui.event.CellEditorListener listener : this.getCellEditor().getCellEditorListeners()) {
            listener.editingStopped(SwingChangeListener.mapEvent(e));
        }
    }

    @Override
    public boolean isCellEditable(EventObject event) {
        return !(event instanceof MouseEvent) || ((MouseEvent)event).getClickCount() >= this.cellEditor.getClickCountToStart();
    }

    private void setCellEditor(CellEditor cellEditor) {
        this.cellEditor = cellEditor;
    }
}

