/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.ui.peer.swing;

import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Container;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import oracle.bpm.geom.Dimension;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.peer.CardLayoutPeer;
import oracle.bpm.ui.peer.ComponentPeer;
import oracle.bpm.ui.peer.swing.SwingComponent;

public class SwingCardLayout
extends CardLayout
implements CardLayoutPeer {
    private Map cardsMap = new HashMap();
    static final long serialVersionUID = 2516470456984164938L;
    static final long serialCheck = 1104450416889988453L;

    @Override
    public UiComponent getComponent(Object constraints) {
        return UiComponent.get(this.cardsMap.get(constraints));
    }

    @Override
    public Map getContainedComponents() {
        return Collections.unmodifiableMap(this.cardsMap);
    }

    @Override
    public void addLayoutComponent(Component comp, Object constraints) {
        if (!this.cardsMap.containsKey(constraints)) {
            super.addLayoutComponent(comp, constraints);
            this.cardsMap.put(constraints, comp);
        }
    }

    @Override
    public boolean contains(Object constraints) {
        return this.cardsMap.containsKey(constraints);
    }

    @Override
    public void layoutContainer(UiContainer uiComponent) {
    }

    @Override
    public void next(ComponentPeer parent) {
        SwingComponent component = (SwingComponent)parent;
        super.next((Container)component.getComponent());
    }

    @Override
    public Dimension preferredLayoutSize(UiComponent uiComponent) {
        return null;
    }

    @Override
    public void removeLayoutComponent(Component comp) {
        super.removeLayoutComponent(comp);
        if (this.cardsMap.containsValue(comp)) {
            Iterator iterator = this.cardsMap.values().iterator();
            while (iterator.hasNext()) {
                Component itComp = (Component)iterator.next();
                if (itComp != comp) continue;
                iterator.remove();
                break;
            }
        }
    }

    @Override
    public void show(ComponentPeer parent, String name) {
        SwingComponent component = (SwingComponent)parent;
        super.show((Container)component.getComponent(), name);
    }

    public Object translateConstraints(Object constraints) {
        return constraints;
    }
}

