/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.ui.peer.swing;

import java.awt.Component;
import java.awt.Container;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JTextField;
import oracle.bpm.ui.InputValidator;
import oracle.bpm.ui.peer.swing.FilteredDocumentDecorator;
import oracle.bpm.ui.peer.swing.InputValidatorTextFilterAdapter;

public class JOptionDialogUtils {
    private static final String OPTION_PANE_TEXT_FIELD_NAME = "OptionPane.textField";

    public static String showInput(Component parentComponent, String title, Object fieldMsg, String initialValue, InputValidator validator) {
        JOptionPane pane = new JOptionPane(fieldMsg, -1, 2, null, null, null);
        pane.setWantsInput(true);
        pane.setInitialSelectionValue(initialValue);
        pane.setComponentOrientation((parentComponent == null ? JOptionPane.getRootFrame() : parentComponent).getComponentOrientation());
        JDialog dialog = pane.createDialog(parentComponent, title);
        pane.selectInitialValue();
        JOptionDialogUtils.setFilteredDocument(JOptionDialogUtils.findInput(pane), validator);
        dialog.show();
        dialog.dispose();
        Object value = pane.getInputValue();
        if (value == JOptionPane.UNINITIALIZED_VALUE) {
            return null;
        }
        return value.toString();
    }

    private static void setFilteredDocument(JTextField field, InputValidator validator) {
        field.setDocument(new FilteredDocumentDecorator(field.getDocument(), new InputValidatorTextFilterAdapter(validator)));
    }

    private static int styleFromMessageType(int messageType) {
        switch (messageType) {
            case 0: {
                return 4;
            }
            case 3: {
                return 7;
            }
            case 2: {
                return 8;
            }
            case 1: {
                return 3;
            }
        }
        return 2;
    }

    private static JTextField findInput(JOptionPane pane) {
        return (JTextField)JOptionDialogUtils.findComponentByName(pane, OPTION_PANE_TEXT_FIELD_NAME);
    }

    private static Component findComponentByName(Container container, String name) {
        for (Component component : container.getComponents()) {
            Component result;
            if (name.equals(component.getName())) {
                return component;
            }
            if (!(component instanceof Container) || (result = JOptionDialogUtils.findComponentByName((Container)component, name)) == null) continue;
            return result;
        }
        return null;
    }
}

