/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.ui.peer.swing;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FocusTraversalPolicy;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JViewport;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.plaf.UIResource;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import oracle.bpm.ui.CheckBoxMenuItem;
import oracle.bpm.ui.Image;
import oracle.bpm.ui.KeyStroke;
import oracle.bpm.ui.ListSelectionMode;
import oracle.bpm.ui.PopupMenu;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.event.ActionEvent;
import oracle.bpm.ui.event.ActionListener;
import oracle.bpm.ui.event.EditorListener;
import oracle.bpm.ui.internal.EditorManager;
import oracle.bpm.ui.msg.UIMsg;
import oracle.bpm.ui.peer.swing.SwingUtilities;
import oracle.bpm.ui.table.AutoResizeMode;
import oracle.bpm.ui.table.Table;
import oracle.bpm.ui.treetable.TreeTable;
import oracle.bpm.ui.treetable.TreeTableColumn;

class ExtendedTable
extends JTable {
    private EditorManager cellEditorManager;
    private boolean columnHideAllowed = false;
    private boolean pendingFreezeFirstColumn;
    private int preferredRows = -1;
    private Hashtable<Integer, TableColumn> temporaryColumnsHash = new Hashtable();
    static final long serialVersionUID = 4055599093253107347L;
    static final long serialCheck = 6224387039440850618L;

    ExtendedTable() {
        this.init();
    }

    public void setColumnHideAllowed(boolean columnHideAllowed) {
        this.columnHideAllowed = columnHideAllowed;
    }

    public boolean isColumnVisible(int modelColumn) {
        return this.temporaryColumnsHash.get(modelColumn) == null;
    }

    public void setHeaderVisible(boolean show) {
        if (show) {
            this.createDefaultTableHeader();
        } else {
            this.setTableHeader(null);
        }
    }

    @Override
    public void setModel(TableModel model) {
        super.setModel(model != null ? model : this.createDefaultDataModel());
    }

    public void setPreferredRows(int preferredRows) {
        this.preferredRows = preferredRows;
        this.checkViewPortHeight();
    }

    public void setAutoResizeMode(AutoResizeMode mode) {
        int swingMode = 2;
        if (AutoResizeMode.OFF.equals((Object)mode)) {
            swingMode = 0;
        } else if (AutoResizeMode.NEXT_COLUMN.equals((Object)mode)) {
            swingMode = 1;
        } else if (AutoResizeMode.LAST_COLUMN.equals((Object)mode)) {
            swingMode = 3;
        } else if (AutoResizeMode.ALL_COLUMNS.equals((Object)mode)) {
            swingMode = 4;
        }
        this.setAutoResizeMode(swingMode);
    }

    public void setRelativesSizes(double[] sizes) {
        TableColumnModel cm = this.getColumnModel();
        int totalSize = cm.getTotalColumnWidth();
        int count = this.getColumnCount();
        assert (count == sizes.length) : "sizes.length is " + sizes.length + " and column count is " + count;
        for (int i = 0; i < count; ++i) {
            int size = (int)((double)totalSize * sizes[i]);
            cm.getColumn(i).setWidth(size);
        }
    }

    @Override
    public void setRowHeight(int rowHeight) {
        super.setRowHeight(rowHeight);
        this.checkViewPortHeight();
    }

    public void addEditorListener(EditorListener l) {
        this.getCellEditorManager().addEditorListener(l);
    }

    @Override
    public void addNotify() {
        super.addNotify();
        if (this.pendingFreezeFirstColumn) {
            this.freezeFirstColumn();
        }
    }

    @Override
    public void changeSelection(int rowIndex, int columnIndex, boolean toggle, boolean extend) {
        if (this.getModel().getRowCount() == 0) {
            return;
        }
        super.changeSelection(rowIndex, columnIndex, toggle, extend);
    }

    @Override
    public void setCellEditor(TableCellEditor anEditor) {
        super.setCellEditor(anEditor);
        if (anEditor != null) {
            this.getCellEditorManager().fireEditingStarted();
        }
    }

    @Override
    public void editingStopped(ChangeEvent e) {
        this.getCellEditorManager().fireEditingStopped();
        super.editingStopped(e);
    }

    public void freezeFirstColumn() {
        Container gp;
        this.pendingFreezeFirstColumn = true;
        Container p = this.getParent();
        if (p instanceof JViewport && (gp = p.getParent()) instanceof JScrollPane && this.getColumnCount() > 0 && this.getModel().getColumnCount() == this.getColumnCount()) {
            TableColumn column1 = this.getColumnModel().getColumn(0);
            this.removeColumn(column1);
            DefaultTableColumnModel oneColumnModel = new DefaultTableColumnModel();
            oneColumnModel.addColumn(column1);
            JTable oneColumnTable = new JTable(this.getModel(), oneColumnModel);
            oneColumnTable.setAutoResizeMode(0);
            oneColumnTable.getTableHeader().setDefaultRenderer(this.getTableHeader().getDefaultRenderer());
            oneColumnTable.getTableHeader().setResizingAllowed(false);
            oneColumnTable.getTableHeader().setReorderingAllowed(false);
            oneColumnTable.setPreferredScrollableViewportSize(new Dimension(column1.getWidth(), oneColumnTable.getHeight()));
            Hashtable defaultRenderers = this.defaultRenderersByColumnClass;
            for (Map.Entry entry : defaultRenderers.entrySet()) {
                Class columnClass = (Class)entry.getKey();
                TableCellRenderer renderer = (TableCellRenderer)entry.getValue();
                oneColumnTable.setDefaultRenderer(columnClass, renderer);
            }
            oneColumnTable.setDragEnabled(false);
            oneColumnTable.setAutoscrolls(false);
            oneColumnTable.getTableHeader().setReorderingAllowed(false);
            oneColumnTable.getTableHeader().setResizingAllowed(true);
            oneColumnTable.getTableHeader().getColumnModel().getColumn(0).addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    if (evt.getPropertyName().equals("preferredWidth")) {
                        int width = ExtendedTable.this.getTableHeader().getColumnModel().getColumn(0).getWidth();
                        ExtendedTable.this.setPreferredScrollableViewportSize(new Dimension(width, ExtendedTable.this.getHeight()));
                        ExtendedTable.this.revalidate();
                    }
                }
            });
            JViewport oneColumnViewPort = new JViewport();
            oneColumnViewPort.add(oneColumnTable);
            oneColumnViewPort.setBackground(this.getBackground());
            JViewport cornerHeader = new JViewport();
            cornerHeader.add(oneColumnTable.getTableHeader());
            ((JScrollPane)gp).setRowHeader(oneColumnViewPort);
            ((JScrollPane)gp).setCorner("UPPER_LEFT_CORNER", cornerHeader);
            this.pendingFreezeFirstColumn = false;
        }
    }

    public void hideColumn(int modelColumn) {
        TableColumn tc = this.getVisibleColumn(modelColumn);
        if (tc != null) {
            this.temporaryColumnsHash.put(modelColumn, tc);
            this.removeColumn(tc);
        }
    }

    public void removeEditorListener(EditorListener listener) {
        this.getCellEditorManager().removeEditorListener(listener);
    }

    public void showColumn(int modelColumn) {
        this.showColumn(modelColumn, this.getColumnCount() - 1);
    }

    @Override
    protected void createDefaultRenderers() {
        super.createDefaultRenderers();
        HashMap<Class, TableCellRenderer> overridenTableCellRenderer = new HashMap<Class, TableCellRenderer>();
        for (Object k : this.defaultRenderersByColumnClass.keySet()) {
            Class columnClass = (Class)k;
            TableCellRenderer tableCellRenderer = (TableCellRenderer)this.defaultRenderersByColumnClass.get(columnClass);
            if (this.isFocuseableTableCellRenderer(tableCellRenderer)) continue;
            overridenTableCellRenderer.put(columnClass, tableCellRenderer);
        }
        for (Map.Entry entry : overridenTableCellRenderer.entrySet()) {
            this.setDefaultRenderer((Class)entry.getKey(), (TableCellRenderer)entry.getValue());
        }
    }

    void setSelectionMode(ListSelectionMode mode) {
        if (mode == ListSelectionMode.SINGLE_SELECTION) {
            this.setSelectionMode(0);
        } else if (mode == ListSelectionMode.SINGLE_INTERVAL_SELECTION) {
            this.setSelectionMode(1);
        } else {
            assert (mode == ListSelectionMode.MULTIPLE_INTERVAL_SELECTION) : mode;
            this.setSelectionMode(2);
        }
    }

    private TableColumn getVisibleColumn(int modelColumn) {
        Enumeration<TableColumn> columns = this.getColumnModel().getColumns();
        while (columns.hasMoreElements()) {
            TableColumn currentTableColumn = columns.nextElement();
            if (currentTableColumn.getModelIndex() != modelColumn) continue;
            return currentTableColumn;
        }
        return null;
    }

    private boolean getColumnHideAllowed() {
        return this.columnHideAllowed;
    }

    private boolean isFocuseableTableCellRenderer(TableCellRenderer tableCellRenderer) {
        return tableCellRenderer instanceof DefaultTableCellRenderer || tableCellRenderer instanceof FocuseableTableCellRenderer;
    }

    private int getPreferredRows() {
        return this.preferredRows;
    }

    private TableColumn getTableColumnFromModel(int modelColumn) {
        TableColumnModel tcm = this.getColumnModel();
        for (int i = 0; i < tcm.getColumnCount(); ++i) {
            TableColumn tc = tcm.getColumn(i);
            if (tc.getModelIndex() != modelColumn) continue;
            return tc;
        }
        return null;
    }

    private void addColumnItems(PopupMenu popup, final int column) {
        ActionListener action = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                CheckBoxMenuItem mi = (CheckBoxMenuItem)ae.getSource();
                int index = (Integer)mi.getClientProperty("oracle.bpm.TableModelColumnIndex");
                if (mi.isSelected()) {
                    ExtendedTable.this.showColumn(index, column + 1);
                } else if (ExtendedTable.this.getColumnCount() > 1) {
                    ExtendedTable.this.hideColumn(index);
                }
                ExtendedTable.this.sizeColumnsToFit(-1);
            }
        };
        TableModel model = this.getModel();
        UiComponent lastColumnVisible = null;
        for (int i = 0; i < model.getColumnCount(); ++i) {
            String colname = model.getColumnName(i);
            CheckBoxMenuItem mi = new CheckBoxMenuItem((UiContainer)popup, UIMsg.TO_MSG(colname));
            mi.setSelected(true);
            TableColumn tc = this.getTableColumnFromModel(i);
            if (tc != null) {
                lastColumnVisible = mi;
            } else {
                mi.setState(false);
            }
            mi.addActionListener(action);
            mi.putClientProperty("oracle.bpm.TableModelColumnIndex", i);
            popup.add(mi);
        }
        if (this.getColumnCount() == 1 && lastColumnVisible != null) {
            lastColumnVisible.setEnabled(false);
        }
    }

    private void checkViewPortHeight() {
        Dimension vpSize;
        if (this.preferredRows != -1 && (vpSize = this.getPreferredScrollableViewportSize()) != null) {
            int headerHeight = (int)Math.ceil(this.getTableHeader().getPreferredSize().getHeight());
            int height = headerHeight + (this.getRowHeight() + this.getRowMargin()) * this.getPreferredRows();
            vpSize = new Dimension(vpSize.width, height);
            this.setPreferredScrollableViewportSize(vpSize);
        }
    }

    private EditorManager getCellEditorManager() {
        if (this.cellEditorManager == null) {
            this.cellEditorManager = new EditorManager();
        }
        return this.cellEditorManager;
    }

    private void init() {
        this.getInputMap(1).put(KeyStroke.getKeyStroke(27, 0).asSwing(), "none");
        this.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                Container cycleRoot = ExtendedTable.this.getFocusCycleRootAncestor();
                FocusTraversalPolicy policy = ExtendedTable.this.getFocusTraversalPolicy();
                if (policy == null && cycleRoot != null) {
                    policy = cycleRoot.getFocusTraversalPolicy();
                }
                if (ExtendedTable.this.getRowCount() == 0 && policy != null) {
                    Component target = policy.getComponentAfter(cycleRoot, ExtendedTable.this);
                    if (target != null && target == e.getOppositeComponent()) {
                        target = policy.getComponentBefore(cycleRoot, ExtendedTable.this);
                    }
                    if (target != null) {
                        target.requestFocusInWindow();
                    }
                }
            }
        });
        this.getTableHeader().addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                TableColumnModel columnModel = ExtendedTable.this.getColumnModel();
                int viewColumn = columnModel.getColumnIndexAtX(e.getX());
                int column = ExtendedTable.this.convertColumnIndexToModel(viewColumn);
                if (column != -1) {
                    TableCellEditor cellEditor = ExtendedTable.this.getCellEditor();
                    if (cellEditor != null) {
                        cellEditor.stopCellEditing();
                    }
                    if (SwingUtilities.isPopupTrigger(e)) {
                        ExtendedTable.this.showOptionsPopup(e.getX(), e.getY());
                    }
                }
            }
        });
        this.getTableHeader().setDefaultRenderer(new HeaderRenderer());
        this.setRowHeight(20);
    }

    private void showColumn(int modelColumn, int position) {
        TableColumn tc = this.temporaryColumnsHash.get(modelColumn);
        if (tc != null) {
            this.temporaryColumnsHash.remove(modelColumn);
            this.addColumn(tc);
            this.moveColumn(this.getColumnCount() - 1, position);
        }
    }

    private void showOptionsPopup(int x, int y) {
        if (!this.getColumnHideAllowed()) {
            return;
        }
        PopupMenu popup = new PopupMenu();
        int viewColumn = this.getColumnModel().getColumnIndexAtX(x);
        this.addColumnItems(popup, viewColumn);
        if (popup.getComponentCount() > 0) {
            popup.show(UiComponent.get(this.getTableHeader()), x, y);
        }
    }

    private static class HeaderRenderer
    extends DefaultTableCellRenderer
    implements UIResource {
        private HeaderRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            JTableHeader header;
            if (table != null && (header = table.getTableHeader()) != null) {
                this.setForeground(header.getForeground());
                this.setBackground(header.getBackground());
                this.setFont(header.getFont());
            }
            this.setText(value == null ? "" : value.toString().trim());
            Image image = null;
            UiComponent uiComponent = UiComponent.get(table);
            if (uiComponent instanceof TreeTable) {
                TreeTableColumn tc = ((TreeTable)uiComponent).getColumn(column);
                image = tc.getImage();
            } else if (uiComponent instanceof Table) {
                oracle.bpm.ui.table.TableColumn tc = ((Table)uiComponent).getColumn(column);
                image = tc.getImage();
            }
            this.setIcon(image != null ? image.asSwingIcon() : null);
            this.setBorder(UIManager.getBorder("TableHeader.cellBorder"));
            if (this.getText().trim().length() == 0 && image != null) {
                this.setHorizontalAlignment(0);
            } else {
                this.setHorizontalAlignment(2);
            }
            return this;
        }
    }

    public static interface FocuseableTableCellRenderer {
    }
}

