/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.ui.peer.swing;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import oracle.bpm.draw.FontMetrics;
import oracle.bpm.draw.Graphics;
import oracle.bpm.draw.GraphicsUtils;
import oracle.bpm.ui.FontStyle;
import oracle.bpm.ui.peer.swing.SwingFont;
import oracle.bpm.ui.peer.swing.SwingFontMetrics;
import oracle.bpm.ui.peer.swing.SwingGraphics;

public class AwtConverter {
    public static oracle.bpm.geom.Point fromAwt(Point point) {
        return point != null ? new oracle.bpm.geom.Point(point.x, point.y) : null;
    }

    public static oracle.bpm.geom.Dimension fromAwt(Dimension dimension) {
        return dimension != null ? oracle.bpm.geom.Dimension.valueOf(dimension.width, dimension.height) : null;
    }

    public static oracle.bpm.geom.Rectangle fromAwt(Rectangle rectangle) {
        return rectangle != null ? new oracle.bpm.geom.Rectangle(rectangle.x, rectangle.y, rectangle.width, rectangle.height) : null;
    }

    public static oracle.bpm.geom.Insets fromAwt(Insets insets) {
        return new oracle.bpm.geom.Insets(insets.top, insets.left, insets.bottom, insets.right);
    }

    public static oracle.bpm.draw.Color fromAwt(Color color) {
        return color != null ? oracle.bpm.draw.Color.valueOf(color.getRed(), color.getBlue(), color.getGreen(), color.getAlpha()) : null;
    }

    public static Graphics fromAwt(java.awt.Graphics graphics) {
        return GraphicsUtils.create(graphics);
    }

    public static FontMetrics fromAwt(java.awt.FontMetrics fontMetrics) {
        return new SwingFontMetrics(fontMetrics);
    }

    public static Point toAwt(oracle.bpm.geom.Point point) {
        return new Point(point.getX(), point.getY());
    }

    public static Rectangle toAwt(oracle.bpm.geom.Rectangle rectangle) {
        return new Rectangle(rectangle.getX(), rectangle.getY(), rectangle.getWidth(), rectangle.getHeight());
    }

    public static Dimension toAwt(oracle.bpm.geom.Dimension dimension) {
        return new Dimension(dimension.getWidth(), dimension.getHeight());
    }

    public static Insets toAwt(oracle.bpm.geom.Insets insets) {
        return new Insets(insets.top, insets.left, insets.bottom, insets.right);
    }

    public static Color toAwt(oracle.bpm.draw.Color color) {
        return color != null ? new Color(color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha()) : null;
    }

    public static java.awt.Graphics toAwt(Graphics graphics) {
        assert (graphics instanceof SwingGraphics);
        return ((SwingGraphics)graphics).getAwtGraphics();
    }

    public static Font toAwt(oracle.bpm.draw.Font font) {
        assert (font == null || font.getPeer() instanceof SwingFont);
        return font != null ? ((SwingFont)font.getPeer()).getAwtFont() : null;
    }

    static oracle.bpm.draw.Font fromAwt(Font font) {
        return oracle.bpm.draw.Font.valueOf(font.getName(), FontStyle.valueOf(font.getStyle()), font.getSize());
    }
}

