/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.ui.layout.form;

import oracle.bpm.ui.Frame;
import oracle.bpm.ui.Label;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.Ui;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.UiType;
import oracle.bpm.ui.border.Border;
import oracle.bpm.ui.layout.form.AbstractFormBuilder;
import oracle.bpm.ui.layout.form.CellConstraints;
import oracle.bpm.ui.layout.form.ComponentFactory;
import oracle.bpm.ui.layout.form.DefaultComponentFactory;
import oracle.bpm.ui.layout.form.FormLayout;
import oracle.bpm.ui.text.TextField;

public class PanelBuilder
extends AbstractFormBuilder {
    private ComponentFactory componentFactory;

    @Deprecated
    public PanelBuilder(UiContainer parent, FormLayout layout) {
        this(layout, new Panel(parent));
    }

    public PanelBuilder(FormLayout layout, UiContainer panel) {
        super(layout, panel);
    }

    @Deprecated
    public PanelBuilder(Panel panel, FormLayout layout) {
        super(layout, panel);
    }

    public static void main(String[] args) {
        Ui.initialize(UiType.SWING);
        Frame frame = new Frame("RelativeLayout Test");
        frame.setDefaultCloseOperation(3);
        UiContainer contentPane = frame.getContentPane();
        assert (contentPane != null) : "Invalid content pane";
        Panel panel = new Panel(contentPane);
        FormLayout layout = new FormLayout("pref, 5dlu, max(250px;pref):grow", "pref");
        PanelBuilder builder = layout.createBuilder(panel);
        Label label = Label.create(panel);
        label.setText("Label: ");
        TextField textField = new TextField(panel);
        textField.setColumns(15);
        textField.setText("Text field");
        CellConstraints cc = layout.createCellConstraints();
        builder.add((UiComponent)label, cc.xy(1, 1));
        builder.add((UiComponent)textField, cc.xy(3, 1));
        contentPane.add(panel, "Center");
        frame.setSize(400, 300);
        frame.setVisible(true);
    }

    public final void setBorder(Border border) {
        this.getPanel().setBorder(border);
    }

    public final void setComponentFactory(ComponentFactory newFactory) {
        this.componentFactory = newFactory;
    }

    public final Panel getPanel() {
        return (Panel)this.getContainer();
    }

    public final Label add(Label label, CellConstraints labelConstraints, UiComponent component, CellConstraints componentConstraints) {
        if (labelConstraints == componentConstraints) {
            throw new IllegalArgumentException("You must provide two CellConstraints instances, one for the label and one for the component.\nConsider using #clone(). See the JavaDocs for details.");
        }
        this.add((UiComponent)label, labelConstraints);
        this.add(component, componentConstraints);
        label.setLabelFor(component);
        return label;
    }

    public final Label addLabel(UiContainer parent, String textWithMnemonic, CellConstraints constraints) {
        Label label = this.getComponentFactory().createLabel(parent, textWithMnemonic);
        this.add((UiComponent)label, constraints);
        return label;
    }

    public final Label addLabel(String textWithMnemonic, String encodedConstraints) {
        return this.addLabel(null, textWithMnemonic, new CellConstraints(encodedConstraints));
    }

    public final Label addLabel(String textWithMnemonic) {
        return this.addLabel(null, textWithMnemonic, this.cellConstraints());
    }

    public final Label addLabel(String textWithMnemonic, CellConstraints labelConstraints, UiComponent component, CellConstraints componentConstraints) {
        if (labelConstraints == componentConstraints) {
            throw new IllegalArgumentException("You must provide two CellConstraints instances, one for the label and one for the component.\nConsider using #clone(). See the JavaDocs for details.");
        }
        Label label = this.addLabel(null, textWithMnemonic, labelConstraints);
        this.add(component, componentConstraints);
        label.setLabelFor(component);
        return label;
    }

    public final UiComponent addSeparator(String text, CellConstraints constraints) {
        int titleAlignment = this.isLeftToRight() ? 2 : 4;
        UiComponent titledSeparator = this.getComponentFactory().createSeparator(this.getContainer(), text, titleAlignment);
        this.add(titledSeparator, constraints);
        return titledSeparator;
    }

    public final UiComponent addSeparator(String text, String encodedConstraints) {
        return this.addSeparator(text, new CellConstraints(encodedConstraints));
    }

    public final UiComponent addSeparator(String text, int columnSpan) {
        return this.addSeparator(text, this.createLeftAdjustedConstraints(columnSpan));
    }

    public final UiComponent addSeparator(String text) {
        return this.addSeparator(text, this.getLayout().getColumnCount());
    }

    public final Label addTitle(UiContainer parent, String text, CellConstraints constraints) {
        Label titleLabel = this.getComponentFactory().createTitle(parent, text);
        this.add((UiComponent)titleLabel, constraints);
        return titleLabel;
    }

    public final Label addTitle(UiContainer parent, String text, String encodedConstraints) {
        return this.addTitle(parent, text, new CellConstraints(encodedConstraints));
    }

    public final Label addTitle(UiContainer parent, String text) {
        return this.addTitle(parent, text, this.cellConstraints());
    }

    protected final ComponentFactory getComponentFactory() {
        if (this.componentFactory == null) {
            this.componentFactory = DefaultComponentFactory.getInstance();
        }
        return this.componentFactory;
    }
}

