/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.ui.layout.form;

import java.io.Serializable;
import java.util.List;
import java.util.StringTokenizer;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.layout.form.BoundedSize;
import oracle.bpm.ui.layout.form.ConstantSize;
import oracle.bpm.ui.layout.form.FormLayout;
import oracle.bpm.ui.layout.form.Size;
import oracle.bpm.ui.layout.form.Sizes;

public abstract class FormSpec
implements Serializable {
    private DefaultAlignment defaultAlignment;
    private double resizeWeight;
    private Size size;
    static final DefaultAlignment LEFT_ALIGN = new DefaultAlignment("left");
    static final DefaultAlignment RIGHT_ALIGN = new DefaultAlignment("right");
    static final DefaultAlignment TOP_ALIGN = new DefaultAlignment("top");
    static final DefaultAlignment BOTTOM_ALIGN = new DefaultAlignment("bottom");
    static final DefaultAlignment CENTER_ALIGN = new DefaultAlignment("center");
    static final DefaultAlignment FILL_ALIGN = new DefaultAlignment("fill");
    private static final DefaultAlignment[] VALUES = new DefaultAlignment[]{LEFT_ALIGN, RIGHT_ALIGN, TOP_ALIGN, BOTTOM_ALIGN, CENTER_ALIGN, FILL_ALIGN};
    public static final double NO_GROW = 0.0;
    public static final double DEFAULT_GROW = 1.0;

    protected FormSpec(DefaultAlignment defaultAlignment, String encodedDescription) {
        this(defaultAlignment, Sizes.DEFAULT, 0.0);
        this.parseAndInitValues(encodedDescription.toLowerCase());
    }

    protected FormSpec(DefaultAlignment defaultAlignment, Size size, double resizeWeight) {
        this.defaultAlignment = defaultAlignment;
        this.size = size;
        this.resizeWeight = resizeWeight;
        if (resizeWeight < 0.0) {
            throw new IllegalArgumentException("The resize weight must be non-negative.");
        }
    }

    public final DefaultAlignment getDefaultAlignment() {
        return this.defaultAlignment;
    }

    public final double getResizeWeight() {
        return this.resizeWeight;
    }

    public final Size getSize() {
        return this.size;
    }

    public final String toShortString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.defaultAlignment.abbreviation());
        buffer.append(":");
        buffer.append(this.size.toString());
        buffer.append(':');
        if (this.resizeWeight == 0.0) {
            buffer.append("n");
        } else if (this.resizeWeight == 1.0) {
            buffer.append("g");
        } else {
            buffer.append("g(");
            buffer.append(this.resizeWeight);
            buffer.append(')');
        }
        return buffer.toString();
    }

    public final String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.defaultAlignment);
        buffer.append(":");
        buffer.append(this.size.toString());
        buffer.append(':');
        if (this.resizeWeight == 0.0) {
            buffer.append("noGrow");
        } else if (this.resizeWeight == 1.0) {
            buffer.append("grow");
        } else {
            buffer.append("grow(");
            buffer.append(this.resizeWeight);
            buffer.append(')');
        }
        return buffer.toString();
    }

    abstract boolean isHorizontal();

    final boolean canGrow() {
        return this.getResizeWeight() != 0.0;
    }

    final int maximumSize(UiContainer container, List components, FormLayout.Measure minMeasure, FormLayout.Measure prefMeasure, FormLayout.Measure defaultMeasure) {
        return this.size.maximumSize(container, components, minMeasure, prefMeasure, defaultMeasure);
    }

    private Size decodeAtomicSize(String token) {
        Sizes.ComponentSize componentSize = Sizes.ComponentSize.valueOf(token);
        if (componentSize != null) {
            return componentSize;
        }
        return ConstantSize.valueOf(token, this.isHorizontal());
    }

    private double decodeResize(String token) {
        if (token.equals("g") || token.equals("grow")) {
            return 1.0;
        }
        if (token.equals("n") || token.equals("nogrow") || token.equals("none")) {
            return 0.0;
        }
        if ((token.startsWith("grow(") || token.startsWith("g(")) && token.endsWith(")")) {
            int leftParen = token.indexOf(40);
            int rightParen = token.indexOf(41);
            String substring = token.substring(leftParen + 1, rightParen);
            return Double.parseDouble(substring);
        }
        throw new IllegalArgumentException("The resize argument '" + token + "' is invalid. " + " Must be one of: grow, g, none, n, grow(<double>), g(<double>)");
    }

    private Size parseAndInitBoundedSize(String token, boolean setMax) {
        int semicolonIndex = token.indexOf(59);
        String sizeToken1 = token.substring(4, semicolonIndex);
        String sizeToken2 = token.substring(semicolonIndex + 1, token.length() - 1);
        Size size1 = this.decodeAtomicSize(sizeToken1);
        Size size2 = this.decodeAtomicSize(sizeToken2);
        if (size1 instanceof ConstantSize) {
            if (size2 instanceof Sizes.ComponentSize) {
                return new BoundedSize(size2, setMax ? null : size1, setMax ? size1 : null);
            }
            throw new IllegalArgumentException("Bounded sizes must not be both constants.");
        }
        if (size2 instanceof ConstantSize) {
            return new BoundedSize(size1, setMax ? null : size2, setMax ? size2 : null);
        }
        throw new IllegalArgumentException("Bounded sizes must not be both logical.");
    }

    private void parseAndInitSize(String token) {
        if (token.startsWith("max(") && token.endsWith(")")) {
            this.size = this.parseAndInitBoundedSize(token, false);
            return;
        }
        if (token.startsWith("min(") && token.endsWith(")")) {
            this.size = this.parseAndInitBoundedSize(token, true);
            return;
        }
        this.size = this.decodeAtomicSize(token);
    }

    private void parseAndInitValues(String encodedDescription) {
        StringTokenizer tokenizer = new StringTokenizer(encodedDescription, ":");
        if (!tokenizer.hasMoreTokens()) {
            throw new IllegalArgumentException("The form spec must not be empty.");
        }
        String token = tokenizer.nextToken();
        DefaultAlignment alignment = DefaultAlignment.valueOf(token, this.isHorizontal());
        if (alignment != null) {
            this.defaultAlignment = alignment;
            if (!tokenizer.hasMoreTokens()) {
                throw new IllegalArgumentException("The form spec must provide a size.");
            }
            token = tokenizer.nextToken();
        }
        this.parseAndInitSize(token);
        if (tokenizer.hasMoreTokens()) {
            this.resizeWeight = this.decodeResize(tokenizer.nextToken());
        }
    }

    public static final class DefaultAlignment
    implements Serializable {
        private final transient String name;
        private final int ordinal = nextOrdinal++;
        private static final long serialVersionUID = 4217069652064616294L;
        private static int nextOrdinal = 0;

        private DefaultAlignment(String name) {
            this.name = name;
        }

        public char abbreviation() {
            return this.name.charAt(0);
        }

        public String toString() {
            return this.name;
        }

        private static DefaultAlignment valueOf(String str, boolean isHorizontal) {
            if (str.equals("f") || str.equals("fill")) {
                return FILL_ALIGN;
            }
            if (str.equals("c") || str.equals("center")) {
                return CENTER_ALIGN;
            }
            if (isHorizontal) {
                if (str.equals("r") || str.equals("right")) {
                    return RIGHT_ALIGN;
                }
                if (str.equals("l") || str.equals("left")) {
                    return LEFT_ALIGN;
                }
                return null;
            }
            if (str.equals("t") || str.equals("top")) {
                return TOP_ALIGN;
            }
            if (str.equals("b") || str.equals("bottom")) {
                return BOTTOM_ALIGN;
            }
            return null;
        }

        private Object readResolve() {
            return VALUES[this.ordinal];
        }
    }
}

