/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.ui.layout.form;

import oracle.bpm.ui.Button;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.layout.form.ColumnSpec;
import oracle.bpm.ui.layout.form.ConstantSize;
import oracle.bpm.ui.layout.form.FormFactory;
import oracle.bpm.ui.layout.form.FormLayout;
import oracle.bpm.ui.layout.form.PanelBuilder;
import oracle.bpm.ui.layout.form.RowSpec;

public final class ButtonStackBuilder
extends PanelBuilder {
    private static final ColumnSpec[] COL_SPECS = new ColumnSpec[]{FormFactory.BUTTON_COLSPEC};
    private static final RowSpec[] ROW_SPECS = new RowSpec[0];
    private static final String NARROW_KEY = "jgoodies.isNarrow";

    public ButtonStackBuilder(UiContainer parent) {
        this(new Panel(parent));
    }

    public ButtonStackBuilder(Panel panel) {
        super(new FormLayout(COL_SPECS, ROW_SPECS), panel);
    }

    public void addButtons(Button[] buttons) {
        for (int i = 0; i < buttons.length; ++i) {
            this.addGridded(buttons[i]);
            if (i >= buttons.length - 1) continue;
            this.addRelatedGap();
        }
    }

    public void addFixed(UiComponent component) {
        this.getLayout().appendRow(FormFactory.PREF_ROWSPEC);
        this.add(component);
        this.nextRow();
    }

    public void addGlue() {
        this.appendGlueRow();
        this.nextRow();
    }

    public void addGridded(UiComponent component) {
        this.getLayout().appendRow(FormFactory.PREF_ROWSPEC);
        this.getLayout().addGroupedRow(this.getRow());
        component.putClientProperty(NARROW_KEY, Boolean.TRUE);
        this.add(component);
        this.nextRow();
    }

    public void addRelatedGap() {
        this.appendRelatedComponentsGapRow();
        this.nextRow();
    }

    public void addStrut(ConstantSize size) {
        this.getLayout().appendRow(new RowSpec(RowSpec.TOP, size, 0.0));
        this.nextRow();
    }

    public void addUnrelatedGap() {
        this.appendUnrelatedComponentsGapRow();
        this.nextRow();
    }
}

