/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.ui.layout.form;

import oracle.bpm.draw.FontMetrics;
import oracle.bpm.ui.Ui;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.layout.form.UnitConverter;
import oracle.bpm.ui.peer.ToolkitPeer;

public abstract class AbstractUnitConverter
implements UnitConverter {
    private static final int DTP_RESOLUTION = 72;
    private static int defaultScreenResolution = -1;

    @Override
    public int centimeterAsPixel(double cm, UiComponent component) {
        return this.centimeterAsPixel(cm, this.getScreenResolution(component));
    }

    @Override
    public int dialogUnitXAsPixel(int dluX, UiComponent c) {
        return this.dialogUnitXAsPixel(dluX, this.getDialogBaseUnitsX(c));
    }

    @Override
    public int dialogUnitYAsPixel(int dluY, UiComponent c) {
        return this.dialogUnitYAsPixel(dluY, this.getDialogBaseUnitsY(c));
    }

    @Override
    public int inchAsPixel(double in, UiComponent component) {
        return this.inchAsPixel(in, this.getScreenResolution(component));
    }

    @Override
    public int millimeterAsPixel(double mm, UiComponent component) {
        return this.millimeterAsPixel(mm, this.getScreenResolution(component));
    }

    @Override
    public int pointAsPixel(int pt, UiComponent component) {
        return this.pointAsPixel(pt, this.getScreenResolution(component));
    }

    protected abstract double getDialogBaseUnitsX(UiComponent var1);

    protected abstract double getDialogBaseUnitsY(UiComponent var1);

    protected final int centimeterAsPixel(double cm, int dpi) {
        return (int)Math.round((double)dpi * cm * 100.0 / 254.0);
    }

    protected final int inchAsPixel(double in, int dpi) {
        return (int)Math.round((double)dpi * in);
    }

    protected final int millimeterAsPixel(double mm, int dpi) {
        return (int)Math.round((double)dpi * mm * 10.0 / 254.0);
    }

    protected final int pointAsPixel(int pt, int dpi) {
        return Math.round(dpi * pt / 72);
    }

    protected int getDefaultScreenResolution() {
        if (defaultScreenResolution == -1) {
            defaultScreenResolution = Ui.getToolkit().getScreenResolution();
        }
        return defaultScreenResolution;
    }

    protected int getScreenResolution(UiComponent c) {
        if (c == null) {
            return this.getDefaultScreenResolution();
        }
        ToolkitPeer toolkit = Ui.getToolkit();
        return toolkit != null ? toolkit.getScreenResolution() : this.getDefaultScreenResolution();
    }

    protected double computeAverageCharWidth(FontMetrics metrics, String testString) {
        int width = metrics.stringWidth(testString);
        double average = (double)width / (double)testString.length();
        return average;
    }

    protected int dialogUnitXAsPixel(int dluX, double dialogBaseUnitsX) {
        return (int)Math.round((double)dluX * dialogBaseUnitsX / 4.0);
    }

    protected int dialogUnitYAsPixel(int dluY, double dialogBaseUnitsY) {
        return (int)Math.round((double)dluY * dialogBaseUnitsY / 8.0);
    }
}

