/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.ui.layout.form;

import java.awt.ComponentOrientation;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.layout.form.CellConstraints;
import oracle.bpm.ui.layout.form.ColumnSpec;
import oracle.bpm.ui.layout.form.FormFactory;
import oracle.bpm.ui.layout.form.FormLayout;
import oracle.bpm.ui.layout.form.RowSpec;

public abstract class AbstractFormBuilder {
    private final UiContainer container;
    private CellConstraints currentCellConstraints;
    private final FormLayout layout;
    private boolean leftToRight;

    public AbstractFormBuilder(FormLayout layout, UiContainer container) {
        if (layout == null) {
            throw new NullPointerException("The layout must not be null.");
        }
        if (container == null) {
            throw new NullPointerException("The layout container must not be null.");
        }
        this.container = container;
        this.layout = layout;
        this.layout.setContainer(container);
        container.setLayout(layout);
        this.currentCellConstraints = new CellConstraints();
        ComponentOrientation orientation = container.getComponentOrientation();
        this.leftToRight = orientation.isLeftToRight() || !orientation.isHorizontal();
    }

    @Deprecated
    public AbstractFormBuilder(UiContainer container, FormLayout layout) {
        this(layout, container);
    }

    public final void setAlignment(CellConstraints.Alignment hAlign, CellConstraints.Alignment vAlign) {
        this.setHAlignment(hAlign);
        this.setVAlignment(vAlign);
    }

    public final void setBounds(int column, int row, int columnSpan, int rowSpan) {
        this.setColumn(column);
        this.setRow(row);
        this.setColumnSpan(columnSpan);
        this.setRowSpan(rowSpan);
    }

    public final void setColumn(int column) {
        this.currentCellConstraints.gridX = column;
    }

    public final int getColumn() {
        return this.currentCellConstraints.gridX;
    }

    public final int getColumnCount() {
        return this.getLayout().getColumnCount();
    }

    public final void setColumnSpan(int columnSpan) {
        this.currentCellConstraints.gridWidth = columnSpan;
    }

    public final UiContainer getContainer() {
        return this.container;
    }

    public final void setExtent(int columnSpan, int rowSpan) {
        this.setColumnSpan(columnSpan);
        this.setRowSpan(rowSpan);
    }

    public final void setHAlignment(CellConstraints.Alignment alignment) {
        this.currentCellConstraints.hAlign = alignment;
    }

    public final FormLayout getLayout() {
        return this.layout;
    }

    public final void setLeftToRight(boolean b) {
        this.leftToRight = b;
    }

    public final boolean isLeftToRight() {
        return this.leftToRight;
    }

    public final void setOrigin(int column, int row) {
        this.setColumn(column);
        this.setRow(row);
    }

    public final void setRow(int row) {
        this.currentCellConstraints.gridY = row;
    }

    public final int getRow() {
        return this.currentCellConstraints.gridY;
    }

    public final int getRowCount() {
        return this.getLayout().getRowCount();
    }

    public final void setRowSpan(int rowSpan) {
        this.currentCellConstraints.gridHeight = rowSpan;
    }

    public final void setVAlignment(CellConstraints.Alignment alignment) {
        this.currentCellConstraints.vAlign = alignment;
    }

    public final UiComponent add(UiComponent component, CellConstraints cellConstraints) {
        this.container.add(component, cellConstraints);
        return component;
    }

    public final UiComponent add(UiComponent component, String encodedCellConstraints) {
        this.container.add(component, new CellConstraints(encodedCellConstraints));
        return component;
    }

    public final UiComponent add(UiComponent component) {
        this.add(component, this.currentCellConstraints);
        return component;
    }

    public final void appendColumn(ColumnSpec columnSpec) {
        this.getLayout().appendColumn(columnSpec);
    }

    public final void appendColumn(String encodedColumnSpec) {
        this.appendColumn(new ColumnSpec(encodedColumnSpec));
    }

    public final void appendGlueColumn() {
        this.appendColumn(FormFactory.GLUE_COLSPEC);
    }

    public final void appendGlueRow() {
        this.appendRow(FormFactory.GLUE_ROWSPEC);
    }

    public final void appendLabelComponentsGapColumn() {
        this.appendColumn(FormFactory.LABEL_COMPONENT_GAP_COLSPEC);
    }

    public final void appendParagraphGapRow() {
        this.appendRow(FormFactory.PARAGRAPH_GAP_ROWSPEC);
    }

    public final void appendRelatedComponentsGapColumn() {
        this.appendColumn(FormFactory.RELATED_GAP_COLSPEC);
    }

    public final void appendRelatedComponentsGapRow() {
        this.appendRow(FormFactory.RELATED_GAP_ROWSPEC);
    }

    public final void appendRow(RowSpec rowSpec) {
        this.getLayout().appendRow(rowSpec);
    }

    public final void appendRow(String encodedRowSpec) {
        this.appendRow(new RowSpec(encodedRowSpec));
    }

    public final void appendUnrelatedComponentsGapColumn() {
        this.appendColumn(FormFactory.UNRELATED_GAP_COLSPEC);
    }

    public final void appendUnrelatedComponentsGapRow() {
        this.appendRow(FormFactory.UNRELATED_GAP_ROWSPEC);
    }

    public final void nextColumn() {
        this.nextColumn(1);
    }

    public final void nextColumn(int columns) {
        this.currentCellConstraints.gridX += columns * this.getColumnIncrementSign();
    }

    public final void nextLine() {
        this.nextLine(1);
    }

    public final void nextLine(int lines) {
        this.nextRow(lines);
        this.setColumn(this.getLeadingColumn());
    }

    public final void nextRow() {
        this.nextRow(1);
    }

    public final void nextRow(int rows) {
        this.currentCellConstraints.gridY += rows;
    }

    protected final int getColumnIncrementSign() {
        return this.isLeftToRight() ? 1 : -1;
    }

    protected final CellConstraints cellConstraints() {
        return this.currentCellConstraints;
    }

    protected int getLeadingColumn() {
        return this.isLeftToRight() ? 1 : this.getColumnCount();
    }

    protected final CellConstraints createLeftAdjustedConstraints(int columnSpan) {
        int firstColumn = this.isLeftToRight() ? this.getColumn() : this.getColumn() + 1 - columnSpan;
        return new CellConstraints(firstColumn, this.getRow(), columnSpan, this.cellConstraints().gridHeight);
    }
}

