/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.ui.layout;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import oracle.bpm.geom.Dimension;
import oracle.bpm.ui.Margin;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.layout.Attribute;
import oracle.bpm.ui.layout.AttributeSource;
import oracle.bpm.ui.layout.AttributeType;
import oracle.bpm.ui.layout.ComponentSpecifications;
import oracle.bpm.ui.layout.Constraint;
import oracle.bpm.ui.layout.DependencyManager;
import oracle.bpm.ui.layout.Layout;

public class RelativeLayout
implements Layout {
    private Map<String, ComponentSpecifications> componentSpecs = new HashMap<String, ComponentSpecifications>();
    private final AttributeSource attributeSource = new AttributeSource(){

        @Override
        public int getValue(Attribute attribute) {
            ComponentSpecifications anchor = (ComponentSpecifications)RelativeLayout.this.componentSpecs.get(attribute.getComponent());
            if (anchor == null) {
                throw new IllegalStateException("Need attribute of unknown component " + attribute.getComponent());
            }
            return anchor.getAttributeValue(attribute.getType());
        }
    };
    private DependencyManager dependencies;
    private Set<String> names = new HashSet<String>();
    private Map<UiComponent, ComponentSpecifications> specsByAWTComponent = new HashMap<UiComponent, ComponentSpecifications>();
    public static final String VERSION = "$Id: RelativeLayout.java 98807 2009-06-03 21:02:52Z diegor $";

    @Override
    public void validateAddedComponent(UiContainer container, UiComponent component, Object constraints) {
    }

    @Override
    public float getLayoutAlignmentX(UiContainer target) {
        return 0.5f;
    }

    @Override
    public float getLayoutAlignmentY(UiContainer target) {
        return 0.5f;
    }

    public void addConstraint(String componentName, AttributeType type, Constraint constraint) {
        this.validateComponentName(componentName);
        this.getComponentSpecifications(componentName).addConstraint(type, constraint);
        this.dependencies = null;
    }

    public void addLayoutComponent(String name, UiComponent component) {
        this.validateComponentName(name);
        if (component == null) {
            throw new IllegalArgumentException("Component  " + name + " is null");
        }
        if (this.specsByAWTComponent.get(component) != null) {
            throw new IllegalStateException("UiComponent " + component + " is already in the layout");
        }
        if (!name.equals(component.getName())) {
            component.setName(name);
        }
        ComponentSpecifications specs = this.getComponentSpecifications(name);
        specs.setComponent(component);
        this.specsByAWTComponent.put(component, specs);
        this.dependencies = null;
    }

    public void addLayoutComponent(UiComponent component, Object constraints) {
        if (constraints instanceof String) {
            this.addLayoutComponent((String)constraints, component);
            return;
        }
        throw new IllegalArgumentException("Unrecognizable constraints");
    }

    @Override
    public void invalidateLayout(UiContainer target) {
    }

    @Override
    public void layoutContainer(UiContainer parent) {
        this.assignLayoutData(parent);
        Dimension size = parent.getSize();
        Margin insets = parent.getInsets();
        int width = size.getWidth() - insets.left - insets.right;
        int height = size.getHeight() - insets.top - insets.bottom;
        this.resolveComponents(false, width, height);
        for (ComponentSpecifications spec : this.componentSpecs.values()) {
            spec.layoutComponent(insets.left, insets.top);
        }
    }

    @Override
    public Dimension maximumLayoutSize(UiContainer target) {
        return Dimension.MAX_VALUE;
    }

    @Override
    public Dimension minimumLayoutSize(UiContainer parent) {
        this.assignLayoutData(parent);
        this.resolveComponents(true, 0, 0);
        return this.addInsets(this.calculateBoundingBox(), parent);
    }

    @Override
    public Dimension preferredLayoutSize(UiContainer parent) {
        this.assignLayoutData(parent);
        this.resolveComponents(false, 0, 0);
        return this.addInsets(this.calculateBoundingBox(), parent);
    }

    @Override
    public void removeLayoutComponent(UiComponent component) {
        ComponentSpecifications specs = this.specsByAWTComponent.get(component);
        if (specs != null) {
            this.specsByAWTComponent.remove(component);
            this.componentSpecs.remove(specs.getComponentName());
            this.dependencies = null;
        }
    }

    private ComponentSpecifications getComponentSpecifications(String name) {
        if (name == null) {
            throw new NullPointerException("UiComponent name cannot be null");
        }
        ComponentSpecifications results = this.componentSpecs.get(name);
        if (results == null) {
            results = new ComponentSpecifications(name);
            this.componentSpecs.put(name, results);
        }
        return results;
    }

    private Dimension addInsets(Dimension spaceNeeded, UiComponent parent) {
        Margin insets = parent.getInsets();
        return Dimension.valueOf(spaceNeeded.getWidth() + insets.left + insets.right, spaceNeeded.getHeight() + insets.top + insets.bottom);
    }

    private Dimension calculateBoundingBox() {
        int minX = Integer.MAX_VALUE;
        int minY = Integer.MAX_VALUE;
        int maxX = Integer.MIN_VALUE;
        int maxY = Integer.MIN_VALUE;
        for (ComponentSpecifications spec : this.componentSpecs.values()) {
            minX = Math.min(minX, spec.getAttributeValue(AttributeType.LEFT));
            minY = Math.min(minY, spec.getAttributeValue(AttributeType.TOP));
            maxX = Math.max(maxX, spec.getAttributeValue(AttributeType.RIGHT));
            maxY = Math.max(maxY, spec.getAttributeValue(AttributeType.BOTTOM));
        }
        return Dimension.valueOf(maxX - minX, maxY - minY);
    }

    private void resolveComponents(boolean minimumSize, int parentWidth, int parentHeight) {
        boolean needDependencies = false;
        if (this.dependencies == null) {
            this.dependencies = new DependencyManager();
            needDependencies = true;
        }
        for (ComponentSpecifications spec : this.componentSpecs.values()) {
            spec.clearAttributeValues();
            if (!needDependencies || spec.getComponentName().equals("_container")) continue;
            spec.reportDependencies(this.dependencies);
        }
        this.resolveContainerSpecs(parentWidth, parentHeight);
        Iterator<ComponentSpecifications> iter = this.dependencies.sort().listIterator();
        while (iter.hasNext()) {
            Attribute attribute = (Attribute)iter.next();
            ComponentSpecifications spec = this.getComponentSpecifications(attribute.getComponent());
            spec.computeAttribute(attribute.getType(), this.attributeSource, minimumSize, parentWidth, parentHeight);
        }
    }

    private void assignLayoutData(UiContainer parent) {
        List<UiComponent> components = parent.getComponents();
        for (UiComponent component : components) {
            Object layoutData = component.getLayoutData();
            if (layoutData == null || this.names.contains(layoutData)) continue;
            this.addLayoutComponent((String)layoutData, component);
            this.names.add((String)layoutData);
        }
    }

    private void resolveContainerSpecs(int width, int height) {
        this.getComponentSpecifications("_container").setContainerSpecs(width, height);
    }

    private void validateComponentName(String name) {
        if ("_container".equals(name)) {
            throw new IllegalArgumentException("The name _container is reserved");
        }
    }
}

