/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.ui.layout;

import java.util.Vector;
import oracle.bpm.geom.Dimension;
import oracle.bpm.ui.Margin;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.layout.AbstractLayout;

public class ContextLayout
extends AbstractLayout {
    protected UiComponent center;
    protected int index = 1;
    protected Vector panels = new Vector();
    protected Vector tabs = new Vector();
    static final long serialVersionUID = -2979815224725726928L;
    static final long serialCheck = 576874899908244127L;

    public ContextLayout() {
    }

    public ContextLayout(int hgap, int vgap) {
        super(hgap, vgap);
    }

    public void setIndex(UiContainer parent, int index) {
        this.index = index;
        this.layoutContainer(parent);
    }

    public int getIndex() {
        return this.index;
    }

    public void addLayoutComponent(UiComponent tab, Object panel) {
        if (panel == null) {
            return;
        }
        this.tabs.addElement(tab);
        this.panels.addElement(panel);
    }

    @Override
    public void layoutContainer(UiContainer target) {
        Dimension size = this.getPreferredTabSize();
        this.layoutTabs(target, this.index, size, target.getSize());
        this.layoutCenter(target, this.index, size, target.getSize());
    }

    @Override
    public Dimension minimumLayoutSize(UiContainer target) {
        Margin insets = target.getInsets();
        Dimension tab = this.getMinimumTabSize();
        int h = tab.getHeight() * (this.tabs.size() + 1) + this.tabs.size() * this.hgap;
        return Dimension.valueOf(tab.getWidth() + insets.left + insets.right + this.hgap * 2, h + insets.top + insets.bottom);
    }

    @Override
    public Dimension preferredLayoutSize(UiContainer target) {
        Margin insets = target.getInsets();
        Dimension tab = this.getPreferredTabSize();
        int h = tab.getHeight() * (this.tabs.size() + 1) + this.tabs.size() * this.hgap;
        return Dimension.valueOf(tab.getWidth() + insets.left + insets.right + this.hgap * 2, h + insets.top + insets.bottom);
    }

    @Override
    public void removeLayoutComponent(UiComponent comp) {
        for (int i = 0; i < this.tabs.size(); ++i) {
            if (this.tabs.elementAt(i) != comp) continue;
            this.tabs.removeElementAt(i);
            this.panels.removeElementAt(i);
            return;
        }
    }

    private Dimension getMinimumTabSize() {
        int w = 0;
        int h = 0;
        for (int i = 0; i < this.tabs.size(); ++i) {
            Dimension size = UiComponent.get(this.tabs.elementAt(i)).getMinimumSize();
            w = Math.max(size.getWidth(), w);
            h = Math.max(size.getHeight(), h);
        }
        return Dimension.valueOf(w, h);
    }

    private Dimension getPreferredTabSize() {
        int w = 0;
        int h = 0;
        for (int i = 0; i < this.tabs.size(); ++i) {
            Dimension size = UiComponent.get(this.tabs.elementAt(i)).getPreferredSize();
            w = Math.max(size.getWidth(), w);
            h = Math.max(size.getHeight(), h);
        }
        return Dimension.valueOf(w, h);
    }

    private void layoutCenter(UiContainer cont, int index, Dimension size, Dimension parent) {
        Margin insets = cont.getInsets();
        int y = size.getHeight() * index + insets.top + this.vgap * index + this.vgap;
        int height = parent.getHeight() - (size.getHeight() + this.vgap) * this.tabs.size() - insets.top - insets.bottom - this.vgap * 2;
        if (this.center != null) {
            cont.remove(this.center);
        }
        this.center = (UiComponent)this.panels.elementAt(index - 1);
        int x = insets.left + this.hgap;
        int width = parent.getWidth() - insets.left - insets.right - this.hgap * 2;
        this.center.setBounds(x, y, width, height);
        cont.add(this.center);
        this.center.asSwing().paintAll(this.center.asSwing().getGraphics());
    }

    private void layoutTabs(UiComponent cont, int index, Dimension size, Dimension parent) {
        UiComponent comp;
        int i;
        Margin insets = cont.getInsets();
        int x = insets.left + this.hgap;
        int y = insets.top + this.vgap;
        int width = parent.getWidth() - insets.left - insets.right - this.hgap * 2;
        int height = size.getHeight();
        for (i = 0; i < index; ++i) {
            comp = (UiComponent)this.tabs.elementAt(i);
            comp.setBounds(x, y, width, height);
            y += height + this.vgap;
        }
        y = parent.getHeight() - insets.bottom - (height + this.vgap) * (this.tabs.size() - index);
        for (i = index; i < this.tabs.size(); ++i) {
            comp = (UiComponent)this.tabs.elementAt(i);
            comp.setBounds(x, y, width, height);
            y += height + this.vgap;
        }
    }
}

