/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.ui.layout;

import java.util.HashMap;
import java.util.HashSet;
import java.util.ListIterator;
import java.util.Map;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.layout.Attribute;
import oracle.bpm.ui.layout.AttributeAxis;
import oracle.bpm.ui.layout.AttributeSource;
import oracle.bpm.ui.layout.AttributeType;
import oracle.bpm.ui.layout.Constraint;
import oracle.bpm.ui.layout.DependencyManager;

public class ComponentSpecifications {
    private UiComponent component;
    private final String componentName;
    private Map<AttributeType, Constraint> constraints = new HashMap<AttributeType, Constraint>();
    private Map<AttributeType, Integer> values = new HashMap<AttributeType, Integer>();
    public static final String VERSION = "$Id: ComponentSpecifications.java 98807 2009-06-03 21:02:52Z diegor $";
    private static final Integer ZERO = 0;

    public ComponentSpecifications(String componentName) {
        this(componentName, null);
    }

    public ComponentSpecifications(String componentName, UiComponent component) {
        this.componentName = componentName;
        this.component = component;
    }

    public void setAttributeValue(AttributeType type, int value) {
        if (this.values.containsKey(type)) {
            throw new IllegalStateException(this.componentName + ": " + type + "resolved more than once");
        }
        if (value == 0) {
            this.values.put(type, ZERO);
        } else {
            this.values.put(type, value);
        }
    }

    public int getAttributeValue(AttributeType type) {
        Integer value = this.values.get(type);
        if (value == null) {
            throw new IllegalStateException(this.componentName + ": " + type + " not yet resolved", this.component.stackTrace);
        }
        return value;
    }

    public void setComponent(UiComponent component) {
        if (this.component != null) {
            throw new IllegalStateException(this.componentName + ": component was already set");
        }
        this.component = component;
    }

    public UiComponent getComponent() {
        return this.component;
    }

    public int getComponentHeight(boolean minimumSize) {
        if (this.component != null) {
            if (minimumSize) {
                return this.component.getMinimumSize().getHeight();
            }
            return this.component.getPreferredSize().getHeight();
        }
        return 0;
    }

    public String getComponentName() {
        return this.componentName;
    }

    public int getComponentWidth(boolean minimumSize) {
        if (this.component != null) {
            if (minimumSize) {
                return this.component.getMinimumSize().getWidth();
            }
            return this.component.getPreferredSize().getWidth();
        }
        return 0;
    }

    public void addConstraint(AttributeType type, Constraint constraint) {
        if (type == null) {
            throw new NullPointerException("type must not be null");
        }
        if (constraint == null) {
            throw new NullPointerException("constraint must not be null");
        }
        HashSet<AttributeType> relevantConstraints = new HashSet<AttributeType>(this.constraints.keySet());
        relevantConstraints.retainAll(AttributeType.getAxisTypes(type.getAxis()));
        if (relevantConstraints.contains(type)) {
            throw new IllegalStateException(this.componentName + ": " + type + " is already constrained");
        }
        if (relevantConstraints.size() > 1) {
            throw new IllegalStateException(this.componentName + ": Cannot add " + type + " constraint without overconstraining");
        }
        this.constraints.put(type, constraint);
    }

    public void clearAttributeValues() {
        this.values.clear();
    }

    public void computeAttribute(AttributeType attribute, AttributeSource allAttrs, boolean minimumSize, int parentWidth, int parentHeight) {
        if (this.constraints.containsKey(attribute)) {
            Constraint constraint = this.constraints.get(attribute);
            this.setAttributeValue(attribute, constraint.getValue(allAttrs));
        } else {
            this.setAttributeValue(attribute, attribute.deriveValue(this, minimumSize));
        }
    }

    public boolean hasConstraint(AttributeType type) {
        return this.constraints.containsKey(type);
    }

    public void layoutComponent(int xOffset, int yOffset) {
        if (this.component != null) {
            this.component.setBounds(this.getAttributeValue(AttributeType.LEFT) + xOffset, this.getAttributeValue(AttributeType.TOP) + yOffset, this.getAttributeValue(AttributeType.WIDTH), this.getAttributeValue(AttributeType.HEIGHT));
        }
    }

    public void reportDependencies(DependencyManager dependencies) {
        this.validateConstraints();
        for (Map.Entry<AttributeType, Constraint> entry : this.constraints.entrySet()) {
            Attribute dependent = new Attribute(this.componentName, entry.getKey());
            Constraint constraint = entry.getValue();
            ListIterator catts = constraint.getDependencies().listIterator();
            while (catts.hasNext()) {
                dependencies.add(dependent, (Attribute)catts.next());
            }
        }
        HashSet<AttributeType> others = new HashSet<AttributeType>(AttributeType.getAllTypes());
        others.removeAll(this.constraints.keySet());
        for (AttributeType unconstrained : others) {
            Attribute derived = new Attribute(this.componentName, unconstrained);
            HashSet<AttributeType> relevantConstraints = new HashSet<AttributeType>(this.constraints.keySet());
            relevantConstraints.retainAll(AttributeType.getAxisTypes(unconstrained.getAxis()));
            for (AttributeType relevantConstraint : relevantConstraints) {
                dependencies.add(derived, new Attribute(this.componentName, relevantConstraint));
            }
        }
    }

    void setContainerSpecs(int width, int height) {
        this.setAttributeValue(AttributeType.LEFT, 0);
        this.setAttributeValue(AttributeType.TOP, 0);
        this.setAttributeValue(AttributeType.RIGHT, width);
        this.setAttributeValue(AttributeType.WIDTH, width);
        this.setAttributeValue(AttributeType.BOTTOM, height);
        this.setAttributeValue(AttributeType.HEIGHT, height);
        this.setAttributeValue(AttributeType.HORIZONTAL_CENTER, width / 2);
        this.setAttributeValue(AttributeType.VERTICAL_CENTER, height / 2);
    }

    private void validateConstraints() {
        HashSet<AttributeType> axisConstraints = new HashSet<AttributeType>(this.constraints.keySet());
        axisConstraints.retainAll(AttributeType.getAxisTypes(AttributeAxis.HORIZONTAL));
        if (axisConstraints.size() < 1 || axisConstraints.size() == 1 && axisConstraints.contains(AttributeType.WIDTH)) {
            throw new IllegalStateException(this.componentName + " is underconstrained horizontally", this.component.stackTrace);
        }
        axisConstraints = new HashSet<AttributeType>(this.constraints.keySet());
        axisConstraints.retainAll(AttributeType.getAxisTypes(AttributeAxis.VERTICAL));
        if (axisConstraints.size() < 1 || axisConstraints.size() == 1 && axisConstraints.contains(AttributeType.HEIGHT)) {
            this.component.stackTrace.printStackTrace();
            throw new IllegalStateException(this.componentName + " is underconstrained vertically", this.component.stackTrace);
        }
    }
}

