/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.ui.layout;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import oracle.bpm.ui.layout.Attribute;
import oracle.bpm.ui.layout.AttributeAxis;
import oracle.bpm.ui.layout.AttributeSource;
import oracle.bpm.ui.layout.AttributeType;
import oracle.bpm.ui.layout.Constraint;

public class AxisConstraint
implements Constraint {
    protected final String anchorName;
    private final AttributeAxis axis;
    private final List dependencies;
    private final double fraction;
    private final Attribute length;
    private final Attribute origin;
    public static final String VERSION = "$Id: AxisConstraint.java 98807 2009-06-03 21:02:52Z diegor $";

    public AxisConstraint(String anchorName, AttributeAxis axis, double position) {
        this.anchorName = anchorName;
        this.axis = axis;
        this.fraction = position;
        if (axis == AttributeAxis.HORIZONTAL) {
            this.origin = new Attribute(anchorName, AttributeType.LEFT);
            this.length = new Attribute(anchorName, AttributeType.WIDTH);
        } else {
            this.origin = new Attribute(anchorName, AttributeType.TOP);
            this.length = new Attribute(anchorName, AttributeType.HEIGHT);
        }
        ArrayList<Attribute> deps = new ArrayList<Attribute>(2);
        deps.add(this.origin);
        deps.add(this.length);
        this.dependencies = Collections.unmodifiableList(deps);
    }

    @Override
    public List getDependencies() {
        return this.dependencies;
    }

    @Override
    public int getValue(AttributeSource attributes) {
        return attributes.getValue(this.origin) + (int)(this.fraction * (double)attributes.getValue(this.length));
    }

    public String toString() {
        return "AxisConstraint: {anchor=" + this.anchorName + ", axis=" + this.axis + ", fraction=" + this.fraction + '}';
    }
}

