/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.ui.forms;

import oracle.bpm.ui.Panel;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.forms.AbstractBaseForm;
import oracle.bpm.ui.layout.form.CellConstraints;
import oracle.bpm.ui.layout.form.ColumnSpec;
import oracle.bpm.ui.layout.form.FormLayout;
import oracle.bpm.ui.layout.form.PanelBuilder;
import oracle.bpm.ui.layout.form.RowSpec;
import org.jetbrains.annotations.NonNls;

abstract class AbstractFormLayoutForm
extends AbstractBaseForm {
    private PanelBuilder builder;
    protected static final RowSpec ROW_SEPARATOR = new RowSpec("5dlu");
    protected static final ColumnSpec COLUMN_SEPARATOR = new ColumnSpec("5dlu");
    public static final int EXPAND_100_PERCENT = 100;
    public static final int EXPAND_80_PERCENT = 75;
    public static final int EXPAND_75_PERCENT = 75;
    public static final int EXPAND_50_PERCENT = 50;
    public static final int EXPAND_25_PERCENT = 25;
    public static final int EXPAND_20_PERCENT = 20;
    protected static final int NO_EXPAND = 0;

    protected AbstractFormLayoutForm(UiContainer container, @NonNls String columnSpecs) {
        this(container, columnSpecs, "");
    }

    protected AbstractFormLayoutForm(UiContainer container, @NonNls String columnSpecs, @NonNls String rowSpecs) {
        super(container);
        this.builder = new PanelBuilder(new FormLayout(columnSpecs, rowSpecs), container);
    }

    protected static boolean existRowSeparator(UiComponent component) {
        boolean result = false;
        if (component instanceof Panel) {
            result = ((Panel)component).hasTitle();
        }
        return result;
    }

    protected static String getGrow(int percent) {
        int p = Math.abs(percent);
        String result = p == 0 ? "" : (p >= 100 ? ":grow" : ":grow(" + String.valueOf((float)p / 100.0f) + ")");
        return result;
    }

    protected void addRowSeparator() {
        this.getLayout().appendRow(ROW_SEPARATOR);
    }

    protected FormLayout getLayout() {
        return this.getPanelBuilder().getLayout();
    }

    protected void add(UiComponent component, CellConstraints cellConstraints) {
        this.getPanelBuilder().add(component, cellConstraints);
    }

    protected int getLastRow() {
        return this.getLayout().getRowCount();
    }

    protected CellConstraints xy(int x, int y) {
        return this.getLayout().createCellConstraints().xy(x, y);
    }

    protected CellConstraints xyw(int x, int y, int w) {
        return this.getLayout().createCellConstraints().xyw(x, y, w);
    }

    private PanelBuilder getPanelBuilder() {
        return this.builder;
    }
}

