/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.ui.forms;

import oracle.bpm.resources.Msg;
import oracle.bpm.ui.CheckBox;
import oracle.bpm.ui.Label;
import oracle.bpm.ui.LabelMultiline;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.RadioButton;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.forms.RowForm;
import oracle.bpm.ui.msg.UIMsg;
import oracle.bpm.ui.text.NumericField;
import oracle.bpm.ui.text.TextArea;
import oracle.bpm.ui.text.TextField;

abstract class AbstractBaseForm {
    private UiContainer container;
    private static final String FORM_MARK = "oracle.bpm.ui.forms.isForm";
    private static final int DEFAULT_TEXTFIELD_COLUMNS = 30;
    private static final int DEFAULT_TEXTAREA_COLUMNS = 30;
    private static final int DEFAULT_TEXTAREA_ROWS = 3;

    AbstractBaseForm(UiContainer container) {
        this.container = container;
        this.markAsForm();
    }

    public TextArea createTextArea() {
        TextArea result = new TextArea(this.getContainer());
        result.setColumns(30);
        result.setRows(3);
        return result;
    }

    public TextField createTextField() {
        return new TextField(this.getContainer(), 30);
    }

    public RowForm createRowForm(Panel panel) {
        return this.createRowForm(panel);
    }

    public TextArea createDescription() {
        return this.createTextArea();
    }

    public LabelMultiline createExplanation(Msg msg) {
        return this.createLabelMultiline(msg);
    }

    public LabelMultiline createLabelMultiline(Msg msg) {
        return new LabelMultiline(this.getContainer(), msg);
    }

    public RadioButton createRadioButton(Msg msg) {
        return new RadioButton(this.getContainer(), msg);
    }

    public CheckBox createCheckBox(Msg msg) {
        return CheckBox.create(this.getContainer(), msg);
    }

    public NumericField<Integer> createIntegerNumericField() {
        return NumericField.createIntegerNumericField(this.getContainer());
    }

    public NumericField<Long> createLongNumericField() {
        return NumericField.createLongNumericField(this.getContainer());
    }

    public NumericField<Float> createFloatNumericField() {
        return NumericField.createFloatNumericField(this.getContainer());
    }

    public NumericField<Double> createDoubleNumericField() {
        return NumericField.createDoubleNumericField(this.getContainer());
    }

    public UiContainer getContainer() {
        return this.container;
    }

    public boolean isInnerForm() {
        UiContainer parent = this.getContainer().getParent();
        return parent.getClientProperty(FORM_MARK) != null;
    }

    protected Label createInternalLabel(Msg msg) {
        return Label.create(this.getContainer(), msg != null ? msg : UIMsg.TO_MSG(""));
    }

    private void markAsForm() {
        this.getContainer().putClientProperty(FORM_MARK, Boolean.TRUE);
    }
}

