/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.ui.event;

import oracle.bpm.ui.table.TableModel;

public class TableModelEvent {
    private int column;
    private int firstRow;
    private int lastRow;
    private Object source;
    private int type;
    public static final int HEADER_ROW = -1;
    public static final int UPDATE = 0;
    public static final int DELETE = -1;
    public static final int INSERT = 1;
    public static final int ALL_COLUMNS = -1;

    public TableModelEvent(TableModel model) {
        this(model, 0, Integer.MAX_VALUE, -1, 0);
    }

    public TableModelEvent(TableModel source, int row) {
        this(source, row, row, -1, 0);
    }

    public TableModelEvent(TableModel source, int firstRow, int lastRow, int column) {
        this(source, firstRow, lastRow, column, 0);
    }

    public TableModelEvent(Object source, int firstRow, int lastRow, int column, int type) {
        this.source = source;
        this.firstRow = firstRow;
        this.lastRow = lastRow;
        this.column = column;
        this.type = type;
    }

    public int getColumn() {
        return this.column;
    }

    public boolean isDelete() {
        return this.type == -1;
    }

    public int getFirstRow() {
        return this.firstRow;
    }

    public boolean isInsert() {
        return this.type == 1;
    }

    public int getLastRow() {
        return this.lastRow;
    }

    public Object getSource() {
        return this.source;
    }

    public int getType() {
        return this.type;
    }

    public boolean isUpdate() {
        return this.getType() == 0;
    }
}

