/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.ui.event;

import oracle.bpm.geom.Point;
import oracle.bpm.ui.UiComponent;

public class MouseEvent {
    private int clickCount;
    private int id;
    private int modifiers;
    private boolean popupTrigger;
    private Object source;
    private int x;
    private int y;

    public MouseEvent(Object source, int id, int modifiers, int x, int y, boolean popupTrigger, int clickCount) {
        this.source = source;
        this.id = id;
        this.modifiers = modifiers;
        this.x = x;
        this.y = y;
        this.popupTrigger = popupTrigger;
        this.clickCount = clickCount;
    }

    public static MouseEvent createTriggerEvent(UiComponent source, Point location) {
        return new MouseEvent(source, 501, 0, location.getX(), location.getY(), true, 1);
    }

    public static MouseEvent createClick(UiComponent source) {
        return new MouseEvent(source, 500, 0, 0, 0, false, 1);
    }

    public static MouseEvent createMove(UiComponent source, Point location) {
        return new MouseEvent(source, 503, 0, location.getX(), location.getY(), false, 0);
    }

    public static MouseEvent createReleased(UiComponent source, Point location) {
        return new MouseEvent(source, 502, 16, location.getX(), location.getY(), false, 1);
    }

    public boolean isButton1() {
        return (this.modifiers & 0x10) == 16;
    }

    public boolean isButton1Down() {
        return (this.modifiers & 0x400) != 0;
    }

    public boolean isButton2() {
        return (this.modifiers & 8) == 8;
    }

    public boolean isButton3() {
        return (this.modifiers & 4) == 4;
    }

    public boolean isButton3Down() {
        return false;
    }

    public int getClickCount() {
        return this.clickCount;
    }

    public UiComponent getComponent() {
        return this.getSource();
    }

    public boolean isControlDown() {
        return (this.modifiers & 2) != 0;
    }

    public boolean isLeftMouseButton() {
        return this.isButton1();
    }

    public boolean isMiddleMouseButton() {
        return this.isButton2();
    }

    public Point getPoint() {
        return new Point(this.x, this.y);
    }

    public boolean isPopupTrigger() {
        return this.popupTrigger;
    }

    public boolean isRightMouseButton() {
        return this.isButton3();
    }

    public boolean isShiftDown() {
        return (this.modifiers & 1) != 0;
    }

    public boolean isAltDown() {
        return (this.modifiers & 8) != 0;
    }

    public void setSource(UiComponent source) {
        this.source = source;
    }

    public UiComponent getSource() {
        return UiComponent.get(this.source);
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public java.awt.event.MouseEvent asSwing() {
        long when = System.currentTimeMillis();
        return new java.awt.event.MouseEvent(this.getSource().asSwing(), this.id, when, this.modifiers, this.getX(), this.getY(), this.getClickCount(), this.isPopupTrigger());
    }

    public MouseEvent changeSource(Object source) {
        return new MouseEvent(source, this.id, this.modifiers, this.getX(), this.getY(), this.isPopupTrigger(), this.getClickCount());
    }

    public boolean isMouseClicked() {
        return this.id == 500;
    }

    public boolean isMousePressed() {
        return this.id == 501;
    }

    public void translatePoint(int x, int y) {
        this.x += x;
        this.y += y;
    }
}

