/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.ui.event;

import java.util.ArrayList;
import oracle.bpm.event.ModificationEvent;
import oracle.bpm.event.ModificationListener;
import oracle.bpm.ui.event.Editable;
import oracle.bpm.ui.event.EditableContainer;

public class DefaultEditionContainer
implements EditableContainer {
    private ModificationListener modificationListener;
    private ArrayList<ModificationListener> modificationListeners = new ArrayList();
    private boolean modified;

    @Override
    public void addEditable(Editable editable) {
        editable.addModificationListener(this.getModificationListener());
    }

    @Override
    public void removeEditable(Editable editable) {
        editable.removeModificationListener(this.getModificationListener());
    }

    @Override
    public boolean isModified() {
        return this.modified;
    }

    @Override
    public void resetModified() {
        this.modified = false;
    }

    @Override
    public void addModificationListener(ModificationListener listener) {
        this.modificationListeners.add(listener);
    }

    @Override
    public void removeModificationListener(ModificationListener listener) {
        this.modificationListeners.remove(listener);
    }

    protected void fireChanged(ModificationEvent event) {
        this.modified = true;
        for (ModificationListener listener : this.modificationListeners) {
            listener.objectModified(event);
        }
    }

    private ModificationListener getModificationListener() {
        if (this.modificationListener == null) {
            this.modificationListener = new ModificationListener(){

                public void objectModified(ModificationEvent event) {
                    DefaultEditionContainer.this.fireChanged(event);
                }
            };
        }
        return this.modificationListener;
    }
}

