/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.ui.dnd;

import oracle.bpm.ui.Ui;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiPeer;
import oracle.bpm.ui.dnd.DndAction;
import oracle.bpm.ui.dnd.Transfer;
import oracle.bpm.ui.peer.DragSourceHandlerPeer;
import oracle.bpm.ui.peer.Peer;

public abstract class DragSourceHandler
extends UiPeer {
    private DndAction actions;
    private Transfer[] transfers;

    public DragSourceHandler(UiComponent source, DndAction actions) {
        this(source, actions, Transfer.NONE);
    }

    public DragSourceHandler(UiComponent source, DndAction actions, Transfer[] transfers) {
        this.transfers = transfers;
        this.actions = actions;
        this.getPeer().createDragSource(source.getComponentPeer());
    }

    public abstract Object getObject(Transfer var1);

    public DndAction getActions() {
        return this.actions;
    }

    public Transfer[] getTransfers() {
        return this.transfers;
    }

    public boolean isDataTypeSupported(Transfer transfer) {
        for (Transfer tt : this.getTransfers()) {
            if (tt != transfer) continue;
            return true;
        }
        return false;
    }

    public boolean cancelDrag() {
        return this.getTransfers().length == 0;
    }

    public void dragFinished(DndAction action) {
    }

    @Override
    public DragSourceHandlerPeer getPeer() {
        return (DragSourceHandlerPeer)super.getPeer();
    }

    public void dragCancelled() {
    }

    @Override
    protected Peer createPeer() {
        return Ui.getUiFactory().createDragSourceHandlerPeer();
    }
}

