/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.ui.colorchoosingcomponent;

import oracle.bpm.draw.Color;
import oracle.bpm.ui.Button;
import oracle.bpm.ui.ColorChooser;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.PopUpWindow;
import oracle.bpm.ui.Separator;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.UiWindow;
import oracle.bpm.ui.border.BorderFactory;
import oracle.bpm.ui.colorchoosingcomponent.ColorChoosingComponent;
import oracle.bpm.ui.colorchoosingcomponent.ColourableButton;
import oracle.bpm.ui.colorchoosingcomponent.PredefinedColor;
import oracle.bpm.ui.event.ActionEvent;
import oracle.bpm.ui.event.ActionListener;
import oracle.bpm.ui.event.CustomEvent;
import oracle.bpm.ui.event.FocusEvent;
import oracle.bpm.ui.event.FocusListener;
import oracle.bpm.ui.layout.form.CellConstraints;
import oracle.bpm.ui.layout.form.FormLayout;
import oracle.bpm.ui.layout.form.PanelBuilder;
import oracle.bpm.ui.msg.UIMsg;

public class ColorsPopUp
extends PopUpWindow {
    private Color selectedColor;

    public ColorsPopUp(UiWindow container) {
        super(container);
        Panel colorPanel = this.createColorPanel(this);
        this.add(colorPanel);
        this.setPreferredSize(colorPanel.getPreferredSize());
    }

    public void showPopUp(UiComponent source, Color initialColor) {
        this.selectedColor = initialColor;
        super.show(source);
    }

    public Color getSelectedColor() {
        return this.selectedColor;
    }

    private static void makeColorButtonFocusable(final ColourableButton button) {
        button.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                button.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(Color.FUEGO_BLUE), BorderFactory.createLineBorder(Color.WHITE)), BorderFactory.createLineBorder(Color.BLACK)));
            }

            @Override
            public void focusLost(FocusEvent e) {
                button.setBorder(BorderFactory.createLineBorder(Color.BLACK));
            }
        });
    }

    private Panel createColorPalette(UiContainer parent) {
        int i;
        Panel colorPalette = new Panel(parent);
        FormLayout layout = new FormLayout("4dlu", "4dlu");
        for (i = 0; i < 8; ++i) {
            layout.appendColumn("fill:6dlu");
            layout.appendColumn("4dlu");
        }
        for (i = 0; i < 5; ++i) {
            layout.appendRow("fill:6dlu");
            layout.appendRow("4dlu");
        }
        PanelBuilder builder = layout.createBuilder(colorPalette);
        CellConstraints cc = layout.createCellConstraints();
        int x = 2;
        int y = 2;
        for (PredefinedColor color : PredefinedColor.values()) {
            final ColourableButton buttonColor = new ColourableButton(colorPalette);
            final Color colorToAdd = color.getColor();
            buttonColor.setBackground(colorToAdd);
            buttonColor.setBorder(BorderFactory.createLineBorder(Color.BLACK));
            buttonColor.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ColorsPopUp.this.selectedColor = colorToAdd;
                    ColorsPopUp.this.fireCustomEventChanged(new CustomEvent<Object>("COLOR_CHANGED", ColorsPopUp.this.selectedColor, null, buttonColor));
                    ColorsPopUp.this.setVisible(false);
                }
            });
            ColorsPopUp.makeColorButtonFocusable(buttonColor);
            buttonColor.setToolTipText(ColorChoosingComponent.getColorAsRGBString(colorToAdd));
            builder.add((UiComponent)buttonColor, cc.xy(x, y));
            x = (x + 2) % 18;
            if (x != 0) continue;
            x = 2;
            y = (y + 2) % 12;
        }
        return colorPalette;
    }

    private Panel createColorPanel(UiContainer parent) {
        Panel panel = new Panel(parent);
        String cols = "pref";
        String rows = "pref, pref, pref";
        FormLayout layout = new FormLayout(cols, rows);
        PanelBuilder builder = layout.createBuilder(panel);
        CellConstraints cc = layout.createCellConstraints();
        builder.add((UiComponent)this.createColorPalette(panel), cc.xy(1, 1));
        builder.add((UiComponent)new Separator(panel), cc.xy(1, 2));
        Button moreColors = new Button((UiContainer)panel, UIMsg.MORE);
        moreColors.addActionListener(new MoreColorsListener(this.getParent()));
        builder.add((UiComponent)moreColors, cc.xy(1, 3));
        return panel;
    }

    private class MoreColorsListener
    implements ActionListener {
        private UiComponent fileChooserParent;

        public MoreColorsListener(UiComponent fileChooserParent) {
            this.fileChooserParent = fileChooserParent;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ColorsPopUp.this.selectedColor = this.invokeColorChooser(ColorsPopUp.this.selectedColor);
            ColorsPopUp.this.setVisible(false);
            ColorsPopUp.this.fireCustomEventChanged(new CustomEvent<Object>("COLOR_CHANGED", ColorsPopUp.this.selectedColor, null, ColorsPopUp.this));
        }

        private Color invokeColorChooser(Color selectedColor) {
            return ColorChooser.showDialog(this.fileChooserParent, selectedColor);
        }
    }

    public static interface SelectColorStrategy {
        public void selectColor(Color var1);
    }
}

