/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.ui.colorchoosingcomponent;

import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import oracle.bpm.draw.Color;
import oracle.bpm.geom.Dimension;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.Button;
import oracle.bpm.ui.Image;
import oracle.bpm.ui.Label;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.border.BorderFactory;
import oracle.bpm.ui.colorchoosingcomponent.ColorsPopUp;
import oracle.bpm.ui.colorchoosingcomponent.ColourableButton;
import oracle.bpm.ui.event.ActionEvent;
import oracle.bpm.ui.event.ActionListener;
import oracle.bpm.ui.event.ChangeEvent;
import oracle.bpm.ui.event.ChangeListener;
import oracle.bpm.ui.event.CustomEvent;
import oracle.bpm.ui.event.CustomEventListener;
import oracle.bpm.ui.event.DocumentEvent;
import oracle.bpm.ui.event.DocumentListener;
import oracle.bpm.ui.layout.form.CellConstraints;
import oracle.bpm.ui.layout.form.FormLayout;
import oracle.bpm.ui.layout.form.PanelBuilder;
import oracle.bpm.ui.msg.UIMsg;
import oracle.bpm.ui.text.RGBTextField;

public class ColorChoosingComponent
extends Panel {
    private ColourableButton colorBox;
    private Button firePopUpButton;
    private List<ChangeListener> listeners;
    private ColorsPopUp popup;
    private RGBTextField redGreenBlueTextField;
    private boolean rgbTxtFdEventEnabled;
    private Color selectedColor;
    private boolean showColorBox;
    private boolean showPopupButton;
    private boolean showTextField;
    private static Color UNSET_COLOR = null;

    public ColorChoosingComponent(UiContainer parent) {
        this(parent, Color.BLACK);
    }

    public ColorChoosingComponent(UiContainer parent, Color initialColor) {
        this(parent, null, initialColor);
    }

    public ColorChoosingComponent(UiContainer parent, Msg tooltipResource) {
        this(parent, tooltipResource, Color.BLACK);
    }

    public ColorChoosingComponent(UiContainer parent, Msg tooltipResource, Color initialColor) {
        this(parent, tooltipResource, initialColor, true, true, true);
    }

    public ColorChoosingComponent(UiContainer parent, Msg tooltipResource, Color initialColor, boolean showColorBox, boolean showTextField, boolean showPopupButton) {
        super(parent);
        this.showColorBox = showColorBox;
        this.showTextField = showTextField;
        this.showPopupButton = showPopupButton;
        this.colorBox = new ColourableButton(this);
        if (tooltipResource != null) {
            this.colorBox.setMsg(tooltipResource);
            this.colorBox.setOptions(8);
        }
        if (showPopupButton) {
            this.colorBox.setFocusable(false);
        }
        this.redGreenBlueTextField = new RGBTextField((UiContainer)this, ColorChoosingComponent.getColorAsRGBString(initialColor));
        this.setSelectedColor(initialColor);
        this.rgbTxtFdEventEnabled = true;
        this.initGui();
        this.listeners = new ArrayList<ChangeListener>();
    }

    public static Panel getColorLabelTableRenderer(UiContainer parent, Color color, Label colorLabel) {
        colorLabel.setBackground(color);
        colorLabel.setText("");
        colorLabel.setPreferredSize(Dimension.valueOf(15, 15));
        colorLabel.setBorder(BorderFactory.createLineBorder(Color.BLACK));
        Panel colorPanel = new Panel(parent);
        colorPanel.setOpaque(false);
        FormLayout layout = new FormLayout("0dlu:grow, pref, 0dlu:grow", "0dlu:grow, pref, 0dlu:grow");
        PanelBuilder builder = layout.createBuilder(colorPanel);
        CellConstraints cc = layout.createCellConstraints();
        builder.add((UiComponent)colorLabel, cc.xy(2, 2));
        return colorPanel;
    }

    @Override
    public void setVisible(boolean visible) {
        super.setVisible(visible);
        Thread.dumpStack();
    }

    @Override
    public void setEnabled(boolean enable) {
        this.colorBox.setEnabled(enable);
        if (!enable) {
            this.colorBox.setBorder(null);
            this.redGreenBlueTextField.setEnabled(enable);
        } else {
            this.colorBox.setBorder(null);
            this.colorBox.setBorder(BorderFactory.createLineBorder(Color.BLACK));
            this.redGreenBlueTextField.setEnabled(enable);
            this.setSelectedColor(Color.BLACK);
        }
        this.firePopUpButton.setEnabled(enable);
    }

    @Override
    public void setPreferredSize(Dimension dimension) {
        this.redGreenBlueTextField.setPreferredSize(Dimension.valueOf(dimension.getWidth() - 110, dimension.getHeight()));
    }

    public void setSelectedColor(Color color) {
        this.setSelectedColor(color, true);
    }

    public void setSelectedColor(Color color, boolean updateRGBTextfield) {
        if (color != null && color != this.selectedColor) {
            this.selectedColor = color;
            this.colorBox.setBackground(this.selectedColor);
            if (updateRGBTextfield) {
                this.redGreenBlueTextField.setText(ColorChoosingComponent.getColorAsRGBString(this.selectedColor));
            }
            this.fireValueChanged();
        }
    }

    public Color getSelectedColor() {
        return this.selectedColor;
    }

    @Override
    public void setToolTipText(String text) {
        super.setToolTipText(text);
        this.colorBox.setToolTipText(text);
    }

    public void addChangeListener(ChangeListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void translate() {
        super.translate();
        this.redGreenBlueTextField.setToolTipText(UIMsg.RGB_TEXTFIELD.getDetail());
    }

    public ActionListener createColorListener() {
        return new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ColorChoosingComponent.this.popup = new ColorsPopUp(ColorChoosingComponent.this.getOwnerWindow());
                ColorChoosingComponent.this.popup.addCustomEventListener(new CustomEventListener(){

                    public void eventChanged(CustomEvent customEvent) {
                        Color color = ColorChoosingComponent.this.popup.getSelectedColor();
                        ColorChoosingComponent.this.rgbTxtFdEventEnabled = false;
                        ColorChoosingComponent.this.setSelectedColor(color);
                        ColorChoosingComponent.this.rgbTxtFdEventEnabled = true;
                    }
                });
                UiComponent source = e.getSource();
                ColorChoosingComponent.this.popup.showPopUp(source, ColorChoosingComponent.this.selectedColor);
            }
        };
    }

    public void addActionListener(ActionListener listener) {
        this.colorBox.addActionListener(listener);
        this.firePopUpButton.addActionListener(listener);
    }

    static String getColorAsRGBString(Color color) {
        return color.getRed() + "," + color.getGreen() + "," + color.getBlue();
    }

    private void fireValueChanged() {
        if (this.listeners != null) {
            for (ChangeListener listener : this.listeners) {
                listener.stateChanged(new ChangeEvent(this));
            }
        }
    }

    private void initGui() {
        this.setOpaque(true);
        String cols = "0dlu";
        String rows = "pref";
        FormLayout layout = new FormLayout(cols, rows);
        PanelBuilder builder = layout.createBuilder(this);
        CellConstraints cc = layout.createCellConstraints();
        if (this.showColorBox) {
            layout.appendColumn("center:pref");
            this.colorBox.setPreferredSize(Dimension.valueOf(15, 15));
            this.colorBox.setBorder(BorderFactory.createLineBorder(Color.BLACK));
            this.colorBox.addActionListener(this.createColorListener());
            builder.add((UiComponent)this.colorBox, cc.xy(layout.getColumnCount(), 1));
        }
        if (this.showTextField) {
            if (this.showColorBox) {
                layout.appendColumn("4dlu");
            }
            layout.appendColumn("fill:pref:grow");
            this.redGreenBlueTextField.addDocumentListener(new DocumentListener(){

                @Override
                public void changedUpdate(DocumentEvent e) {
                    this.update();
                }

                @Override
                public void insertUpdate(DocumentEvent e) {
                    this.update();
                }

                @Override
                public void removeUpdate(DocumentEvent e) {
                    this.update();
                }

                private void update() {
                    Color color;
                    if (ColorChoosingComponent.this.rgbTxtFdEventEnabled && (color = ColorChoosingComponent.this.parseColor(ColorChoosingComponent.this.redGreenBlueTextField.getText())) != UNSET_COLOR) {
                        ColorChoosingComponent.this.setSelectedColor(color, false);
                    }
                }
            });
            this.redGreenBlueTextField.setPreferredSize(Dimension.valueOf(100, 20));
            this.redGreenBlueTextField.setToolTipText(UIMsg.RGB_TEXTFIELD.getDetail());
            builder.add((UiComponent)this.redGreenBlueTextField, cc.xy(layout.getColumnCount(), 1));
        }
        if (this.showPopupButton) {
            if (this.showColorBox || this.showTextField) {
                layout.appendColumn("1dlu");
            }
            layout.appendColumn("left:pref");
            this.firePopUpButton = new Button((UiContainer)this, UIMsg.ARROW, 10);
            this.firePopUpButton.setRolloverEnabled(true);
            this.firePopUpButton.setRolloverIcon(Image.create(UIMsg.ARROW_ROLL));
            this.firePopUpButton.setBorder(null);
            this.firePopUpButton.setContentAreaFilled(false);
            this.firePopUpButton.addActionListener(this.createColorListener());
            builder.add((UiComponent)this.firePopUpButton, cc.xy(layout.getColumnCount(), 1));
        }
    }

    private Color parseColor(String colorToParse) {
        Color colorToBe;
        StringTokenizer tokenizer = new StringTokenizer("," + colorToParse, ",");
        try {
            int red = this.parseToken(tokenizer);
            int green = this.parseToken(tokenizer);
            int blue = this.parseToken(tokenizer);
            colorToBe = Color.valueOf(red, green, blue);
        }
        catch (IllegalArgumentException iae) {
            colorToBe = UNSET_COLOR;
        }
        return colorToBe;
    }

    private int parseToken(StringTokenizer tokenizer) {
        int colorComponent = 0;
        if (tokenizer.hasMoreTokens()) {
            try {
                colorComponent = Integer.parseInt(tokenizer.nextToken());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return colorComponent;
    }
}

