/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.ui.browser;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import oracle.bpm.ui.BorderPanel;
import oracle.bpm.ui.Frame;
import oracle.bpm.ui.LabelMultiline;
import oracle.bpm.ui.OkCancelDialog;
import oracle.bpm.ui.UiWindow;
import oracle.bpm.ui.browser.BrowserLauncherPanel;
import oracle.bpm.ui.browser.launcher.BrowserLauncher;
import oracle.bpm.ui.layout.AttributeType;
import oracle.bpm.ui.layout.RelativeLayout;
import oracle.bpm.ui.msg.UIMsg;
import oracle.bpm.ui.utils.Layout;
import oracle.bpm.util.CommonPreferences;

public class BrowserLauncherDialog
extends OkCancelDialog {
    BrowserLauncherPanel browserPanel;

    private BrowserLauncherDialog(UiWindow parent, String defaultCmd, String previousErrorMsg) {
        super(parent, true);
        this.init(previousErrorMsg);
        this.browserPanel.setCommand(defaultCmd);
        this.setSize(375, 175);
        this.setLocationRelativeTo(parent);
    }

    public static void openURL(Frame parent, File file) throws IOException {
        BrowserLauncherDialog.openURL((UiWindow)parent, file.toURI().toURL());
    }

    public static void openURL(URL url) throws IOException {
        BrowserLauncherDialog.openURL(null, url);
    }

    public static void openURL(UiWindow parent, URL url) throws IOException {
        block5: {
            CommonPreferences preferences = CommonPreferences.getInstance();
            BrowserLauncher.setBrowser(preferences.getDefaultBrowser());
            try {
                BrowserLauncher.openURL(url);
            }
            catch (IOException e) {
                String browser;
                if (!BrowserLauncher.isBrowserConfigurable()) {
                    throw e;
                }
                try {
                    browser = BrowserLauncher.tryNewBrowser(url);
                }
                catch (IOException e1) {
                    browser = BrowserLauncherDialog.chooseBrowser(parent, url, e1);
                }
                if (browser == null) break block5;
                preferences.setDefaultBrowser(browser);
                preferences.store();
            }
        }
    }

    @Override
    public void ok() {
        this.close();
    }

    private static String chooseBrowser(UiWindow parent, URL url, IOException e) {
        String browser = null;
        String errorMsg = e.getMessage();
        int beginIndex = errorMsg.indexOf("java.io.IOException");
        if (beginIndex >= 0) {
            errorMsg = errorMsg.substring(beginIndex + "java.io.IOException".length() + 1);
        }
        BrowserLauncherDialog dialog = new BrowserLauncherDialog(parent, CommonPreferences.getInstance().getDefaultBrowser(), errorMsg);
        dialog.setVisible(true);
        if (dialog.userAccepted()) {
            browser = dialog.getBrowserCmd();
            BrowserLauncher.setBrowser(browser);
            try {
                BrowserLauncher.openURL(url);
            }
            catch (IOException e1) {
                browser = BrowserLauncherDialog.chooseBrowser(parent, url, e);
            }
        }
        return browser;
    }

    private String getBrowserCmd() {
        return this.browserPanel.getCommand();
    }

    private void init(String errorMsg) {
        BorderPanel panel = new BorderPanel(this.getContentPane());
        LabelMultiline textArea = new LabelMultiline(panel, UIMsg.CHOOSE_BROWSER(errorMsg));
        this.browserPanel = new BrowserLauncherPanel(panel);
        RelativeLayout layout = new RelativeLayout();
        panel.setLayout(layout);
        panel.add(textArea, "textArea");
        panel.add(this.browserPanel, "browserPanel");
        Layout.fixToRoot(layout, "textArea", AttributeType.LEFT, 5);
        Layout.fixToRoot(layout, "textArea", AttributeType.TOP, 5);
        Layout.fixToRoot(layout, "textArea", AttributeType.RIGHT, -5);
        Layout.fixToRoot(layout, "browserPanel", AttributeType.LEFT, 5);
        Layout.fixToComp(layout, "browserPanel", AttributeType.TOP, "textArea", AttributeType.BOTTOM, 5);
        Layout.fixToRoot(layout, "browserPanel", AttributeType.RIGHT, -5);
        this.getContentPane().add(panel);
    }
}

