/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.ui.border;

import oracle.bpm.draw.Color;
import oracle.bpm.draw.Font;
import oracle.bpm.draw.FontMetrics;
import oracle.bpm.draw.Graphics;
import oracle.bpm.geom.Dimension;
import oracle.bpm.geom.Insets;
import oracle.bpm.geom.Rectangle;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiManager;
import oracle.bpm.ui.border.Border;
import oracle.bpm.ui.msg.UIMsg;
import oracle.bpm.ui.peer.swing.AwtConverter;

public class TitledBorder
extends Border {
    protected Border border;
    protected String title;
    protected Color titleColor;
    protected Font titleFont;
    protected int titleJustification;
    protected int titlePosition;
    private Msg msg;
    private int textLocX;
    private int textLocY;
    public static final int DEFAULT_POSITION = 0;
    public static final int ABOVE_TOP = 1;
    public static final int TOP = 2;
    public static final int BELOW_TOP = 3;
    public static final int ABOVE_BOTTOM = 4;
    public static final int BOTTOM = 5;
    public static final int BELOW_BOTTOM = 6;
    public static final int DEFAULT_JUSTIFICATION = 0;
    public static final int LEFT = 1;
    public static final int CENTER = 2;
    public static final int RIGHT = 3;
    public static final int LEADING = 4;
    public static final int TRAILING = 5;
    protected static final int EDGE_SPACING = 2;
    protected static final int TEXT_SPACING = 2;
    protected static final int TEXT_INSET_H = 5;

    public TitledBorder(Msg msg) {
        super(new javax.swing.border.TitledBorder(""));
        this.setMsg(msg);
    }

    public TitledBorder(String title) {
        this(null, title, 4, 2, null, null);
    }

    public TitledBorder(Border border) {
        this(border, "", 4, 2, null, null);
    }

    public TitledBorder(Border border, Msg msg) {
        super(new javax.swing.border.TitledBorder(border.asSwing()));
        this.setMsg(msg);
    }

    public TitledBorder(Border border, String title) {
        this(border, title, 4, 2, null, null);
    }

    public TitledBorder(Border border, Msg msg, int titleJustification, int titlePosition) {
        super(new javax.swing.border.TitledBorder(border.asSwing(), "", titleJustification, titlePosition));
        this.setMsg(msg);
    }

    public TitledBorder(Border border, String title, int titleJustification, int titlePosition) {
        this(border, title, titleJustification, titlePosition, null, null);
    }

    public TitledBorder(Border border, String title, int titleJustification, int titlePosition, Font titleFont) {
        this(border, title, titleJustification, titlePosition, titleFont, null);
    }

    public TitledBorder(Border border, Msg msg, int titleJustification, int titlePosition, Font titleFont, Color titleColor) {
        super(new javax.swing.border.TitledBorder(border.asSwing(), "", titleJustification, titlePosition, AwtConverter.toAwt(titleFont), AwtConverter.toAwt(titleColor)));
        this.setMsg(msg);
    }

    public TitledBorder(Border border, String title, int titleJustification, int titlePosition, Font titleFont, Color titleColor) {
        this(UIMsg.TO_MSG(title));
        this.title = title;
        this.border = border;
        this.titleFont = titleFont;
        this.titleColor = titleColor;
        this.setTitleJustification(titleJustification);
        this.setTitlePosition(titlePosition);
    }

    public void setMsg(Msg msg) {
        this.msg = msg;
        this.update();
    }

    public Msg getMsg() {
        return this.msg;
    }

    public void translate() {
        this.update();
    }

    @Override
    public void paintBorder(UiComponent c, Graphics graphics, int x, int y, int width, int height) {
        Border border = this.getBorder();
        if (this.getTitle() == null || this.getTitle().equals("")) {
            if (border != null) {
                border.paintBorder(c, graphics, x, y, width, height);
            }
            return;
        }
        int grooveRectX = x + 2;
        int grooveRectY = y + 2;
        int grooveRectWidth = width - 4;
        int grooveRectHeight = height - 4;
        Font prevFont = graphics.getFont();
        Color color = graphics.getForeground();
        Font font = this.getFont(c);
        graphics.setFont(font);
        FontMetrics fm = graphics.getFontMetrics();
        int fontHeight = fm.getHeight();
        int descent = fm.getDescent();
        int ascent = fm.getAscent();
        int diff = -1;
        int stringWidth = fm.stringWidth(this.getTitle());
        Insets insets = border == null ? Insets.EMPTY : border.getBorderInsets(c);
        int titlePos = this.getTitlePosition();
        switch (titlePos) {
            case 0: 
            case 2: {
                diff = Math.max(0, ascent / 2 + 2 - 2);
                grooveRectHeight -= diff;
                this.textLocY = (grooveRectY += diff) - descent + (insets.top + ascent + descent) / 2;
                break;
            }
            case 3: {
                this.textLocY = grooveRectY + insets.top + ascent + 2;
                break;
            }
            case 1: {
                diff = ascent + descent + (Math.max(2, 4) - 2);
                grooveRectHeight -= diff;
                this.textLocY = (grooveRectY += diff) - (descent + 2);
                break;
            }
            case 4: {
                this.textLocY = grooveRectY + grooveRectHeight - (insets.bottom + descent + 2);
                break;
            }
            case 5: {
                this.textLocY = grooveRectY + (grooveRectHeight -= fontHeight / 2) - descent + (ascent + descent - insets.bottom) / 2;
                break;
            }
            case 6: {
                this.textLocY = grooveRectY + (grooveRectHeight -= fontHeight) + ascent + 2;
            }
        }
        int justification = this.getTitleJustification();
        if (!c.getComponentOrientation().isLeftToRight()) {
            if (justification == 4 || justification == 0) {
                justification = 3;
            } else if (justification == 5) {
                justification = 1;
            }
        } else if (justification == 4 || justification == 0) {
            justification = 1;
        } else if (justification == 5) {
            justification = 3;
        }
        switch (justification) {
            case 1: {
                this.textLocX = grooveRectX + 5 + insets.left;
                break;
            }
            case 3: {
                this.textLocX = grooveRectX + grooveRectWidth - (stringWidth + 5 + insets.right);
                break;
            }
            case 2: {
                this.textLocX = grooveRectX + (grooveRectWidth - stringWidth) / 2;
            }
        }
        if (border != null) {
            if ((titlePos == 2 || titlePos == 0) && grooveRectY > this.textLocY - ascent || titlePos == 5 && grooveRectY + grooveRectHeight < this.textLocY + descent) {
                Rectangle saveClip;
                Rectangle clipRect = new Rectangle();
                clipRect = saveClip = graphics.getClipBounds();
                if ((clipRect = TitledBorder.computeIntersection(clipRect, x, y, this.textLocX - 1 - x, height)) != null) {
                    graphics.setClip(clipRect);
                    border.paintBorder(c, graphics, grooveRectX, grooveRectY, grooveRectWidth, grooveRectHeight);
                }
                clipRect = saveClip;
                if ((clipRect = TitledBorder.computeIntersection(clipRect, this.textLocX + stringWidth + 1, y, x + width - (this.textLocX + stringWidth + 1), height)) != null) {
                    graphics.setClip(clipRect);
                    border.paintBorder(c, graphics, grooveRectX, grooveRectY, grooveRectWidth, grooveRectHeight);
                }
                if (titlePos == 2 || titlePos == 0) {
                    clipRect = saveClip;
                    if ((clipRect = TitledBorder.computeIntersection(clipRect, this.textLocX - 1, this.textLocY + descent, stringWidth + 2, y + height - this.textLocY - descent)) != null) {
                        graphics.setClip(clipRect);
                        border.paintBorder(c, graphics, grooveRectX, grooveRectY, grooveRectWidth, grooveRectHeight);
                    }
                } else {
                    clipRect = saveClip;
                    if ((clipRect = TitledBorder.computeIntersection(clipRect, this.textLocX - 1, y, stringWidth + 2, this.textLocY - ascent - y)) != null) {
                        graphics.setClip(clipRect);
                        border.paintBorder(c, graphics, grooveRectX, grooveRectY, grooveRectWidth, grooveRectHeight);
                    }
                }
                graphics.setClip(saveClip);
            } else {
                border.paintBorder(c, graphics, grooveRectX, grooveRectY, grooveRectWidth, grooveRectHeight);
            }
        }
        graphics.setForeground(this.getTitleColor());
        graphics.drawString(this.getTitle(), this.textLocX, this.textLocY);
        graphics.setFont(prevFont);
        graphics.setForeground(color);
    }

    @Override
    public Insets getBorderInsets(UiComponent c) {
        return this.getBorderInsets(c, Insets.EMPTY);
    }

    public Insets getBorderInsets(UiComponent c, Insets insets) {
        int insetsRight;
        int insetsLeft;
        int insetsBottom;
        int insetsTop;
        int descent = 0;
        int ascent = 16;
        int height = 16;
        Border border = this.getBorder();
        if (border != null) {
            Insets borderInsets = border.getBorderInsets(c);
            insetsTop = borderInsets.top;
            insetsBottom = borderInsets.bottom;
            insetsLeft = borderInsets.left;
            insetsRight = borderInsets.right;
        } else {
            insetsRight = 0;
            insetsLeft = 0;
            insetsBottom = 0;
            insetsTop = 0;
        }
        insetsTop += 4;
        insetsBottom += 4;
        insetsRight += 4;
        insetsLeft += 4;
        if (c == null || this.getTitle() == null || this.getTitle().equals("")) {
            return new Insets(insetsTop, insetsLeft, insetsBottom, insetsRight);
        }
        Font font = this.getFont(c);
        FontMetrics fm = c.getFontMetrics(font);
        if (fm != null) {
            descent = fm.getDescent();
            ascent = fm.getAscent();
            height = fm.getHeight();
        }
        switch (this.getTitlePosition()) {
            case 1: {
                insetsTop += ascent + descent + (Math.max(2, 4) - 2);
                break;
            }
            case 0: 
            case 2: {
                insetsTop += ascent + descent;
                break;
            }
            case 3: {
                insetsTop += ascent + descent + 2;
                break;
            }
            case 4: {
                insetsBottom += ascent + descent + 2;
                break;
            }
            case 5: {
                insetsBottom += ascent + descent;
                break;
            }
            case 6: {
                insetsBottom += height;
            }
        }
        return new Insets(insetsTop, insetsLeft, insetsBottom, insetsRight);
    }

    @Override
    public boolean isBorderOpaque() {
        return false;
    }

    public String getTitle() {
        return this.title;
    }

    public Border getBorder() {
        Border b = this.border;
        if (b == null) {
            b = UiManager.border("TitledBorder.border");
        }
        return b;
    }

    public int getTitlePosition() {
        return this.titlePosition;
    }

    public int getTitleJustification() {
        return this.titleJustification;
    }

    public Font getTitleFont() {
        Font result = this.titleFont;
        if (result == null) {
            result = UiManager.font("TitledBorder.font");
        }
        return result;
    }

    public Color getTitleColor() {
        Color result = this.titleColor;
        if (result == null) {
            result = UiManager.color("TitledBorder.titleColor");
        }
        return result;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setBorder(Border border) {
        this.border = border;
    }

    public void setTitlePosition(int titlePosition) {
        switch (titlePosition) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                this.titlePosition = titlePosition;
                break;
            }
            default: {
                throw new IllegalArgumentException(titlePosition + " invalid title position.");
            }
        }
    }

    public void setTitleJustification(int titleJustification) {
        switch (titleJustification) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                this.titleJustification = titleJustification;
                break;
            }
            default: {
                throw new IllegalArgumentException(titleJustification + " invalid title justification.");
            }
        }
    }

    public void setTitleFont(Font titleFont) {
        this.titleFont = titleFont;
    }

    public void setTitleColor(Color titleColor) {
        this.titleColor = titleColor;
    }

    public Dimension getMinimumSize(UiComponent c) {
        Insets insets = this.getBorderInsets(c);
        int minWidth = insets.right + insets.left;
        int minHeigh = insets.top + insets.bottom;
        Font font = this.getFont(c);
        FontMetrics fm = c.getFontMetrics(font);
        switch (this.titlePosition) {
            case 1: 
            case 6: {
                minWidth = Math.max(fm.stringWidth(this.getTitle()), minWidth);
                break;
            }
            default: {
                minWidth += fm.stringWidth(this.getTitle());
            }
        }
        return Dimension.valueOf(minWidth, minHeigh);
    }

    protected Font getFont(UiComponent c) {
        Font font = this.getTitleFont();
        if (font != null) {
            return font;
        }
        if (c != null && (font = c.getFont()) != null) {
            return font;
        }
        return Font.DIALOG;
    }

    private static Rectangle computeIntersection(Rectangle dest, int rx, int ry, int rw, int rh) {
        int y2;
        int x1 = Math.max(rx, dest.getX());
        int x2 = Math.min(rx + rw, dest.getX() + dest.getWidth());
        int y1 = Math.max(ry, dest.getY());
        if ((dest = new Rectangle(x1, y1, x2 - x1, (y2 = Math.min(ry + rh, dest.getY() + dest.getHeight())) - y1)).getWidth() <= 0 || dest.getHeight() <= 0) {
            return null;
        }
        return dest;
    }

    private void update() {
        if (this.msg != null) {
            ((javax.swing.border.TitledBorder)this.asSwing()).setTitle(this.msg.getString());
        }
    }
}

