/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.ui.border;

import oracle.bpm.draw.Color;
import oracle.bpm.draw.Font;
import oracle.bpm.draw.FontMetrics;
import oracle.bpm.draw.Graphics;
import oracle.bpm.geom.Insets;
import oracle.bpm.geom.Rectangle;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiManager;
import oracle.bpm.ui.border.Border;

public class LineTitledBorder
extends Border {
    private int position_d;
    private String title_d;
    private boolean useSystemColors = true;
    private static final Color SOME_GRAY = Color.valueOf(127, 127, 124);
    protected static final int EDGE_SPACING = 2;
    protected static final int TEXT_SPACING = 2;
    protected static final int TEXT_INSET_H = 5;
    public static final int MIDDLE = 0;
    public static final int BOTTOM = 1;

    public LineTitledBorder() {
        this(null, 0);
    }

    public LineTitledBorder(int position) {
        this(null, position);
    }

    public LineTitledBorder(String title) {
        this(title, 0);
    }

    public LineTitledBorder(String title, boolean useSystemColors) {
        this(title);
        this.useSystemColors = useSystemColors;
    }

    LineTitledBorder(String title, int position) {
        super(null);
        this.title_d = title;
        this.position_d = position;
    }

    @Override
    public boolean isBorderOpaque() {
        return false;
    }

    @Override
    public Insets getBorderInsets(UiComponent c) {
        return this.getBorderInsets(c, new Insets(0, 0, 0, 0));
    }

    public Insets getBorderInsets(UiComponent c, Insets insets) {
        int descent = 0;
        int ascent = 16;
        int left = 0;
        int top = 0;
        int right = 0;
        int bottom = 0;
        left += 4;
        right += 4;
        top += 4;
        bottom += 4;
        if (c == null || this.getTitle() == null || this.getTitle().equals("")) {
            return insets;
        }
        FontMetrics fm = c.getFontMetrics(this.getFont(c));
        if (fm != null) {
            descent = fm.getDescent();
            ascent = fm.getAscent();
        }
        switch (this.position_d) {
            case 0: {
                top += ascent + descent;
                break;
            }
            case 1: {
                bottom = ascent + descent;
            }
        }
        return new Insets(top, left, bottom, right);
    }

    public Color getTitleColor() {
        return UiManager.color("TitledBorder.titleColor");
    }

    @Override
    public void paintBorder(UiComponent c, Graphics g, int x, int y, int width, int height) {
        Font font;
        Color color;
        String title = this.getTitle();
        if (title == null || title.length() <= 0) {
            color = null;
            font = null;
        } else {
            int textLocY;
            Rectangle grooveRect = new Rectangle(x + 2, y + 2, width - 4, height - 4);
            font = g.getFont();
            color = g.getForeground();
            g.setFont(this.getFont(c));
            FontMetrics fm = g.getFontMetrics();
            int fontHeight = fm.getHeight();
            int descent = fm.getDescent();
            int ascent = fm.getAscent();
            int strWidth = fm.stringWidth(title) + 2;
            switch (this.position_d) {
                case 0: {
                    int diff = Math.max(0, ascent / 2 + 2 - 2);
                    grooveRect = new Rectangle(grooveRect.getX(), grooveRect.getY() + diff, grooveRect.getWidth(), grooveRect.getHeight() - diff);
                    textLocY = grooveRect.getY() - descent + (ascent + descent) / 2;
                    break;
                }
                case 1: {
                    grooveRect = new Rectangle(grooveRect.getX(), grooveRect.getY(), grooveRect.getWidth(), grooveRect.getHeight() - fontHeight / 2);
                    textLocY = grooveRect.getY() + grooveRect.getHeight() - descent + (ascent + descent) / 2;
                    break;
                }
                default: {
                    textLocY = 0;
                }
            }
            int textLocX = grooveRect.getX();
            Color clr = this.useSystemColors ? UiManager.color("menuText") : Color.WHITE;
            g.setForeground(clr);
            g.drawString(title, textLocX + 1, textLocY + 1);
            if (!this.useSystemColors) {
                g.setForeground(SOME_GRAY);
                g.drawString(title, textLocX, textLocY);
            }
            x = textLocX + strWidth;
            y = textLocY - (fm.getHeight() - ascent / 2) / 2;
        }
        switch (this.position_d) {
            case 1: {
                y = height - 2;
            }
        }
        g.setForeground(UiManager.color("controlShadow"));
        g.drawLine(x, y, width, y);
        g.setForeground(Color.WHITE);
        g.drawLine(x, ++y, width, y);
        if (font != null) {
            g.setFont(font);
        }
        if (color != null) {
            g.setForeground(color);
        }
    }

    protected Font getFont(UiComponent c) {
        Font font;
        return c != null && (font = c.getFont()) != null ? font : Font.DIALOG;
    }

    private String getTitle() {
        return this.title_d;
    }
}

