/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.ui.border;

import oracle.bpm.draw.Color;
import oracle.bpm.draw.Graphics;
import oracle.bpm.geom.Insets;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiManager;
import oracle.bpm.ui.border.Border;

public class CustomLineBorder
extends Border {
    protected Color lineColor;
    protected int thickness = 1;
    private int sides;
    public static final int TOP = 1;
    public static final int RIGHT = 2;
    public static final int BOTTOM = 4;
    public static final int LEFT = 8;

    public CustomLineBorder() {
        this(15);
    }

    public CustomLineBorder(int sides) {
        this(UiManager.color("controlShadow"), sides);
    }

    public CustomLineBorder(Color color, int sides) {
        this.lineColor = color;
        this.sides = sides;
    }

    @Override
    public boolean isBorderOpaque() {
        return false;
    }

    public Insets getBorderInsets(UiComponent c, Insets insets) {
        int top = 0;
        int left = 0;
        int bottom = 0;
        int right = 0;
        if (this.getSide(1)) {
            top += this.thickness;
        }
        if (this.getSide(2)) {
            right += this.thickness;
        }
        if (this.getSide(4)) {
            bottom += this.thickness;
        }
        if (this.getSide(8)) {
            left += this.thickness;
        }
        insets = new Insets(top, left, bottom, right);
        return insets;
    }

    @Override
    public Insets getBorderInsets(UiComponent c) {
        int top = 0;
        int left = 0;
        int bottom = 0;
        int right = 0;
        if (this.getSide(1)) {
            top += this.thickness;
        }
        if (this.getSide(2)) {
            right += this.thickness;
        }
        if (this.getSide(4)) {
            bottom += this.thickness;
        }
        if (this.getSide(8)) {
            left += this.thickness;
        }
        return new Insets(top, left, bottom, right);
    }

    public void setLineColor(Color lineColor) {
        this.lineColor = lineColor;
    }

    public void drawRect(Graphics g, int x, int y, int width, int height) {
        if (width < 0 || height < 0) {
            return;
        }
        if (height == 0 || width == 0) {
            g.drawLine(x, y, x + width, y + height);
        } else {
            if (this.getSide(1)) {
                g.drawLine(x, y, x + width, y);
            }
            if (this.getSide(2)) {
                g.drawLine(x + width, y, x + width, y + height);
            }
            if (this.getSide(4)) {
                g.drawLine(x + width, y + height, x, y + height);
            }
            if (this.getSide(8)) {
                g.drawLine(x, y + height, x, y);
            }
        }
    }

    @Override
    public void paintBorder(UiComponent c, Graphics g, int x, int y, int width, int height) {
        Color oldColor = g.getForeground();
        g.setForeground(this.lineColor);
        for (int i = 0; i < this.thickness; ++i) {
            this.drawRect(g, x + i, y + i, width - i - i - 1, height - i - i - 1);
        }
        g.setForeground(oldColor);
    }

    private boolean getSide(int side) {
        return (this.sides & side) != 0;
    }
}

