/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.ui.border;

import oracle.bpm.draw.Color;
import oracle.bpm.ui.border.BevelBorder;
import oracle.bpm.ui.border.Border;
import oracle.bpm.ui.border.CompoundBorder;
import oracle.bpm.ui.border.EmptyBorder;
import oracle.bpm.ui.border.EtchedBorder;
import oracle.bpm.ui.border.LineBorder;
import oracle.bpm.ui.border.TitledBorder;

public class BorderFactory {
    private static EmptyBorder emptyBorder;
    private static Border sharedEtchedBorder;

    public static Border createBevelBorder(int type) {
        return new BevelBorder(type);
    }

    public static Border createBevelBorder(int type, Color highlightOuter, Color highlightInner, Color shadowOuter, Color shadowInner) {
        return new BevelBorder(type, highlightOuter, highlightInner, shadowOuter, shadowInner);
    }

    public static Border createCompoundBorder(Border outsideBorder, Border insideBorder) {
        return new CompoundBorder(outsideBorder, insideBorder);
    }

    public static Border createEmptyBorder() {
        if (emptyBorder == null) {
            emptyBorder = new EmptyBorder(0, 0, 0, 0);
        }
        return emptyBorder;
    }

    public static Border createEmptyBorder(int size) {
        return new EmptyBorder(size, size, size, size);
    }

    public static Border createEmptyBorder(int top, int left, int bottom, int right) {
        return new EmptyBorder(top, left, bottom, right);
    }

    public static Border createEtchedBorder() {
        if (sharedEtchedBorder == null) {
            sharedEtchedBorder = new EtchedBorder(0);
        }
        return sharedEtchedBorder;
    }

    public static Border createEtchedBorder(int type) {
        return new EtchedBorder(type);
    }

    public static Border createEtchedBorder(Color highlight, Color shadow) {
        return new EtchedBorder(highlight, shadow);
    }

    public static Border createLineBorder(Color color) {
        return new LineBorder(color);
    }

    public static Border createLineBorder(Color color, int thickness) {
        return new LineBorder(color, thickness);
    }

    public static Border createLoweredBevelBorder() {
        return BorderFactory.createBevelBorder(1);
    }

    public static Border createRaisedBevelBorder() {
        return BorderFactory.createBevelBorder(0);
    }

    public static Border createTitledBorder(Border border, String title) {
        return new TitledBorder(border, title);
    }
}

