/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.ui.action;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import oracle.bpm.adapter.Adaptable;
import oracle.bpm.adapter.DefaultAdaptable;
import oracle.bpm.extension.Extension;
import oracle.bpm.extension.ExtensionService;
import oracle.bpm.extensionpoint.metadata.ActionGroupMetadata;
import oracle.bpm.lang.Platform;
import oracle.bpm.msg.CoreMsg;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.ActionFilter;
import oracle.bpm.ui.ActionFilterComposite;
import oracle.bpm.ui.CompositeMenu;
import oracle.bpm.ui.FuegoActionContainer;
import oracle.bpm.ui.Menu;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.action.ActionGroupFactory;
import oracle.bpm.ui.action.BaseAction;
import oracle.bpm.ui.selection.Selection;

public class ActionGroup
extends BaseAction
implements FuegoActionContainer {
    private List<BaseAction> actions;
    private ActionFilterComposite actionValidatorComposite = new ActionFilterComposite();
    private boolean inline;
    private static Map<Class, Collection<ActionGroupFactory>> factories;
    private static final BaseAction[] EMPTY;

    public ActionGroup() {
        this(CoreMsg.EMPTY);
    }

    public ActionGroup(Msg msg) {
        this(msg, Object.class);
    }

    public ActionGroup(Msg msg, ActionFilter actionValidator) {
        this(msg);
        this.actionValidatorComposite.addActionFilter(actionValidator);
    }

    public ActionGroup(Msg msg, Class ... requiredClasses) {
        super(msg);
        this.requires(requiredClasses);
    }

    public static ActionGroup create(Object context) {
        ActionGroup result = ActionGroup.create(DefaultAdaptable.create(context), context.getClass(), new HashSet<Class>());
        result.sort();
        return result;
    }

    public static ActionGroup create(Object context, Class cl) {
        ActionGroup result = ActionGroup.create(DefaultAdaptable.create(context), cl, new HashSet<Class>());
        result.sort();
        return result;
    }

    public void add(BaseAction action) {
        if (action == null) {
            throw new IllegalArgumentException("Null action");
        }
        if (this.actions == null) {
            this.actions = new ArrayList<BaseAction>();
        }
        if (this.isValid(action)) {
            this.actions.add(action);
        }
    }

    public void sort() {
        if (this.actions != null) {
            Collections.sort(this.actions, new Comparator<BaseAction>(){

                @Override
                public int compare(BaseAction action1, BaseAction action2) {
                    return action1.getOrder().compareTo(action2.getOrder());
                }
            });
        }
    }

    public void addActionValidator(ActionFilter actionValidator) {
        this.actionValidatorComposite.addActionFilter(actionValidator);
    }

    @Override
    public void addFuegoAction(BaseAction action) {
        this.add(action);
    }

    public void addSeparator() {
        if (this.actions != null && this.actions.size() > 0 && this.actions.get(this.actions.size() - 1) != BaseAction.SEPARATOR) {
            this.add(BaseAction.SEPARATOR);
        }
    }

    @Override
    public void addToMenu(CompositeMenu menu) {
        if (this.getActions().length > 0) {
            if (this.isInline()) {
                this.fillMenu(menu);
            } else {
                Menu subMenu = new Menu((UiContainer)((Object)menu));
                subMenu.setAction(this);
                subMenu.setMsg(this.getMsg());
                this.fillMenu(subMenu);
                menu.add(subMenu);
            }
        }
    }

    public BaseAction[] getActions() {
        BaseAction[] result = EMPTY;
        if (this.actions != null) {
            result = new BaseAction[this.actions.size()];
            this.actions.toArray(result);
        }
        return result;
    }

    public boolean isInline() {
        return this.inline;
    }

    @Override
    public void run() {
        throw new UnsupportedOperationException();
    }

    public void setInline(boolean inline) {
        this.inline = inline;
    }

    @Override
    public void setSelection(Selection selection) {
        for (BaseAction action : this.getActions()) {
            if (action == BaseAction.SEPARATOR) continue;
            action.setSelection(selection);
        }
        super.setSelection(selection);
    }

    @Override
    public void requires(Class cl) {
        super.requires(cl);
    }

    public void requires(Class ... requiredClass) {
        for (Class clazz : requiredClass) {
            this.requires(clazz);
        }
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("ActionGroup(").append(this.getName()).append(") {");
        for (BaseAction action : this.getActions()) {
            builder.append(action);
        }
        builder.append("}");
        return builder.toString();
    }

    public void addAll(BaseAction[] actions) {
        for (BaseAction action : actions) {
            this.add(action);
        }
    }

    @Override
    protected void fillMenu(CompositeMenu menu) {
        for (BaseAction action : this.getActions()) {
            if (action == SEPARATOR) {
                menu.addSeparator();
                continue;
            }
            if (!action.isEnabled() && !action.isShowOnDisabled()) continue;
            action.addToMenu(menu);
        }
    }

    @Override
    protected void updateEnableStatus(Selection selection) {
        boolean enabled = false;
        for (BaseAction action : this.getActions()) {
            if (action == BaseAction.SEPARATOR) continue;
            enabled = enabled || action.isEnabled();
        }
        this.setEnabled(enabled);
    }

    private static ActionGroup create(Adaptable context, Class cl, Set<Class> processedClasses) {
        Collection<ActionGroupFactory> actionFactories;
        Class<?>[] ifaces;
        if (factories == null) {
            factories = ActionGroup.loadFactories();
        }
        processedClasses.add(cl);
        ActionGroup result = new ActionGroup();
        Class superClass = cl.getSuperclass();
        if (superClass != null) {
            ActionGroup group = ActionGroup.create(context, superClass, processedClasses);
            result.addAll(group.getActions());
        }
        if ((ifaces = cl.getInterfaces()) != null) {
            for (Class<?> iface : ifaces) {
                if (!processedClasses.add(iface)) continue;
                ActionGroup group = ActionGroup.create(context, iface, processedClasses);
                result.addAll(group.getActions());
            }
        }
        if ((actionFactories = factories.get(cl)) != null) {
            for (ActionGroupFactory factory : actionFactories) {
                ActionGroup group = factory.create(context);
                result.addAll(group.getActions());
            }
        }
        return result;
    }

    private static Map<Class, Collection<ActionGroupFactory>> loadFactories() {
        ExtensionService service = Platform.getExtensionService();
        HashMap<Class, Collection<ActionGroupFactory>> map = new HashMap<Class, Collection<ActionGroupFactory>>();
        List<Extension<ActionGroupMetadata>> all = service.getExtensionsByPoint(ActionGroupMetadata.class);
        for (Extension<ActionGroupMetadata> extension : all) {
            try {
                Class target = extension.getMetadata().target();
                ActionGroupFactory factory = extension.instantiateAs(ActionGroupFactory.class);
                if (map.containsKey(target)) {
                    ((Collection)map.get(target)).add(factory);
                    continue;
                }
                HashSet<ActionGroupFactory> objectFactories = new HashSet<ActionGroupFactory>();
                objectFactories.add(factory);
                map.put(target, objectFactories);
            }
            catch (InstantiationException e) {
                e.printStackTrace();
            }
        }
        return map;
    }

    private boolean isValid(BaseAction action) {
        return action == null || this.actionValidatorComposite == null || this.actionValidatorComposite.isValid(action);
    }

    static {
        EMPTY = new BaseAction[0];
    }
}

