/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.ui;

import java.awt.Component;
import oracle.bpm.ui.DisposePolicy;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.event.Listener;
import oracle.bpm.ui.event.WindowListener;
import oracle.bpm.ui.peer.Peer;
import oracle.bpm.ui.peer.WindowPeer;

public abstract class UiWindow
extends UiContainer {
    protected UiWindow(UiWindow parent) {
        super(parent);
    }

    protected UiWindow(Peer peer) {
        super(peer);
    }

    public static UiWindow getFrom(UiComponent component) {
        return component.getOwnerWindow();
    }

    public static UiWindow getFrom(Component component) {
        UiComponent uiComponent = UiWindow.get(component);
        return UiWindow.getFrom(uiComponent);
    }

    public static UiWindow getRootFrom(UiComponent component) {
        UiComponent root = component;
        while (component != null) {
            root = component;
            component = component.getParent();
        }
        return root instanceof UiWindow ? (UiWindow)root : null;
    }

    public static UiWindow getRootFrom(Component component) {
        UiWindow root = null;
        UiWindow window = UiWindow.getFrom(component);
        while (window != null) {
            root = window;
            window = UiWindow.getFrom(window.getParent());
        }
        return root;
    }

    public UiContainer getContentPane() {
        return this.getWindowPeer().getContentPane();
    }

    public void showContextualHelp() {
        String helpId = this.getFocusOwner().getHelpId();
        this.showHelp(helpId);
    }

    public String getTitle() {
        return this.getWindowPeer().getTitle();
    }

    public void setTitle(String title) {
        this.getWindowPeer().setTitle(title == null ? "" : title);
    }

    public UiComponent getFocusOwner() {
        return this.getWindowPeer().getFocusOwner();
    }

    public final void setLocationRelativeTo(UiComponent component) {
        this.getWindowPeer().setLocationRelativeTo(component);
    }

    public UiWindow[] getOwnedWindows() {
        return this.getWindowPeer().getOwnerWindows();
    }

    public UiWindow getOwner() {
        return this.getWindowPeer().getOwner();
    }

    public void addWindowListener(WindowListener listener) {
        this.getWindowPeer().addWindowListener(listener);
    }

    public void addListener(int type, Listener listener) {
        this.getWindowPeer().addListener(type, listener);
    }

    public final void centerOnScreen() {
        this.setLocationRelativeTo(this.getParent());
    }

    @Override
    public void dispose() {
        this.getWindowPeer().dispose();
    }

    public void pack() {
        this.getWindowPeer().pack();
        this.centerOnScreen();
    }

    public final void toFront() {
        this.getWindowPeer().toFront();
    }

    public String getDefaultWindowHelpId() {
        return UiWindow.getHelpIdFromObjectClass(this);
    }

    @Override
    public String getHelpId() {
        String result = this.getDefaultWindowHelpId();
        if (!this.isValidHelpId(result)) {
            UiContainer parent = this.getParent();
            return parent != null ? parent.getHelpId() : null;
        }
        return result;
    }

    @Override
    protected DisposePolicy getDisposePolicy() {
        return DisposePolicy.ON_HIDE;
    }

    protected WindowPeer getWindowPeer() {
        assert (this.getPeer() instanceof WindowPeer) : this.getPeer().getClass();
        return (WindowPeer)this.getPeer();
    }
}

