/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.ui;

import java.awt.Component;
import java.awt.Point;
import java.awt.Window;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.List;
import javax.swing.SwingUtilities;
import oracle.bpm.draw.FontMetrics;
import oracle.bpm.draw.Graphics;
import oracle.bpm.geom.Rectangle;
import oracle.bpm.ui.LabelMultiline;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.RadioButton;
import oracle.bpm.ui.Ui;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.UiWindow;
import oracle.bpm.ui.event.Editable;
import oracle.bpm.ui.event.EditableContainer;
import oracle.bpm.ui.event.MouseEvent;
import oracle.bpm.ui.layout.AttributeConstraint;
import oracle.bpm.ui.layout.AttributeType;
import oracle.bpm.ui.layout.RelativeLayout;
import oracle.bpm.ui.peer.swing.AwtConverter;
import oracle.bpm.ui.text.TextComponent;

public class UiUtilities {
    private static final String COMPONENT_ID = "MyComponent";
    private static final String TEXT_AREA_PANEL_ID = "textArea";

    public static void assertUiThread() {
        assert (UiUtilities.isEventDispatchThread()) : "Must be called from event dispatcher thread, not from " + Thread.currentThread();
    }

    public static UiComponent getDeepestComponentAt(UiComponent parent, int x, int y) {
        return UiComponent.get(SwingUtilities.getDeepestComponentAt(parent.asSwing(), x, y));
    }

    public static void focusAndSelect(TextComponent text) {
        text.requestFocus();
        text.selectAll();
    }

    public static boolean isEventDispatchThread() {
        return Ui.getToolkit().isEventDispatchThread();
    }

    public static boolean isLeftMouseButton(MouseEvent event) {
        return event.isLeftMouseButton();
    }

    public static boolean isMiddleMouseButton(MouseEvent event) {
        return event.isMiddleMouseButton();
    }

    public static boolean isRightMouseButton(MouseEvent event) {
        return event.isRightMouseButton();
    }

    public static UiWindow getWindowAncestor(UiComponent component) {
        if (component == null) {
            return null;
        }
        return component.getOwnerWindow();
    }

    public static int computeStringWidth(FontMetrics fontMetrics, String str) {
        return fontMetrics.stringWidth(str);
    }

    public static oracle.bpm.geom.Point convertPoint(UiComponent source, oracle.bpm.geom.Point point, UiComponent destination) {
        return AwtConverter.fromAwt(SwingUtilities.convertPoint((Component)source.getNative(), AwtConverter.toAwt(point), (Component)destination.getNative()));
    }

    public static void drawDashedRect(Graphics g, int x, int y, int width, int height) {
        for (int vx = x; vx < x + width; vx += 2) {
            g.fillRect(vx, y, 1, 1);
            g.fillRect(vx, y + height - 1, 1, 1);
        }
        for (int vy = y; vy < y + height; vy += 2) {
            g.fillRect(x, vy, 1, 1);
            g.fillRect(x + width - 1, vy, 1, 1);
        }
    }

    public static oracle.bpm.geom.Point convertPointToScreen(oracle.bpm.geom.Point point, UiComponent component) {
        Point p = AwtConverter.toAwt(point);
        SwingUtilities.convertPointToScreen(p, component.asSwing());
        return new oracle.bpm.geom.Point(p.x, p.y);
    }

    public static void invokeAndWait(Runnable runnable) {
        Ui.getToolkit().invokeAndWait(runnable);
    }

    public static void invokeLater(Runnable runnable) {
        UiUtilities.invokeLater(runnable, false);
    }

    public static void invokeLater(Runnable runnable, boolean force) {
        Ui.getToolkit().invokeLater(runnable, force);
    }

    public static void paintComponent(Graphics g, UiComponent c, UiComponent p, Rectangle bounds) {
        Ui.getToolkit().paintComponent(g, c, p, bounds);
    }

    public static void updateComponentTreeUI(UiComponent component) {
        SwingUtilities.updateComponentTreeUI(component.asSwing());
    }

    public static UiWindow windowForComponent(UiComponent component) {
        Window window = SwingUtilities.windowForComponent(component.asSwing());
        return UiWindow.getFrom(window);
    }

    public static void layoutRadioButtonPanel(UiContainer parent, LabelMultiline textArea, RadioButton[] radioButton, boolean horizontalAlignement) {
        RelativeLayout layout = new RelativeLayout();
        parent.setLayout(layout);
        for (int i = 0; i < radioButton.length; ++i) {
            parent.add(radioButton[i], "radioButton" + i);
        }
        String upperComponent = "_container";
        AttributeType upperAttribute = AttributeType.TOP;
        if (textArea != null) {
            parent.add(textArea, TEXT_AREA_PANEL_ID);
            layout.addConstraint(TEXT_AREA_PANEL_ID, AttributeType.TOP, new AttributeConstraint(upperComponent, upperAttribute));
            layout.addConstraint(TEXT_AREA_PANEL_ID, AttributeType.LEFT, new AttributeConstraint("_container", AttributeType.LEFT, 5));
            layout.addConstraint(TEXT_AREA_PANEL_ID, AttributeType.RIGHT, new AttributeConstraint("_container", AttributeType.RIGHT, -5));
            upperComponent = TEXT_AREA_PANEL_ID;
            upperAttribute = AttributeType.BOTTOM;
        }
        for (int i = 0; i < radioButton.length; ++i) {
            if (i == 0) {
                layout.addConstraint("radioButton" + i, AttributeType.TOP, new AttributeConstraint(upperComponent, upperAttribute, 2));
                layout.addConstraint("radioButton" + i, AttributeType.LEFT, new AttributeConstraint(upperComponent, AttributeType.LEFT));
                if (horizontalAlignement) continue;
                layout.addConstraint("radioButton" + i, AttributeType.RIGHT, new AttributeConstraint(upperComponent, AttributeType.RIGHT));
                continue;
            }
            if (horizontalAlignement) {
                layout.addConstraint("radioButton" + i, AttributeType.TOP, new AttributeConstraint(upperComponent, upperAttribute, 2));
                layout.addConstraint("radioButton" + i, AttributeType.LEFT, new AttributeConstraint("radioButton" + (i - 1), AttributeType.RIGHT));
                if (i != radioButton.length - 1) continue;
                layout.addConstraint("radioButton" + i, AttributeType.RIGHT, new AttributeConstraint(upperComponent, AttributeType.RIGHT));
                continue;
            }
            layout.addConstraint("radioButton" + i, AttributeType.TOP, new AttributeConstraint("radioButton" + (i - 1), AttributeType.BOTTOM, 2));
            layout.addConstraint("radioButton" + i, AttributeType.LEFT, new AttributeConstraint("radioButton" + (i - 1), AttributeType.LEFT));
            layout.addConstraint("radioButton" + i, AttributeType.RIGHT, new AttributeConstraint("radioButton" + (i - 1), AttributeType.RIGHT));
        }
    }

    public static void layoutCheckBoxPanel(Panel panel, UiComponent textArea, UiComponent checkBox) {
        RelativeLayout layout = new RelativeLayout();
        panel.setLayout(layout);
        String upperComponent = "_container";
        AttributeType upBorder = AttributeType.TOP;
        if (textArea != null) {
            String textAreaString = TEXT_AREA_PANEL_ID;
            upperComponent = TEXT_AREA_PANEL_ID;
            panel.add(textArea, upperComponent);
            layout.addConstraint(TEXT_AREA_PANEL_ID, AttributeType.TOP, new AttributeConstraint("_container", AttributeType.TOP));
            layout.addConstraint(TEXT_AREA_PANEL_ID, AttributeType.LEFT, new AttributeConstraint("_container", AttributeType.LEFT, 5));
            layout.addConstraint(TEXT_AREA_PANEL_ID, AttributeType.RIGHT, new AttributeConstraint("_container", AttributeType.RIGHT, -5));
            upBorder = AttributeType.BOTTOM;
        }
        panel.add(checkBox, COMPONENT_ID);
        layout.addConstraint(COMPONENT_ID, AttributeType.TOP, new AttributeConstraint(upperComponent, upBorder, 5));
        layout.addConstraint(COMPONENT_ID, AttributeType.LEFT, new AttributeConstraint(upperComponent, AttributeType.LEFT));
        layout.addConstraint(COMPONENT_ID, AttributeType.RIGHT, new AttributeConstraint(upperComponent, AttributeType.RIGHT));
    }

    public static void layoutComponentButtonPanel(UiContainer parent, UiComponent label, UiComponent component, UiComponent button) {
        RelativeLayout layout = new RelativeLayout();
        parent.setLayout(layout);
        parent.add(label, "label");
        parent.add(component, COMPONENT_ID);
        parent.add(button, "button");
        layout.addConstraint("label", AttributeType.TOP, new AttributeConstraint("_container", AttributeType.TOP));
        layout.addConstraint("label", AttributeType.LEFT, new AttributeConstraint("_container", AttributeType.LEFT, 5));
        layout.addConstraint("label", AttributeType.VERTICAL_CENTER, new AttributeConstraint(COMPONENT_ID, AttributeType.VERTICAL_CENTER));
        layout.addConstraint(COMPONENT_ID, AttributeType.TOP, new AttributeConstraint("_container", AttributeType.TOP));
        layout.addConstraint(COMPONENT_ID, AttributeType.LEFT, new AttributeConstraint("label", AttributeType.RIGHT, 5));
        layout.addConstraint(COMPONENT_ID, AttributeType.RIGHT, new AttributeConstraint("button", AttributeType.LEFT, -2));
        layout.addConstraint("button", AttributeType.TOP, new AttributeConstraint("_container", AttributeType.TOP));
        layout.addConstraint("button", AttributeType.RIGHT, new AttributeConstraint("_container", AttributeType.RIGHT, -5));
    }

    public static void layoutComponentPanel(UiContainer parent, UiComponent description, UiComponent component) {
        RelativeLayout layout = new RelativeLayout();
        parent.setLayout(layout);
        parent.add(component, COMPONENT_ID);
        parent.add(description, TEXT_AREA_PANEL_ID);
        layout.addConstraint(TEXT_AREA_PANEL_ID, AttributeType.TOP, new AttributeConstraint("_container", AttributeType.TOP));
        layout.addConstraint(TEXT_AREA_PANEL_ID, AttributeType.LEFT, new AttributeConstraint("_container", AttributeType.LEFT, 5));
        layout.addConstraint(TEXT_AREA_PANEL_ID, AttributeType.RIGHT, new AttributeConstraint("_container", AttributeType.RIGHT, -5));
        layout.addConstraint(COMPONENT_ID, AttributeType.TOP, new AttributeConstraint(TEXT_AREA_PANEL_ID, AttributeType.BOTTOM, 2));
        layout.addConstraint(COMPONENT_ID, AttributeType.LEFT, new AttributeConstraint(TEXT_AREA_PANEL_ID, AttributeType.LEFT));
        layout.addConstraint(COMPONENT_ID, AttributeType.RIGHT, new AttributeConstraint(TEXT_AREA_PANEL_ID, AttributeType.RIGHT));
    }

    public static void layoutComponentPanel(UiContainer parent, LabelMultiline textArea, UiComponent field) {
        RelativeLayout layout = new RelativeLayout();
        parent.setLayout(layout);
        AttributeType upperAttribute = AttributeType.TOP;
        parent.add(field, COMPONENT_ID);
        String upperComponent = "_container";
        if (textArea != null) {
            parent.add(textArea, TEXT_AREA_PANEL_ID);
            layout.addConstraint(TEXT_AREA_PANEL_ID, AttributeType.TOP, new AttributeConstraint("_container", AttributeType.TOP));
            layout.addConstraint(TEXT_AREA_PANEL_ID, AttributeType.LEFT, new AttributeConstraint("_container", AttributeType.LEFT, 5));
            layout.addConstraint(TEXT_AREA_PANEL_ID, AttributeType.RIGHT, new AttributeConstraint("_container", AttributeType.RIGHT, -5));
            upperComponent = TEXT_AREA_PANEL_ID;
            upperAttribute = AttributeType.BOTTOM;
        }
        layout.addConstraint(COMPONENT_ID, AttributeType.TOP, new AttributeConstraint(upperComponent, upperAttribute, 5));
        layout.addConstraint(COMPONENT_ID, AttributeType.LEFT, new AttributeConstraint(upperComponent, AttributeType.LEFT, 2));
        layout.addConstraint(COMPONENT_ID, AttributeType.RIGHT, new AttributeConstraint("_container", AttributeType.RIGHT, -2));
    }

    public static boolean addToEditableContainer(Editable editable, UiContainer parent) {
        EditableContainer container = UiUtilities.findEditableContainerParent(parent);
        if (container != null) {
            container.addEditable(editable);
            return true;
        }
        return false;
    }

    public static void drawDashedRect(Graphics graphics, Rectangle rect) {
        UiUtilities.drawDashedRect(graphics, rect.getX(), rect.getY(), rect.getWidth(), rect.getHeight());
    }

    public static void setEnabled(List<UiComponent> children, boolean enable) {
        if (children != null) {
            for (UiComponent child : children) {
                child.setEnabled(enable);
                if (!(child instanceof UiContainer)) continue;
                UiUtilities.setEnabled(((UiContainer)child).getChildren(), enable);
            }
        }
    }

    static void doPrivileged(final Runnable doRun) {
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                doRun.run();
                return null;
            }
        });
    }

    private static EditableContainer findEditableContainerParent(UiContainer parent) {
        EditableContainer result = parent == null ? null : (parent instanceof EditableContainer ? (EditableContainer)((Object)parent) : UiUtilities.findEditableContainerParent(parent.getParent()));
        return result;
    }
}

