/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.ui;

import oracle.bpm.geom.Dimension;
import oracle.bpm.geom.Point;
import oracle.bpm.geom.Rectangle;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.ActionStyle;
import oracle.bpm.ui.Item;
import oracle.bpm.ui.ToolBar;
import oracle.bpm.ui.action.BaseAction;
import oracle.bpm.ui.peer.Peer;
import oracle.bpm.ui.peer.ToolBarItemPeer;
import oracle.bpm.ui.peer.ToolBarPeer;

public class ToolBarItem
extends Item {
    private ActionStyle actionStyle;

    public ToolBarItem(ToolBar toolBar, ActionStyle actionStyle) {
        super(toolBar);
        this.actionStyle = actionStyle;
    }

    public ActionStyle getActionStyle() {
        return this.actionStyle;
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.getToolBarItemPeer().setEnabled(enabled);
    }

    @Override
    public boolean isEnabled() {
        return this.getToolBarItemPeer().isEnabled();
    }

    public void setSelected(boolean selected) {
        if (selected) {
            this.getParent().deselectOtherButtons(this);
        }
        this.getToolBarItemPeer().setSelected(selected);
    }

    public boolean isSelected() {
        return this.getToolBarItemPeer().isSelected();
    }

    @Override
    public Point getLocation() {
        return this.getToolBarItemPeer().getLocation();
    }

    @Override
    public Dimension getSize() {
        return this.getToolBarItemPeer().getSize();
    }

    @Override
    public Rectangle getBounds() {
        Point location = this.getLocation();
        Dimension size = this.getSize();
        return new Rectangle(location.getX(), location.getY(), size.getWidth(), size.getHeight());
    }

    @Override
    public int getHeight() {
        return this.getSize().getHeight();
    }

    @Override
    public int getWidth() {
        return this.getSize().getWidth();
    }

    @Override
    public void setToolTipText(Msg text) {
        this.setToolTipText(text.getString());
    }

    @Override
    public void setToolTipText(String text) {
        this.getToolBarItemPeer().setToolTipText(text);
    }

    @Override
    public ToolBar getParent() {
        return (ToolBar)super.getParent();
    }

    @Override
    public String getToolTipText() {
        return this.getToolBarItemPeer().getToolTipText();
    }

    public void setAction(BaseAction action) {
        this.getToolBarItemPeer().setAction(action);
    }

    public void setDropDownAction(BaseAction action) {
        this.getToolBarItemPeer().setDropDownAction(action);
    }

    @Override
    protected Peer createPeer() {
        return this.getUiFactory().createToolBarItem((ToolBarPeer)this.getParentPeer(), this.getActionStyle());
    }

    private ToolBarItemPeer getToolBarItemPeer() {
        return (ToolBarItemPeer)this.getPeer();
    }
}

