/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.ui;

import java.util.ArrayList;
import java.util.List;
import oracle.bpm.geom.Dimension;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.ActionStyle;
import oracle.bpm.ui.Image;
import oracle.bpm.ui.ToolBarItem;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.Utilities;
import oracle.bpm.ui.action.BaseAction;
import oracle.bpm.ui.border.Border;
import oracle.bpm.ui.layout.Layout;
import oracle.bpm.ui.peer.Peer;
import oracle.bpm.ui.peer.ToolBarPeer;

public class ToolBar
extends UiContainer {
    private Alignment alignment;
    private Dimension defaultSize;
    private Orientation orientation;
    private Group radioGroup;
    private static int ICON_WIDTH = 22;
    static int ICON_HEIGHT = 22;
    public static int OPTIONS = 10;
    public static final Orientation VERTICAL = Orientation.VERTICAL;
    public static final Orientation HORIZONTAL = Orientation.HORIZONTAL;
    public static final Alignment RIGHT = Alignment.RIGHT;
    public static final Alignment LEFT = Alignment.LEFT;

    public ToolBar(UiContainer parent) {
        this(parent, Orientation.HORIZONTAL);
    }

    public ToolBar(UiContainer parent, Orientation orientation) {
        this(parent, orientation, Alignment.RIGHT);
    }

    public ToolBar(UiContainer parent, Orientation orientation, Alignment alignment) {
        super(parent);
        this.setOrientation(orientation);
        this.alignment = alignment;
    }

    public void setAllSizes(UiComponent comp) {
        this.setAllSizes(comp, this.getDefaultSize());
    }

    public Dimension getDefaultSize() {
        if (this.defaultSize == null) {
            this.defaultSize = Dimension.valueOf(22, 22);
        }
        return this.defaultSize;
    }

    public Orientation getOrientation() {
        return this.orientation;
    }

    public ToolBarItem add(BaseAction action) {
        return this.add(action, OPTIONS);
    }

    public ToolBarItem add(BaseAction action, int options) {
        ToolBarItem item = new ToolBarItem(this, ActionStyle.BUTTON);
        item.setAction(action);
        this.setAttributes(item, action, options);
        return item;
    }

    @Override
    public UiComponent add(UiComponent component) {
        this.getToolBarPeer().add(component);
        return component;
    }

    @Override
    public UiComponent add(UiComponent component, Object constraints) {
        return component;
    }

    public ToolBarItem addCompositeButton(BaseAction action, BaseAction dropDownAction) {
        ToolBarItem item = new ToolBarItem(this, ActionStyle.DROP_DOWN);
        item.setAction(action);
        item.setDropDownAction(dropDownAction);
        this.setAttributes(item, action, OPTIONS);
        return item;
    }

    public void addSeparator() {
        this.getToolBarPeer().addSeparator();
        this.radioGroup = new Group();
    }

    public ToolBarItem addToggleButton(BaseAction action) {
        ToolBarItem item = new ToolBarItem(this, ActionStyle.CHECK);
        item.setAction(action);
        this.setAttributes(item, action, OPTIONS);
        return item;
    }

    public ToolBarItem addRadioButton(BaseAction action) {
        ToolBarItem item = new ToolBarItem(this, ActionStyle.RADIO);
        if (this.radioGroup == null) {
            this.radioGroup = new Group();
        }
        this.radioGroup.add(item);
        item.setAction(action);
        this.setAttributes(item, action, OPTIONS);
        return item;
    }

    @Override
    public void translate() {
        Utilities.translateChildComponentTree(this);
    }

    @Override
    public void setBorder(Border border) {
    }

    @Override
    public void setLayout(Layout layout) {
    }

    @Override
    protected Peer createPeer() {
        return this.getUiFactory().createToolBar(this.getParentPeer(), this.getOrientation(), this.alignment);
    }

    protected void setAllSizes(UiComponent comp, Dimension size) {
        comp.setMinimumSize(size);
        comp.setPreferredSize(size);
        comp.setMaximumSize(size);
    }

    ToolBarPeer getToolBarPeer() {
        return (ToolBarPeer)this.getPeer();
    }

    void deselectOtherButtons(ToolBarItem button) {
        if (this.radioGroup != null) {
            this.radioGroup.deselectOtherButtons(button);
        }
    }

    private void setAttributes(ToolBarItem item, BaseAction action, int options) {
        Image image;
        if ((options & 2) != 0 && (image = action.getSmallIcon()) != null) {
            item.setIcon(image);
        }
        item.setEnabled(action.isEnabled());
        Msg msg = action.getMsg();
        if (msg != null) {
            boolean showText = (options & 1) != 0;
            String text = msg.getString();
            if (showText && text != null) {
                item.setText(text);
            }
            boolean showTooltip = (options & 8) != 0;
            String tooltip = msg.getDetail();
            if (showTooltip && (text != null || tooltip != null)) {
                String s = tooltip != null && tooltip.length() > 0 ? tooltip : text;
                item.setToolTipText(s);
            }
        }
    }

    private void setOrientation(Orientation orientation) {
        this.orientation = orientation;
    }

    private static class Group {
        List<ToolBarItem> buttons;

        private Group() {
        }

        void add(ToolBarItem button) {
            if (this.buttons == null) {
                this.buttons = new ArrayList<ToolBarItem>();
            }
            this.buttons.add(button);
        }

        void deselectOtherButtons(ToolBarItem button) {
            if (this.buttons != null) {
                for (ToolBarItem b : this.buttons) {
                    if (b.equals(button)) continue;
                    b.setSelected(false);
                }
            }
        }
    }

    public static enum Alignment {
        RIGHT,
        LEFT;

    }

    public static enum Orientation {
        VERTICAL,
        HORIZONTAL;

    }
}

