/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.ui;

import oracle.bpm.draw.Color;
import oracle.bpm.draw.Font;
import oracle.bpm.geom.Dimension;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.Image;
import oracle.bpm.ui.Label;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.UiManager;
import oracle.bpm.ui.Utilities;
import oracle.bpm.ui.layout.border.BorderLayout;
import oracle.bpm.ui.msg.UIMsg;

public class TitlePanel
extends Panel {
    private UiComponent content;
    private Msg title;
    private TopPanel topPanel;

    public TitlePanel(UiContainer parent) {
        this(parent, UIMsg.TO_MSG(""), null, null, null);
    }

    public TitlePanel(UiContainer parent, Msg title) {
        this(parent, title, null, null, null);
    }

    private TitlePanel(UiContainer parent, Msg title, Image icon, UiComponent content, UiComponent topRightContent) {
        super(parent);
        this.setLayout(new BorderLayout());
        if (topRightContent == null) {
            this.topPanel = new TopPanel((UiContainer)this, icon);
            this.add(this.topPanel, "North");
        } else {
            this.topPanel = new TopPanel((UiContainer)this, icon, topRightContent);
            this.add(this.topPanel, "North");
        }
        this.setTitle(title);
        this.addContent(content);
    }

    public UiComponent getContent() {
        return this.content;
    }

    public void setIcon(Image icon) {
        this.getTopPanel().setIcon(icon);
    }

    public void setTopPanel(UiComponent topRightContent, Image icon, String title) {
        this.topPanel.add(topRightContent, "North");
        this.add(this.topPanel, "North");
        this.setTitle(title);
    }

    @Override
    public Dimension getMaximumSize() {
        Dimension topSize = this.getTopPanel().getMaximumSize();
        if (!this.getContent().isVisible()) {
            return topSize;
        }
        Dimension conSize = this.getContent().getMaximumSize();
        Dimension newSize = Dimension.valueOf(Math.max(topSize.getWidth(), conSize.getWidth()), Math.max(topSize.getHeight(), conSize.getHeight()));
        return newSize;
    }

    @Override
    public Dimension getMinimumSize() {
        Dimension topSize = this.getTopPanel().getMinimumSize();
        UiComponent content = this.getContent();
        if (!content.isVisible()) {
            return topSize;
        }
        Dimension conSize = content.getMinimumSize();
        Dimension newSize = Dimension.valueOf(Math.min(topSize.getWidth(), conSize.getWidth()), Math.min(topSize.getHeight(), conSize.getHeight()));
        return newSize;
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension topSize = this.getTopPanel().getPreferredSize();
        UiComponent content = this.getContent();
        if (content == null || !content.isVisible()) {
            return topSize;
        }
        Dimension conSize = content.getPreferredSize();
        Dimension newSize = Dimension.valueOf(Math.max(topSize.getWidth(), conSize.getWidth()), Math.max(topSize.getHeight(), conSize.getHeight()));
        return newSize;
    }

    public void setTitle(Msg title) {
        this.title = title;
        this.update();
    }

    public void setTitle(String title) {
        if (title != null && this.topPanel != null) {
            this.getTopPanel().setTitle(title);
        }
    }

    @Override
    public Msg getTitleMsg() {
        return this.title;
    }

    public TopPanel getTopPanel() {
        return this.topPanel;
    }

    public void addContent(UiComponent content) {
        if (content != null) {
            this.add(content, "Center");
            this.setContent(content);
        }
    }

    @Override
    public void translate() {
        Utilities.translateChildComponentTree(this);
        this.update();
    }

    protected void setTopRightContent(UiComponent topRightContent) {
        this.getTopPanel().add(topRightContent, "East");
    }

    private void setContent(UiComponent content) {
        this.content = content;
    }

    private void update() {
        Msg msg = this.getTitleMsg();
        if (msg != null) {
            this.getTopPanel().setTitle(msg.getString());
        }
    }

    public static class TopPanel
    extends Panel {
        private UiComponent content;
        private Image icon;
        private Label title;

        public TopPanel(UiContainer parent, Image icon) {
            this(parent, "", icon, null);
        }

        public TopPanel(UiContainer parent, Image icon, UiComponent content) {
            this(parent, "", icon, content);
        }

        public TopPanel(UiContainer parent, String title, Image icon) {
            this(parent, title, icon, null);
        }

        public TopPanel(UiContainer parent, String title, Image icon, UiComponent content) {
            super(parent);
            this.setLayout(new BorderLayout());
            this.icon = icon;
            this.content = content;
            this.title = Label.createWithNoColon(this, Msg.QUOTE(title));
            this.title.setIcon(icon);
            this.title.setOpaque(false);
            this.setOpaque(true);
            this.add(this.title, "West");
            if (content != null) {
                this.add(content, "Center");
            }
        }

        public Color getColor() {
            return UiManager.color("controlShadow");
        }

        public UiComponent getContent() {
            return this.content;
        }

        public Image getIcon() {
            return this.icon;
        }

        public String getTitle() {
            return this.title.getText();
        }

        public void setTitleFont(Font font) {
            this.title.setFont(font);
            this.repaint();
        }

        @Override
        public void setBackground(Color color) {
            super.setBackground(color);
            this.title.setBackground(color);
        }

        private void setIcon(Image icon) {
            this.icon = icon;
            this.title.setIcon(icon);
            this.repaint();
        }

        private void setTitle(String title) {
            this.title.setText(title);
            this.repaint();
        }
    }
}

