/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.ui;

import oracle.bpm.draw.Color;
import oracle.bpm.draw.Graphics;
import oracle.bpm.geom.Dimension;
import oracle.bpm.ui.Dialog;
import oracle.bpm.ui.PaintCanvas;
import oracle.bpm.ui.Ui;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.UiType;
import oracle.bpm.ui.UiUtilities;
import oracle.bpm.ui.UiWindow;
import oracle.bpm.ui.event.KeyEvent;
import oracle.bpm.ui.event.KeyListener;
import oracle.bpm.ui.event.MouseEvent;
import oracle.bpm.ui.event.MouseListener;

public class TWidget
extends PaintCanvas
implements KeyListener {
    private byte[][] bgBlocks;
    private int[] bgCollider;
    private int blinkCount;
    private final Runnable blinkEvt = new BlinkRunnable();
    private final Runnable downEvt = new DownRunnable();
    private boolean dropping;
    private boolean gameOver;
    private int level;
    private int lines;
    private int nextShape;
    private boolean paused;
    private double[] probability;
    private int rotation = 0;
    private int score;
    private int shape = 0;
    private Timer timer;
    private int x;
    private int y;
    private static final int K32 = 32768;
    private static final int BG_HEIGHT = 20;
    private static final int BG_WIDTH = 10;
    private static final int BG_COLOR_MASK = 240;
    private static final int BG_BORDER_MASK = 15;
    private static final int BG_COLOR_SHIFT = 4;
    private static final int BLINK_COUNT = 3;
    private static final int BLINK_PERIOD = 150;
    private static final int DROP_PERIOD = 25;
    private static final int[] WEIGHTS = new int[]{5, 15, 20, 20, 15, 15, 10};
    private static final int[] POINTS = new int[]{0, 100, 200, 500, 1000};
    private static final int[] LEVELS = new int[]{10, 25, 40, 60, 80, 110, 140, 180, 220, 270, 320, 370};
    private static final int[] LEVEL_SPEED = new int[]{900, 800, 700, 600, 500, 400, 300, 200, 150, 100, 75, 50};
    private static final S[][] SHAPES = new S[][]{{new S(1, 1, 1, 1, 0, 1), new S(15, 0, 0, 0, 0, -1)}, {new S(1, 3, 1, 0, 1), new S(2, 7, 0, 0, 1), new S(2, 3, 2, 0, 1), new S(7, 2, 0, 0, 1)}, {new S(1, 3, 2, 0, 2), new S(6, 3, 0, 0, 2)}, {new S(2, 3, 1, 0, 3), new S(3, 6, 0, 0, 3)}, {new S(3, 1, 1, 0, 4), new S(1, 7, 0, 0, 4), new S(2, 2, 3, 0, 4), new S(7, 4, 0, 0, 4)}, {new S(3, 2, 2, 0, 5), new S(7, 1, 0, 0, 5), new S(1, 1, 3, 0, 5), new S(4, 7, 0, 0, 5)}, {new S(3, 3, 0, 0, 6)}};
    private static final Color[][] COLORSET = new Color[][]{{Color.RED, Color.RED.darker(), Color.RED.darker().darker()}, {Color.CYAN, Color.CYAN.darker(), Color.CYAN.darker().darker()}, {Color.GREEN, Color.GREEN.darker(), Color.GREEN.darker().darker()}, {Color.YELLOW, Color.YELLOW.darker(), Color.YELLOW.darker().darker()}, {Color.PINK, Color.PINK.darker(), Color.PINK.darker().darker()}, {Color.ORANGE, Color.ORANGE.darker(), Color.ORANGE.darker().darker()}, {Color.BLUE, Color.BLUE.darker(), Color.BLUE.darker().darker()}};
    private static final int TOP = 1;
    private static final int LEFT = 2;
    private static final int RIGHT = 4;
    private static final int BOTTOM = 8;

    public TWidget(UiContainer parent) {
        super(parent);
        this.setFocusable(true);
        this.initBackground();
        this.initProbabilities();
        this.initListeners();
        this.initTimers();
        this.chooseNextShape();
        this.chooseNextShape();
        this.onPause();
    }

    public static void main(String[] args) throws Throwable {
        Ui.initialize(UiType.SWT);
        Dialog d = new Dialog((UiWindow)null);
        TWidget grid = new TWidget(d.getContentPane());
        grid.setVisible(true);
        d.getContentPane().add(grid);
        d.pack();
        d.setSize(800, 600);
        d.centerOnScreen();
        d.setVisible(true);
    }

    @Override
    public void dispose() {
        super.dispose();
        this.timer.dispose();
    }

    @Override
    public void keyPressed(KeyEvent e) {
        if (this.paused) {
            this.unPause();
        }
        switch (e.getKeyCode()) {
            case 38: {
                this.onRotate();
                break;
            }
            case 40: {
                this.onDown();
                break;
            }
            case 37: {
                this.onLeft();
                break;
            }
            case 39: {
                this.onRight();
                break;
            }
            case 32: {
                this.onDrop();
                break;
            }
            case 107: 
            case 521: {
                if (this.level + 1 >= LEVELS.length) break;
                ++this.level;
                this.timer.setDownPeriod(LEVEL_SPEED[this.level]);
                this.repaint();
                break;
            }
            case 45: 
            case 109: {
                if (this.level - 1 <= 0) break;
                --this.level;
                this.timer.setDownPeriod(LEVEL_SPEED[this.level]);
                this.repaint();
                break;
            }
            case 80: {
                this.onPause();
                break;
            }
            case 113: {
                this.restart();
                break;
            }
            default: {
                char c = e.getKeyChar();
                if (c == 'p' || c == 'P') {
                    this.onPause();
                    break;
                }
                if (c == 'n' || c == 'N') {
                    this.restart();
                    break;
                }
                if (c != '+' || this.level + 1 >= LEVELS.length) break;
                ++this.level;
                this.timer.setDownPeriod(LEVEL_SPEED[this.level]);
                this.repaint();
            }
        }
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void paintCanvas(Graphics graphics) {
        this.render(graphics);
    }

    @Override
    public Dimension getPreferredSize() {
        return this.getVisibleRect().getSize();
    }

    boolean canDrawAt(S s, int x, int y) {
        if (x < 0 || x >= 10) {
            return false;
        }
        if (y < 0 || y >= 20) {
            return false;
        }
        if (s.a != 0 && (this.bgCollider[y] & s.a << x) != 0) {
            return false;
        }
        if (s.b != 0 && (y + 1 >= 20 || (this.bgCollider[y + 1] & s.b << x) != 0)) {
            return false;
        }
        if (s.c != 0 && (y + 2 >= 20 || (this.bgCollider[y + 2] & s.c << x) != 0)) {
            return false;
        }
        if (s.d != 0 && (y + 3 >= 20 || (this.bgCollider[y + 3] & s.d << x) != 0)) {
            return false;
        }
        if (x > 6) {
            int room = 10 - x;
            return TWidget.bitLen(s.a) <= room && TWidget.bitLen(s.b) <= room && TWidget.bitLen(s.c) <= room && TWidget.bitLen(s.d) <= room;
        }
        return true;
    }

    void draw(Graphics g, S s, int x, int y) {
        if (s.a != 0) {
            this.drawElement(g, s.color, x, y, s.a, 0, s.b);
        }
        if (s.b != 0) {
            this.drawElement(g, s.color, x, y + this.getBlockSize(), s.b, s.a, s.c);
        }
        if (s.c != 0) {
            this.drawElement(g, s.color, x, y + 2 * this.getBlockSize(), s.c, s.b, s.d);
        }
        if (s.d != 0) {
            this.drawElement(g, s.color, x, y + 3 * this.getBlockSize(), s.d, s.c, 0);
        }
    }

    private static int bitLen(int n) {
        if (n < 32768) {
            if (n < 128) {
                return n < 8 ? (n < 2 ? (n < 1 ? (n < 0 ? 32 : 0) : 1) : (n < 4 ? 2 : 3)) : (n < 32 ? (n < 16 ? 4 : 5) : (n < 64 ? 6 : 7));
            }
            return n < 2048 ? (n < 512 ? (n < 256 ? 8 : 9) : (n < 1024 ? 10 : 11)) : (n < 8192 ? (n < 4096 ? 12 : 13) : (n < 16384 ? 14 : 15));
        }
        if (n < 0x800000) {
            return n < 524288 ? (n < 131072 ? (n < 65536 ? 16 : 17) : (n < 262144 ? 18 : 19)) : (n < 0x200000 ? (n < 0x100000 ? 20 : 21) : (n < 0x400000 ? 22 : 23));
        }
        return n < 0x8000000 ? (n < 0x2000000 ? (n < 0x1000000 ? 24 : 25) : (n < 0x4000000 ? 26 : 27)) : (n < 0x20000000 ? (n < 0x10000000 ? 28 : 29) : (n < 0x40000000 ? 30 : 31));
    }

    private void drawBlock(Graphics g, int color, int x, int y, int bevelMask) {
        Color oldColor = g.getForeground();
        int index = color & 7;
        Color light = COLORSET[index][0];
        Color fill = COLORSET[index][1];
        Color shadow = COLORSET[index][2];
        if ((color & 8) == 0) {
            g.setForeground(fill);
        } else {
            g.setForeground(light);
        }
        g.fillRect(x, y, this.getBlockSize(), this.getBlockSize());
        g.setForeground(light);
        int shift = this.getBlockSize() - 1;
        if ((bevelMask & 1) != 0) {
            g.drawLine(x, y, x + shift, y);
        }
        if ((bevelMask & 2) != 0) {
            g.drawLine(x, y, x, y + shift);
        }
        g.setForeground(shadow);
        if ((bevelMask & 4) != 0) {
            g.drawLine(x + shift, y, x + shift, y + shift);
        }
        if ((bevelMask & 8) != 0) {
            g.drawLine(x, y + shift, x + shift, y + shift);
        }
        g.setForeground(oldColor);
    }

    private boolean analyzeRemovals(boolean highLight) {
        boolean removed = false;
        int mask = 1023;
        for (int i = 0; i < this.bgCollider.length; ++i) {
            int line = this.bgCollider[i];
            if ((line & mask) != mask) continue;
            removed = true;
            this.highlightLine(i, highLight);
        }
        return removed;
    }

    private void checkDrop() {
        if (this.dropping) {
            this.dropping = false;
            this.timer.setDownPeriod(LEVEL_SPEED[this.level]);
        }
    }

    private void checkLevel() {
        if (LEVELS[this.level] < this.lines && this.level + 1 < LEVELS.length) {
            ++this.level;
            this.timer.setDownPeriod(LEVEL_SPEED[this.level]);
        }
    }

    private void chooseNextShape() {
        double random = Math.random();
        int s = 0;
        for (int i = 0; i < this.probability.length; ++i) {
            double v = this.probability[i];
            if (!(random < v)) continue;
            s = i;
            break;
        }
        this.shape = this.nextShape;
        this.nextShape = s;
        this.rotation = 0;
        this.x = 5;
        this.y = 0;
    }

    private void chooseRotation() {
        S[] rotations = SHAPES[this.shape];
        int index = (int)Math.round(Math.random() * (double)(rotations.length - 1));
        boolean found = false;
        int off = 0;
        if (this.canDrawAt(rotations[index], this.x + rotations[index].offset, this.y)) {
            found = true;
            this.rotation = index;
            off = rotations[index].offset;
        }
        for (int i = 0; !found && i < rotations.length; ++i) {
            if (!this.canDrawAt(rotations[i], this.x + (off += rotations[i].offset), this.y)) continue;
            found = true;
            this.rotation = i;
        }
        if (!found) {
            this.onGameOver();
        } else {
            this.x += off;
        }
    }

    private void clearLine(int index) {
        int i;
        byte[] removed = this.bgBlocks[index];
        for (i = index; i > 0; --i) {
            this.bgBlocks[i] = this.bgBlocks[i - 1];
            this.bgCollider[i] = this.bgCollider[i - 1];
        }
        this.bgBlocks[0] = removed;
        this.bgCollider[0] = 0;
        for (i = 0; i < removed.length; ++i) {
            removed[i] = 0;
        }
    }

    private void drawBackground(Graphics g, int x, int y) {
        int color = 0;
        Color oldColor = g.getForeground();
        Color light = COLORSET[color][0];
        Color fill = COLORSET[color][1];
        Color shadow = COLORSET[color][2];
        g.setForeground(fill);
        int width = 10 * this.getBlockSize() + 2;
        int height = 20 * this.getBlockSize() + 2;
        int border = this.getBlockSize() >> 1;
        g.fillRect(x, y, width + 2 * border, height + 2 * border);
        g.setForeground(Color.BLACK);
        g.fillRect(x + border, y + border, width, height);
        g.setForeground(light);
        g.drawLine(x, y, x + width + 2 * border - 1, y);
        g.drawLine(x, y, x, y + height + 2 * border - 1);
        g.drawLine(x + width + border - 1, y + border, x + width + border - 1, y + height + border - 1);
        g.drawLine(x + border, y + height + border - 1, x + width + border - 1, y + height + border - 1);
        g.setForeground(shadow);
        g.drawLine(x + width + 2 * border - 1, y, x + width + 2 * border - 1, y + height + 2 * border - 1);
        g.drawLine(x, y + height + 2 * border - 1, x + width + 2 * border - 1, y + height + 2 * border - 1);
        g.drawLine(x + border, y + border, x + width + border - 1, y + border);
        g.drawLine(x + border, y + border, x + border, y + height + border - 1);
        this.drawBoard(g, x + border + 1, y + border + 1);
        int nx = x + width + 2 * border + this.getBlockSize();
        int ny = y + height - 4 * this.getBlockSize();
        this.draw(g, SHAPES[this.nextShape][0], nx + border, ny + border);
        g.setForeground(fill);
        g.drawRect(nx, ny, 3 * this.getBlockSize() + 2 * border, 4 * this.getBlockSize() + 2 * border);
        g.setForeground(Color.WHITE);
        g.drawString("Next:", nx, ny - border);
        g.drawString("Score: " + this.score, nx, y + 2 * this.getBlockSize());
        g.drawString("Lines: " + this.lines, nx, y + 4 * this.getBlockSize());
        g.drawString("Level: " + this.level, nx, y + 6 * this.getBlockSize());
        g.setForeground(oldColor);
    }

    private void drawBoard(Graphics g, int x, int y) {
        for (int i = 0; i < 20; ++i) {
            byte[] bgBlock = this.bgBlocks[i];
            for (int j = 0; j < 10; ++j) {
                int b = 0xFF & bgBlock[j];
                if ((this.bgCollider[i] & 1 << j) == 0) continue;
                this.drawBlock(g, (b & 0xF0) >>> 4, x + this.getBlockSize() * j, y + this.getBlockSize() * i, b & 0xF);
            }
        }
    }

    private void drawCurrentShape(Graphics g, int bgx, int bgy) {
        int sx = bgx + (this.getBlockSize() >> 1) + this.x * this.getBlockSize() + 1;
        int sy = bgy + (this.getBlockSize() >> 1) + this.y * this.getBlockSize() + 1;
        this.draw(g, SHAPES[this.shape][this.rotation], sx, sy);
    }

    private void drawElement(Graphics g, int color, int x, int y, int e, int before, int after) {
        int mask;
        int zero = 0;
        for (mask = 1; (mask & e) == 0 && mask != 0; mask <<= 1) {
            ++zero;
        }
        int one = 0;
        int off = zero * this.getBlockSize();
        while ((mask & e) != 0 && mask != 0) {
            int bevel = 0;
            if (one == 0) {
                bevel |= 2;
            }
            if ((mask & before) == 0) {
                bevel |= 1;
            }
            if ((mask & after) == 0) {
                bevel |= 8;
            }
            if ((e & mask << 1) == 0 || mask << 1 == 0) {
                bevel |= 4;
            }
            this.drawBlock(g, color, off + x + this.getBlockSize() * one, y, bevel);
            ++one;
            mask <<= 1;
        }
    }

    private void highlightLine(int i, boolean highLight) {
        byte[] line = this.bgBlocks[i];
        for (int j = 0; j < line.length; ++j) {
            byte b = line[j];
            line[j] = highLight ? (byte)(b & 0xFF | 0x80) : (byte)(b & 0x7F);
        }
    }

    private void initBackground() {
        this.blinkCount = 3;
        this.bgCollider = new int[20];
        this.bgBlocks = new byte[20][];
        for (int i = 0; i < this.bgBlocks.length; ++i) {
            this.bgBlocks[i] = new byte[10];
        }
    }

    private void initListeners() {
        this.addKeyListener(this);
        this.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (TWidget.this.paused) {
                    TWidget.this.unPause();
                }
                TWidget.this.requestFocus();
            }

            @Override
            public void mouseDoubleClicked(MouseEvent e) {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }

            @Override
            public void mousePressed(MouseEvent e) {
            }

            @Override
            public void mouseReleased(MouseEvent e) {
            }
        });
    }

    private void initProbabilities() {
        int i;
        this.probability = new double[WEIGHTS.length];
        for (i = 0; i < this.probability.length; ++i) {
            this.probability[i] = WEIGHTS[i];
            if (i == 0) continue;
            int n = i;
            this.probability[n] = this.probability[n] + this.probability[i - 1];
        }
        for (i = 0; i < this.probability.length; ++i) {
            this.probability[i] = this.probability[i] / this.probability[this.probability.length - 1];
        }
    }

    private void initTimers() {
        this.timer = new Timer();
        Thread t = new Thread(this.timer);
        t.setDaemon(true);
        t.start();
        this.timer.setDownPeriod(LEVEL_SPEED[this.level]);
    }

    private void onBlink() {
        --this.blinkCount;
        if (this.blinkCount <= 0) {
            this.blinkCount = 3;
            this.removeFull();
        } else {
            this.analyzeRemovals((this.blinkCount & 1) != 0);
            this.timer.setNextBlink(150L);
        }
        this.repaint();
    }

    private void onDown() {
        if (this.gameOver) {
            return;
        }
        if (this.canDrawAt(SHAPES[this.shape][this.rotation], this.x, this.y + 1)) {
            ++this.y;
            this.repaint();
        } else if (this.blinkCount == 3) {
            this.checkDrop();
            this.pinShape(SHAPES[this.shape][this.rotation], this.x, this.y);
            this.score += 5;
            if (this.analyzeRemovals(true)) {
                this.timer.setNextBlink(150L);
            }
            this.chooseNextShape();
            this.chooseRotation();
            this.repaint();
        } else {
            this.checkDrop();
            this.blinkCount = 0;
            this.onBlink();
            this.onDown();
        }
    }

    private void onDrop() {
        if (!this.dropping) {
            this.dropping = true;
            this.timer.setDownPeriod(25L);
        }
    }

    private void onGameOver() {
        this.timer.setDownPeriod(0L);
        this.gameOver = true;
    }

    private void onLeft() {
        if (!this.gameOver && !this.dropping && this.canDrawAt(SHAPES[this.shape][this.rotation], this.x - 1, this.y)) {
            --this.x;
            this.repaint();
        }
    }

    private void onPause() {
        if (this.gameOver) {
            return;
        }
        this.paused = true;
        this.timer.setDownPeriod(0L);
        this.repaint();
    }

    private void onRight() {
        if (!this.gameOver && !this.dropping && this.canDrawAt(SHAPES[this.shape][this.rotation], this.x + 1, this.y)) {
            ++this.x;
            this.repaint();
        }
    }

    private void onRotate() {
        if (this.gameOver || this.dropping) {
            return;
        }
        int r = (this.rotation + 1) % SHAPES[this.shape].length;
        S shape = SHAPES[this.shape][r];
        if (this.canDrawAt(shape, this.x + shape.offset, this.y)) {
            this.x += shape.offset;
            this.rotation = r;
            this.repaint();
        }
    }

    private void pinElement(int cx, int cy, int color, int e, int before, int after) {
        int mask;
        int n = cy;
        this.bgCollider[n] = this.bgCollider[n] | e << cx;
        byte[] line = this.bgBlocks[cy];
        int zero = 0;
        for (mask = 1; (mask & e) == 0 && mask != 0; mask <<= 1) {
            ++zero;
        }
        int one = 0;
        while ((mask & e) != 0 && mask != 0) {
            int bevel = 0;
            if (one == 0) {
                bevel |= 2;
            }
            if ((mask & before) == 0) {
                bevel |= 1;
            }
            if ((mask & after) == 0) {
                bevel |= 8;
            }
            if ((e & mask << 1) == 0 || mask << 1 == 0) {
                bevel |= 4;
            }
            line[cx + zero + one] = (byte)(color << 4 | bevel);
            ++one;
            mask <<= 1;
        }
    }

    private void pinShape(S s, int cx, int cy) {
        if (s.a != 0) {
            this.pinElement(cx, cy, s.color, s.a, 0, s.b);
        }
        if (s.b != 0) {
            this.pinElement(cx, cy + 1, s.color, s.b, s.a, s.c);
        }
        if (s.c != 0) {
            this.pinElement(cx, cy + 2, s.color, s.c, s.b, s.d);
        }
        if (s.d != 0) {
            this.pinElement(cx, cy + 3, s.color, s.d, s.c, 0);
        }
    }

    private void removeFull() {
        int removed = 0;
        int mask = 1023;
        for (int i = 0; i < this.bgCollider.length; ++i) {
            int line = this.bgCollider[i];
            if ((line & mask) != mask) continue;
            ++removed;
            this.clearLine(i);
        }
        this.score += POINTS[removed];
        this.lines += removed;
        this.checkLevel();
    }

    private void render(Graphics g) {
        g.setBackground(Color.BLACK);
        g.clearRect(0, 0, this.getWidth(), this.getHeight());
        int bgx = (this.getWidth() - this.getBlockSize() * 15) / 2;
        int bgy = (this.getHeight() - this.getBlockSize() * 20) / 2;
        this.drawBackground(g, bgx, bgy);
        this.drawCurrentShape(g, bgx, bgy);
        if (this.gameOver) {
            g.setForeground(Color.WHITE);
            g.drawString("Game Over!", bgx + this.getBlockSize() * 10 / 2, bgy + this.getBlockSize() * 20 / 2);
        } else if (this.paused) {
            g.setForeground(Color.WHITE);
            g.drawString("PAUSED", bgx + this.getBlockSize() * 10 / 2, bgy + this.getBlockSize() * 20 / 2);
        }
    }

    private void restart() {
        this.timer.setDownPeriod(0L);
        this.timer.setNextBlink(0L);
        this.chooseNextShape();
        this.chooseRotation();
        for (int i = 0; i < 20; ++i) {
            this.bgCollider[i] = 0;
        }
        this.blinkCount = 3;
        this.score = 0;
        this.level = 0;
        this.lines = 0;
        this.dropping = false;
        this.paused = false;
        this.gameOver = false;
        this.timer.setDownPeriod(LEVEL_SPEED[this.level]);
        this.repaint();
    }

    private void unPause() {
        this.paused = false;
        this.timer.setDownPeriod(LEVEL_SPEED[this.level]);
    }

    private int getBlockSize() {
        int hb;
        int wb = this.getWidth() / 20;
        int s = Math.min(wb, hb = this.getHeight() / 30);
        return s < 3 ? 3 : s;
    }

    private class Timer
    implements Runnable {
        private long blinkPeriod;
        private boolean disposed;
        private long downPeriod;
        private long nextBlink;
        private long nextDown;
        private boolean recalculate;

        private Timer() {
        }

        public synchronized void setDownPeriod(long downPeriod) {
            this.downPeriod = downPeriod;
            this.nextDown = System.currentTimeMillis() + downPeriod;
            this.recalculate = true;
            this.notify();
        }

        public synchronized void setNextBlink(long blinkPeriod) {
            this.blinkPeriod = blinkPeriod;
            this.nextBlink = System.currentTimeMillis() + blinkPeriod;
            this.recalculate = true;
            this.notify();
        }

        public synchronized void dispose() {
            this.disposed = true;
            this.notify();
        }

        @Override
        public void run() {
            try {
                Timer timer = this;
                synchronized (timer) {
                    while (true) {
                        boolean isDown;
                        long nextExpiration;
                        long now = System.currentTimeMillis();
                        if (this.nextDown < this.nextBlink || this.blinkPeriod == 0L) {
                            nextExpiration = this.nextDown - now;
                            isDown = true;
                        } else if (this.downPeriod != 0L) {
                            nextExpiration = this.nextBlink - now;
                            isDown = false;
                        } else {
                            nextExpiration = 0L;
                            isDown = true;
                        }
                        if (nextExpiration >= 0L) {
                            this.wait(nextExpiration);
                            if (this.disposed) {
                                return;
                            }
                        }
                        if (!this.recalculate) {
                            now = System.currentTimeMillis();
                            if (isDown) {
                                this.nextDown = now + this.downPeriod;
                                UiUtilities.invokeLater(TWidget.this.downEvt);
                                continue;
                            }
                            this.blinkPeriod = 0L;
                            UiUtilities.invokeLater(TWidget.this.blinkEvt);
                            continue;
                        }
                        this.recalculate = false;
                    }
                }
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                return;
            }
        }
    }

    private class DownRunnable
    implements Runnable {
        private DownRunnable() {
        }

        @Override
        public void run() {
            TWidget.this.onDown();
        }
    }

    private class BlinkRunnable
    implements Runnable {
        private BlinkRunnable() {
        }

        @Override
        public void run() {
            TWidget.this.onBlink();
        }
    }

    private static class S {
        int a;
        int b;
        int c;
        int color;
        int d;
        private int offset;

        S(int a, int b, int c, int d, int color) {
            this(a, b, c, d, color, 0);
        }

        S(int a, int b, int c, int d, int color, int offset) {
            this.a = a;
            this.b = b;
            this.c = c;
            this.d = d;
            this.color = color;
            this.offset = offset;
        }
    }
}

