/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.ui;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.Button;
import oracle.bpm.ui.Image;
import oracle.bpm.ui.Label;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.Slider;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.event.ActionEvent;
import oracle.bpm.ui.event.ActionListener;
import oracle.bpm.ui.event.ChangeEvent;
import oracle.bpm.ui.event.ChangeListener;
import oracle.bpm.ui.layout.MigLayout;
import oracle.bpm.ui.msg.UIMsg;

public class SliderGroup
extends Panel
implements ChangeListener {
    private int available;
    private boolean enableAllSliders = false;
    private List<ChangeListener> listeners = new ArrayList<ChangeListener>();
    private int max;
    private int min;
    private int orientation;
    private boolean probability;
    private HashMap<SliderInfo, SliderGroupButton> sliders = new HashMap();

    public SliderGroup(UiContainer parent, int min, int max, int orientation) {
        super(parent);
        this.setLayout(new MigLayout());
        this.max = max;
        this.min = min;
        this.orientation = orientation;
        this.available = max;
    }

    public SliderGroup(UiContainer parent, int min, int max, int orientation, boolean probability) {
        this(parent, min, max, orientation);
        this.probability = probability;
    }

    public SliderGroup(UiContainer parent, List<SliderInfo> sliderInfos, int min, int max, int orientation) {
        this(parent, min, max, orientation);
        this.initSliders(sliderInfos);
    }

    public SliderGroup(UiContainer parent, List<SliderInfo> sliderInfos, int min, int max, int orientation, boolean probability) {
        this(parent, min, max, orientation, probability);
        this.initSliders(sliderInfos);
    }

    public static void main(String[] args) {
    }

    public void addChangeListener(ChangeListener listener) {
        this.listeners.add(listener);
    }

    public void initSliders(Collection<SliderInfo> items) {
        this.sliders.clear();
        if (items.size() > 0) {
            int exclusiveSliders = this.countSlidersWithExclusiveProbs(items);
            int value = this.max;
            int remainder = 0;
            if (exclusiveSliders > 0) {
                value = this.max / exclusiveSliders;
                remainder = this.max % exclusiveSliders;
            }
            for (SliderInfo info : items) {
                int sliderValue = this.max;
                if (info.hasExclusiveProbability()) {
                    sliderValue = value + remainder;
                    remainder = 0;
                }
                SliderGroupButton slider = new SliderGroupButton(this.getParent(), this.orientation, this.min, this.max, sliderValue, info);
                slider.addChangeListener(this);
                this.sliders.put(info, slider);
            }
        }
        this.build();
    }

    public void initSliders(Map<SliderInfo, Integer> items) {
        Integer integer;
        this.sliders.clear();
        int amount = this.max;
        int unvalued = 0;
        boolean isOneOrMoreExclusive = false;
        for (SliderInfo info : items.keySet()) {
            integer = items.get(info);
            int value = 0;
            if (integer != null) {
                value = integer;
                if (info.hasExclusiveProbability()) {
                    amount -= value;
                    isOneOrMoreExclusive = true;
                }
            } else {
                ++unvalued;
            }
            SliderGroupButton slider = new SliderGroupButton(this.getParent(), this.orientation, this.min, this.max, value, info);
            slider.addChangeListener(this);
            this.sliders.put(info, slider);
        }
        for (SliderInfo info : items.keySet()) {
            integer = items.get(info);
            if (integer != null) continue;
            this.setMutedValue(info, amount / unvalued);
            amount -= unvalued;
        }
        if (amount != 0 && isOneOrMoreExclusive) {
            this.initSliders(items.keySet());
            return;
        }
        this.build();
    }

    public void setValue(SliderInfo info, int value) {
        this.sliders.get(info).setValue(value);
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        ArrayList<SliderGroupButton> list = new ArrayList<SliderGroupButton>();
        SliderGroupButton slider = (SliderGroupButton)e.getSource();
        int diff = slider.getOldValue() - slider.getValue();
        if (diff == 0 || this.sliders.size() == 1) {
            return;
        }
        boolean inc = diff > 0;
        diff = Math.abs(diff);
        StringBuffer message = new StringBuffer("OldValue: " + slider.getOldValue() + ", New Value: " + slider.getValue());
        slider.setOldValue(slider.getValue());
        if (slider.isMuted()) {
            return;
        }
        for (Map.Entry<SliderInfo, SliderGroupButton> entry : this.sliders.entrySet()) {
            SliderInfo sliderInfo = entry.getKey();
            SliderGroupButton sliderGroupButton = entry.getValue();
            if (sliderGroupButton == slider && !sliderInfo.hasExclusiveProbability()) {
                return;
            }
            if (sliderGroupButton == slider || sliderGroupButton.isLocked() || !sliderInfo.hasExclusiveProbability()) continue;
            list.add(sliderGroupButton);
        }
        if (list.isEmpty()) {
            return;
        }
        int amount = diff / list.size();
        int remainder = diff % list.size();
        remainder = inc ? remainder : -remainder;
        amount = inc ? amount : -amount;
        message.append(",amount: " + amount);
        if (amount != 0) {
            for (SliderGroupButton sliderGroupButton : list) {
                int value = sliderGroupButton.getValue() + amount;
                sliderGroupButton.setMutedValue(value);
                if (value >= 0 && value <= this.max) continue;
                remainder += value;
            }
            slider.setMutedValue(slider.getValue() + remainder);
        } else {
            int nonZero = 0;
            Slider onlyOne = null;
            for (SliderGroupButton sliderGroupButton : list) {
                if (sliderGroupButton.getValue() == 0) continue;
                ++nonZero;
                onlyOne = sliderGroupButton;
            }
            if (nonZero != 1) {
                slider.setMutedValue(slider.getValue() + remainder);
            } else {
                ((SliderGroupButton)onlyOne).setMutedValue(onlyOne.getValue() + remainder);
            }
        }
        if (slider.getValue() == this.available) {
            slider.updateUI();
        }
        assert (this.assertTotal(diff, message, remainder)) : message.toString();
    }

    public int getValue(SliderInfo sliderInfo) {
        return this.sliders.get(sliderInfo).getValue();
    }

    public void setEnableAllSliders(boolean value) {
        this.enableAllSliders = value;
    }

    public boolean enableAllSliders() {
        return this.enableAllSliders;
    }

    private int countSlidersWithExclusiveProbs(Collection<SliderInfo> items) {
        int result = 0;
        for (SliderInfo info : items) {
            if (!info.hasExclusiveProbability()) continue;
            ++result;
        }
        return result;
    }

    private void fireChanged() {
        for (ChangeListener listener : this.listeners) {
            listener.stateChanged(new ChangeEvent(this));
        }
    }

    private void build() {
        this.removeAll();
        boolean enable = this.enableAllSliders() || this.sliders.values().size() > 1;
        for (final SliderGroupButton slider : this.sliders.values()) {
            final Label amountLabel = Label.create((UiContainer)this, this.getFormattedString(slider.getValue()));
            amountLabel.setHorizontalAlignment(0);
            Button button = new Button((UiContainer)this, Image.create(enable ? UIMsg.LOCK_OPEN : UIMsg.LOCK_CLOSED));
            button.setBorderPainted(false);
            button.setContentAreaFilled(false);
            button.setFocusable(false);
            button.setSelected(!enable);
            slider.setEnabled(enable);
            Image icon = slider.getInfo().getIcon();
            if (icon != null) {
                this.add(Label.create((UiContainer)this, icon));
            }
            this.add(Label.create((UiContainer)this, Msg.QUOTE(slider.getInfo().getText())));
            this.add(slider);
            if (this.sliders.size() > 2) {
                this.add(amountLabel, "w 25!");
                this.add(button, "wrap");
            } else {
                this.add(amountLabel, "w 25!, wrap");
            }
            slider.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    amountLabel.setText(SliderGroup.this.getFormattedString(slider.getValue()));
                    SliderGroup.this.fireChanged();
                }
            });
            button.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Button b = (Button)e.getSource();
                    boolean selected = b.isSelected();
                    if (!selected) {
                        int lockedCount = 1;
                        for (SliderGroupButton sliderGroupButton : SliderGroup.this.sliders.values()) {
                            lockedCount += sliderGroupButton.isLocked() ? 1 : 0;
                        }
                        if (SliderGroup.this.sliders.keySet().size() - lockedCount < 2) {
                            b.setSelected(false);
                        } else {
                            b.setSelected(true);
                        }
                    } else {
                        b.setSelected(false);
                    }
                    slider.locked = b.isSelected();
                    slider.setEnabled(!b.isSelected());
                    SliderGroup.this.available = SliderGroup.this.max;
                    for (SliderGroupButton sliderGroupButton : SliderGroup.this.sliders.values()) {
                        if (!sliderGroupButton.isLocked()) continue;
                        SliderGroup.this.available -= sliderGroupButton.getValue();
                    }
                    b.setIcon(b.isSelected() ? Image.create(UIMsg.LOCK_CLOSED) : Image.create(UIMsg.LOCK_OPEN));
                }
            });
        }
        if (this.sliders.values().size() == 1) {
            this.sliders.values().iterator().next().locked = true;
        }
    }

    private Msg getFormattedString(int value) {
        return Msg.QUOTE(this.probability ? String.valueOf((double)value / 100.0) : String.valueOf(value));
    }

    private void setMutedValue(SliderInfo info, int value) {
        this.sliders.get(info).setMutedValue(value);
    }

    private boolean assertTotal(int diff, StringBuffer message, int remainder) {
        int amount = 0;
        message.append(",diff: " + diff + " ,remainder: " + remainder);
        for (Map.Entry<SliderInfo, SliderGroupButton> entry : this.sliders.entrySet()) {
            SliderInfo sliderInfo = entry.getKey();
            SliderGroupButton sliderGroupButton = entry.getValue();
            if (!sliderInfo.hasExclusiveProbability()) continue;
            amount += sliderGroupButton.getValue();
            message.append(" " + sliderGroupButton.getValue());
        }
        return amount == this.max;
    }

    private static class SliderGroupButton
    extends Slider {
        private boolean locked = false;
        private boolean muted = false;
        private int oldValue;
        private SliderInfo sliderInfo;

        public SliderGroupButton(UiContainer parent, int orientation, int min, int max, int value, SliderInfo msg) {
            super(parent, orientation, min, max, value);
            this.oldValue = value;
            this.sliderInfo = msg;
        }

        public boolean isLocked() {
            return this.locked;
        }

        public int getOldValue() {
            return this.oldValue;
        }

        public void setMutedValue(int value) {
            this.muted = true;
            this.setValue(value);
            this.oldValue = this.getValue();
            this.muted = false;
        }

        public boolean isMuted() {
            return this.muted;
        }

        public void setOldValue(int value) {
            this.oldValue = value;
        }

        public SliderInfo getInfo() {
            return this.sliderInfo;
        }
    }

    public static class SliderInfo {
        private boolean hasExclusiveProbability = true;
        private Image icon;
        private String text;

        public SliderInfo(String text) {
            this.text = text;
        }

        public SliderInfo(String text, Image icon) {
            this(text);
            this.icon = icon;
        }

        public SliderInfo(String text, Image icon, boolean hasExclusiveProbability) {
            this(text, icon);
            this.hasExclusiveProbability = hasExclusiveProbability;
        }

        public Image getIcon() {
            return this.icon;
        }

        public String getText() {
            return this.text;
        }

        public boolean hasExclusiveProbability() {
            return this.hasExclusiveProbability;
        }
    }
}

