/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.ui;

import oracle.bpm.resources.Msg;
import oracle.bpm.ui.Label;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.Separator;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.layout.form.CellConstraints;
import oracle.bpm.ui.layout.form.FormLayout;
import oracle.bpm.ui.layout.form.PanelBuilder;

public class SeparatorPanel
extends Panel {
    private Label titleLabel;
    public static final int BESIDES_TEXT = 0;
    public static final int BELOW_TEXT = 1;
    public static final int DEFAULT_POSITION = 0;

    public SeparatorPanel(UiContainer parent, Msg title) {
        this(parent, title, 0);
    }

    public SeparatorPanel(UiContainer parent, Msg title, int linePosition) {
        super(parent);
        this.titleLabel = Label.createWithNoColon(this, title);
        this.buildSeparator(linePosition);
    }

    private void buildSeparator(int linePosition) {
        switch (linePosition) {
            case 0: {
                this.initBesidesTextSeparator();
                break;
            }
            case 1: {
                this.initBelowTextSeparator();
                break;
            }
            default: {
                this.initBesidesTextSeparator();
            }
        }
    }

    private void initBelowTextSeparator() {
        String cols = "1dlu, pref, pref:grow, 1dlu";
        String rows = "pref, 2dlu, pref";
        FormLayout layout = new FormLayout(cols, rows);
        PanelBuilder builder = layout.createBuilder(this);
        CellConstraints cc = layout.createCellConstraints();
        builder.add((UiComponent)this.titleLabel, cc.xy(2, 1));
        builder.add((UiComponent)new Separator(this), cc.xywh(2, 3, 2, 1));
    }

    private void initBesidesTextSeparator() {
        String cols = "1dlu, pref, 2dlu, pref:grow, 1dlu";
        String rows = "pref";
        FormLayout layout = new FormLayout(cols, rows);
        PanelBuilder builder = layout.createBuilder(this);
        CellConstraints cc = layout.createCellConstraints();
        builder.add((UiComponent)this.titleLabel, cc.xy(2, 1));
        builder.add((UiComponent)new Separator(this), cc.xy(4, 1));
    }
}

